set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9211089';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.087844,
      0,
      3.034437,
      0,
      3.255412,
      1.670446,
      3,
      2.671466,
      '412',
      '14221111',
      70.683480,
      60,
      '1443342',
      3.053122,
      0,
      0,
      NULL,
      '3413',
      5.534361,
      1.743300,
      NULL,
      NULL,
      ' 7- 5-1992',
      94,
      32,
      NULL,
      2,
      0.546101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-17-1984',
      3,
      NULL,
      0.318214,
      2.454306,
      0.806771,
      1,
      NULL,
      0.788845,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.726433,
      1,
      1.234251,
      2.377798,
      NULL,
      1.679252,
      0.626316,
      0,
      1,
      0.862991,
      1.681194,
      0,
      NULL,
      0.934262,
      1,
      1.926992,
      5,
      1.032757,
      1,
      0.481480,
      0.376597,
      NULL,
      NULL,
      NULL,
      0.998193,
      NULL,
      NULL,
      0.928450,
      1.762675,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.508163,
      0.971143,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100271,
      0.870526,
      1,
      1.726633,
      0.477656,
      0,
      0,
      0.889289,
      1,
      1.022332,
      1.463308,
      1.445258,
      NULL,
      NULL,
      0.770317,
      0,
      1.548745,
      NULL,
      3,
      1.485397,
      5,
      1.433613,
      1,
      1,
      0.045907,
      0.544018,
      0,
      4.794665,
      NULL,
      0,
      0.590132,
      0.984229,
      0.744034,
      1,
      1.667034,
      0,
      NULL,
      0.858492,
      2.445503,
      6.698132,
      NULL,
      2,
      5.830153,
      4.980038,
      1.369518,
      2.493617,
      NULL,
      1.605834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.465867,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.638531,
      1,
      NULL,
      3.895917,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.709159,
      NULL,
      0.510849,
      0.686280,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090774,
      5.942175,
      2.194237,
      1.980041,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.977245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.581489,
      NULL,
      1.004417,
      1,
      1,
      NULL,
      NULL,
      0.514593,
      NULL,
      1.984399,
      2,
      1,
      NULL,
      NULL,
      2.375082,
      4.926859,
      2.387887,
      4,
      NULL,
      0,
      3,
      NULL,
      1.935686,
      5.292506,
      1,
      3,
      0,
      0.902014,
      0.511214,
      1.179127,
      3.744520,
      0,
      NULL,
      NULL,
      NULL,
      0.775293,
      1.428112,
      0.464642,
      1.775779,
      1.738607,
      2.698482,
      3.458211,
      0.289098,
      7.913876,
      6.685269,
      4,
      NULL,
      NULL,
      3,
      2.115586,
      1.101743,
      4.619801,
      3.481270,
      NULL,
      0.916360,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219380,
      5,
      1,
      '30223',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      44.668882,
      63.168791,
      NULL,
      0.470462,
      NULL,
      NULL,
      3.929674,
      1,
      NULL,
      0,
      3.063956,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      3.033908,
      1.567762,
      0.781654,
      0.019294,
      NULL,
      NULL,
      1,
      2.964173,
      1.576152,
      2,
      2,
      0.163604,
      0.787642,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.073616,
      8.340020,
      1.754640,
      NULL,
      2.480385,
      NULL,
      3.647457,
      NULL,
      0.011612,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.606987,
      1.870739,
      NULL,
      NULL,
      0.527461,
      0.308652,
      0,
      NULL,
      0,
      0.663016,
      1,
      1,
      0,
      3,
      0,
      0,
      2.264865,
      2,
      0.837863,
      3,
      NULL,
      NULL,
      1.423921,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      0.858765,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.175623,
      NULL,
      2.387597,
      1,
      2,
      2.305864,
      1.799416,
      1,
      NULL,
      NULL,
      7,
      6,
      0.207179,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.903084,
      1,
      1.586054,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035198,
      NULL,
      NULL,
      0,
      0.988631,
      1.198253,
      9.680707,
      NULL,
      1,
      1.422515,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.080048,
      1.363280,
      4,
      NULL,
      0,
      0.597594,
      NULL,
      NULL,
      0.254762,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      NULL,
      2,
      0,
      3.174163,
      0.747169,
      NULL,
      3,
      2,
      NULL,
      1.868369,
      3,
      1,
      8,
      NULL,
      1,
      11,
      10,
      1,
      1,
      3,
      1.132128,
      1,
      0,
      2,
      NULL,
      NULL,
      3.838262,
      NULL,
      8,
      0,
      NULL,
      18.410406,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.848740,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.115663,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3.784473,
      2,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3.045924,
      0,
      NULL,
      NULL,
      2,
      NULL,
      4.823080,
      10.187238,
      NULL,
      5.246917,
      1.637769,
      0,
      0,
      1,
      NULL,
      1,
      0.966985,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757572,
      0.493599,
      NULL,
      NULL,
      1.079863,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.986716,
      0,
      NULL,
      NULL,
      0,
      0.832017,
      NULL,
      NULL,
      NULL,
      1.895289,
      NULL,
      NULL,
      0,
      1.164013,
      NULL,
      NULL,
      1,
      3.718447,
      NULL,
      NULL,
      0.579692,
      1.019068,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.424440,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.693476,
      NULL,
      NULL,
      1.732805,
      1.313050,
      NULL,
      NULL,
      1.937235,
      1.201831,
      NULL,
      NULL,
      3.692746,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.395517,
      59.158618,
      7,
      1.000208,
      NULL,
      0.461228,
      0.421243,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.950801,
      7,
      6,
      1.651513,
      NULL,
      NULL,
      0.793813,
      NULL,
      0.131958,
      0,
      0,
      NULL,
      NULL,
      1.796834,
      0.399681,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.827409,
      1.180238,
      0.414883,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296750,
      0,
      0.000943,
      1,
      3.616163,
      5,
      0.447779,
      3,
      7,
      2,
      1,
      2,
      NULL,
      0.718746,
      1,
      1.863661,
      0.009473,
      NULL,
      0,
      1.461436,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      1.534933,
      NULL,
      3.084590,
      NULL,
      1,
      1,
      1.157172,
      NULL,
      NULL,
      1,
      1,
      0.406615,
      1.718636,
      NULL,
      0.591707,
      1.523488,
      1.474771,
      0,
      1.178989,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.701211,
      NULL,
      1.425226,
      NULL,
      NULL,
      NULL,
      1.928228,
      NULL,
      NULL,
      62,
      16,
      1,
      3.343313,
      1,
      '42303',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


