set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614546';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3,
      2.901871,
      0.585090,
      0,
      NULL,
      0,
      0.303536,
      '430',
      '23110002',
      14.851084,
      NULL,
      '3122411',
      0.337124,
      NULL,
      1,
      3,
      '2022',
      NULL,
      0.019789,
      NULL,
      NULL,
      NULL,
      33,
      NULL,
      NULL,
      1,
      1,
      ' 3-20-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      1.115890,
      ' 9-18-1989',
      ' 2-28-2001',
      ' 8- 6-1977',
      2,
      3,
      NULL,
      1.763223,
      0,
      1,
      NULL,
      2.566514,
      NULL,
      NULL,
      NULL,
      5.437530,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.067074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.166525,
      2,
      0.222728,
      NULL,
      NULL,
      1,
      1.792041,
      0.267981,
      0,
      10.674688,
      0.126847,
      1,
      0,
      1,
      0.504722,
      7.259378,
      1.220377,
      3.303039,
      1.234835,
      1.785899,
      0.154953,
      NULL,
      NULL,
      0.856218,
      NULL,
      NULL,
      0.415298,
      1.975701,
      3,
      3.000120,
      1,
      1.841908,
      2,
      0,
      1.807941,
      1,
      NULL,
      0,
      0,
      2.748183,
      1,
      NULL,
      1,
      0.564990,
      0.967714,
      1,
      0.968375,
      1,
      2.910553,
      0.600102,
      NULL,
      1.653709,
      NULL,
      NULL,
      NULL,
      0.090783,
      NULL,
      NULL,
      1.675210,
      1.664827,
      1,
      NULL,
      0,
      0.959176,
      3.451512,
      NULL,
      1,
      NULL,
      4,
      0,
      1.445280,
      4,
      1.214497,
      1.864133,
      0,
      0.505588,
      1,
      NULL,
      0.559182,
      0.705972,
      1.315446,
      1,
      1,
      1.542845,
      NULL,
      2,
      7.379616,
      3,
      2.205658,
      0.776847,
      1.977096,
      5.804330,
      NULL,
      NULL,
      2,
      1,
      0.472618,
      1,
      0.034088,
      0.723193,
      0.890489,
      NULL,
      5,
      1,
      1.934475,
      2,
      ' 8-25-1996',
      471.467164,
      ' 8- 5-1990',
      268.874462,
      1,
      0.451526,
      0,
      NULL,
      1.597091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.539080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.583348,
      0,
      2,
      0.075966,
      3,
      0.540182,
      2.031110,
      0.066399,
      4,
      3.741294,
      1.284040,
      3.573577,
      0.337851,
      NULL,
      NULL,
      NULL,
      0,
      2.913897,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.621158,
      NULL,
      1.879878,
      0.160446,
      1,
      0,
      NULL,
      NULL,
      0.005280,
      0.875803,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0,
      0.560800,
      1,
      3,
      0.603236,
      2,
      0.862901,
      NULL,
      1,
      0.341943,
      1.705046,
      0.031253,
      1,
      3,
      0,
      0,
      0.840974,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      6.069366,
      5,
      0.723782,
      NULL,
      6.431337,
      NULL,
      NULL,
      NULL,
      58,
      1,
      1,
      11,
      NULL,
      17.009001,
      39.013464,
      NULL,
      4.549161,
      0.673382,
      '30032',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      1.239557,
      NULL,
      '',
      '',
      1.351509,
      41.367633,
      92.465657,
      NULL,
      0.443144,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.545881,
      NULL,
      NULL,
      0.185102,
      NULL,
      NULL,
      NULL,
      0,
      1.415122,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.849270,
      NULL,
      NULL,
      0.658085,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.096264,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.208302,
      NULL,
      NULL,
      NULL,
      3,
      1.853485,
      2,
      NULL,
      NULL,
      NULL,
      3.756941,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.893767,
      NULL,
      NULL,
      1,
      6,
      0.895544,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.211198,
      NULL,
      NULL,
      NULL,
      1.266482,
      NULL,
      NULL,
      0.030217,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.098002,
      NULL,
      NULL,
      0.222117,
      NULL,
      NULL,
      0.768685,
      0,
      0.765871,
      NULL,
      0.062097,
      1.703328,
      1.031241,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.491621,
      NULL,
      NULL,
      1.484558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238145,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.381339,
      0,
      0.710853,
      NULL,
      NULL,
      0.618811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316676,
      1.079903,
      2.235470,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.074393,
      NULL,
      5.478668,
      0,
      NULL,
      1,
      1.449815,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566456,
      NULL,
      NULL,
      0.032341,
      NULL,
      NULL,
      1.304773,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.510563,
      NULL,
      NULL,
      0.864345,
      NULL,
      NULL,
      1.304268,
      NULL,
      NULL,
      0.984181,
      1.866831,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.552265,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.323894,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.960679,
      NULL,
      NULL,
      NULL,
      2.131604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.049998,
      NULL,
      NULL,
      0.610802,
      NULL,
      NULL,
      1.014258,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.711925,
      257.056563,
      1.601790,
      1.375848,
      1.340146,
      NULL,
      NULL,
      0.129543,
      0.913198,
      0,
      NULL,
      1,
      1,
      1.729194,
      NULL,
      1,
      1.152015,
      1.309685,
      1,
      1,
      1.817752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786523,
      6.508363,
      4.518811,
      9,
      2.876908,
      2.334443,
      NULL,
      1,
      1,
      2.839565,
      0.694369,
      1,
      0.324158,
      0.761615,
      NULL,
      0.927923,
      1.398340,
      NULL,
      1.449666,
      NULL,
      NULL,
      NULL,
      1.856151,
      NULL,
      NULL,
      0.004999,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.710533,
      NULL,
      1.973726,
      1.947107,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404985,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1.730509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381798,
      5,
      NULL,
      '40332',
      '',
      '',
      1.836691,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


