set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7302006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.901440,
      0.340316,
      5,
      3,
      6.119292,
      0.650577,
      2,
      1,
      NULL,
      '13033012',
      58.249860,
      69.913494,
      '3132241',
      0.627168,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.544205,
      NULL,
      NULL,
      NULL,
      206,
      11.907251,
      NULL,
      NULL,
      1.984195,
      ' 7-14-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0.599463,
      ' 1- 3-1991',
      ' 3- 3-1999',
      NULL,
      0,
      1,
      1.977563,
      1,
      NULL,
      3.591930,
      0,
      0.227884,
      0.532818,
      6,
      4,
      8,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      1.130798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      11.733556,
      3,
      6,
      NULL,
      NULL,
      0.679038,
      7.228481,
      NULL,
      10.012423,
      2.383909,
      3.737524,
      NULL,
      NULL,
      0,
      5,
      1.203846,
      5.066002,
      NULL,
      1.537783,
      NULL,
      NULL,
      NULL,
      0.772649,
      NULL,
      NULL,
      0.016020,
      1,
      NULL,
      0.559913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.602311,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868497,
      7,
      3.240875,
      3.188608,
      0.628046,
      3,
      0.988243,
      1,
      9.660049,
      NULL,
      5.812428,
      0.620631,
      2.931869,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.883032,
      0.732981,
      2,
      6,
      NULL,
      1.987965,
      1,
      0.292342,
      NULL,
      1.973915,
      NULL,
      0,
      1.651874,
      NULL,
      3,
      0.554331,
      NULL,
      3.125586,
      5,
      NULL,
      7,
      1.983974,
      0.308606,
      3,
      3,
      ' 8-29-1975',
      1199,
      ' 0- 0-1993',
      570.188120,
      0,
      1.309651,
      0.406870,
      1.608491,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      0,
      NULL,
      5.776552,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.819447,
      3.120873,
      NULL,
      1.600822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      3,
      0,
      3,
      1,
      4.473291,
      9.948414,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.968262,
      1,
      0,
      0.175484,
      0.290541,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.023846,
      1.898305,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      2.202033,
      2.353301,
      0.772584,
      2,
      3.232129,
      2.591657,
      0,
      1,
      1.896703,
      9.311720,
      1,
      1.190888,
      1,
      0.382427,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.315796,
      NULL,
      1,
      8,
      NULL,
      NULL,
      0,
      0.803874,
      1.709744,
      4.529094,
      2.903763,
      5.365734,
      1,
      NULL,
      NULL,
      36.215794,
      3.953730,
      0,
      34.038146,
      NULL,
      NULL,
      67.409746,
      2,
      4.518648,
      0,
      '30243',
      '',
      '',
      1.656762,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.850205,
      NULL,
      605.044303,
      17,
      NULL,
      58.838526,
      0,
      1,
      0,
      3.553925,
      1.034771,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913027,
      NULL,
      NULL,
      1.864500,
      0,
      0,
      1.608502,
      0,
      0,
      3.469000,
      0,
      NULL,
      NULL,
      1.232615,
      1,
      0.507193,
      NULL,
      NULL,
      1.517268,
      NULL,
      NULL,
      0.577802,
      NULL,
      NULL,
      0.262554,
      NULL,
      NULL,
      4.947660,
      1,
      0.757396,
      1.033472,
      NULL,
      NULL,
      NULL,
      NULL,
      0.943963,
      NULL,
      NULL,
      NULL,
      0.345546,
      0,
      1.199668,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.864393,
      0.816834,
      1.601801,
      3.529421,
      NULL,
      1,
      3.268231,
      0.086067,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.275350,
      2,
      1.485282,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.774464,
      1.139835,
      NULL,
      NULL,
      0,
      1.166473,
      0,
      NULL,
      NULL,
      NULL,
      1.530944,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.684370,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170732,
      0,
      0,
      1.506380,
      2.780313,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.007519,
      NULL,
      NULL,
      1.804326,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0.819855,
      0,
      NULL,
      NULL,
      0.423427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629124,
      0.490141,
      0,
      2,
      3,
      2,
      0,
      NULL,
      5.550319,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.057408,
      2,
      2,
      NULL,
      NULL,
      1.473475,
      2.479787,
      2,
      1,
      3,
      NULL,
      NULL,
      1,
      0.192629,
      NULL,
      1,
      NULL,
      1.766174,
      0.442266,
      1,
      3.002537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.751651,
      NULL,
      NULL,
      1.861948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.299175,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      0.577744,
      0,
      2,
      1.561709,
      NULL,
      NULL,
      3.125219,
      NULL,
      NULL,
      NULL,
      40,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.651855,
      NULL,
      NULL,
      NULL,
      1.615197,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.189123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.700877,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.123994,
      NULL,
      NULL,
      NULL,
      2,
      1.816554,
      0.015608,
      0.949143,
      1.837304,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.880926,
      NULL,
      NULL,
      1.276555,
      NULL,
      NULL,
      0,
      NULL,
      1.338177,
      1.511450,
      0.897367,
      1,
      0,
      0.135519,
      0,
      0,
      NULL,
      1.287631,
      0,
      1.636857,
      NULL,
      0,
      0.244498,
      1.131386,
      0,
      1.684734,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.966406,
      NULL,
      NULL,
      3,
      0,
      3.027589,
      NULL,
      NULL,
      2,
      0.908486,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      0.364476,
      NULL,
      0.917069,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.993419,
      0,
      NULL,
      2.269996,
      NULL,
      NULL,
      0.563635,
      0.638713,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492297,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.295249,
      0.596989,
      1.603802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439237,
      NULL,
      1,
      NULL,
      1,
      5.852523,
      8.824446,
      0,
      NULL,
      NULL,
      66,
      12.328682,
      0.315379,
      NULL,
      3.664279,
      '23103',
      NULL,
      '',
      0.437054,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


