set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9511616';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1230042',
      NULL,
      0,
      1,
      1,
      '1413',
      2.328598,
      0.257426,
      NULL,
      NULL,
      ' 4-24-2002',
      NULL,
      NULL,
      3.940802,
      3.847667,
      NULL,
      NULL,
      17,
      2.625358,
      158.824026,
      22.482396,
      3.014818,
      ' 3- 1-1988',
      ' 5- 3-1984',
      ' 4-25-1998',
      NULL,
      2.399796,
      0.127035,
      NULL,
      1.311454,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.340576,
      24,
      21.261355,
      NULL,
      4,
      0.938874,
      NULL,
      6,
      0.911480,
      NULL,
      NULL,
      0,
      NULL,
      1.836997,
      0,
      1.944995,
      1.247899,
      NULL,
      0.165164,
      3,
      2,
      3.273418,
      2,
      0.848248,
      0,
      0.967377,
      1.758184,
      NULL,
      0,
      6.259700,
      0,
      0,
      0,
      1,
      NULL,
      3.020619,
      0,
      0,
      3.276336,
      NULL,
      0.262261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991845,
      0.530536,
      1,
      1.242653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338747,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.444991,
      0.552453,
      0.543673,
      NULL,
      NULL,
      5.396387,
      0.732426,
      0,
      NULL,
      2.875781,
      1,
      1,
      0.191448,
      1,
      1.202386,
      NULL,
      1.994073,
      1,
      NULL,
      0,
      1.778089,
      NULL,
      1.033118,
      2,
      NULL,
      NULL,
      0,
      0.549489,
      0,
      4.549327,
      1.064960,
      1,
      1,
      0,
      1.669432,
      2,
      2,
      NULL,
      0.611775,
      3,
      0.415452,
      NULL,
      0.217137,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.075523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.272887,
      1,
      6,
      1,
      NULL,
      1,
      1.745372,
      1.510319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      120,
      1,
      0.426565,
      1.157890,
      1,
      0,
      0.975164,
      3,
      2.152300,
      4,
      1,
      NULL,
      0.674820,
      NULL,
      1.472468,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.476759,
      NULL,
      NULL,
      NULL,
      1.669181,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354458,
      0.918599,
      NULL,
      NULL,
      0.191624,
      1.467409,
      0,
      6.583586,
      2.031475,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342286,
      NULL,
      3.201648,
      NULL,
      0,
      2.252616,
      NULL,
      1,
      1,
      NULL,
      0.457691,
      2,
      3,
      NULL,
      NULL,
      0.636222,
      1,
      NULL,
      1.128491,
      4,
      1,
      0.708867,
      0,
      0,
      1.594990,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.011178,
      0,
      3.636942,
      NULL,
      7.554998,
      3.546131,
      3.830247,
      1,
      1.926642,
      1.516975,
      0.997937,
      2,
      2,
      3.631950,
      51.997768,
      0.839585,
      NULL,
      NULL,
      NULL,
      NULL,
      70.629516,
      0.648856,
      5.038426,
      NULL,
      '34431',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      8.230026,
      35.226538,
      NULL,
      0.196629,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.212413,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.191233,
      1.499830,
      3,
      3.123396,
      2.429268,
      2.283185,
      0.760592,
      NULL,
      NULL,
      1.688784,
      0.022706,
      3,
      1.343016,
      NULL,
      NULL,
      3.275199,
      NULL,
      3.140540,
      1.363408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.270840,
      NULL,
      NULL,
      5.512412,
      5,
      0.898722,
      0.516996,
      0.529700,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.857937,
      NULL,
      NULL,
      1.750391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789081,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.014198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.694264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262955,
      NULL,
      NULL,
      0.458666,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.345223,
      NULL,
      NULL,
      0.940813,
      NULL,
      NULL,
      0.434241,
      2.021794,
      2,
      0.595354,
      NULL,
      NULL,
      1.453581,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.293560,
      NULL,
      NULL,
      0.513371,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738160,
      NULL,
      NULL,
      3.170598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942407,
      NULL,
      NULL,
      1,
      1.012238,
      0.793540,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361912,
      NULL,
      1.013846,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.742230,
      NULL,
      NULL,
      0,
      NULL,
      1.769810,
      NULL,
      1.101549,
      0.462564,
      NULL,
      1.363008,
      0,
      NULL,
      1.896516,
      1.865324,
      0.794103,
      0,
      1,
      0.743307,
      0.850247,
      1,
      1.581590,
      1.729881,
      NULL,
      0.880676,
      1.741139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.943885,
      NULL,
      0,
      NULL,
      1.707048,
      NULL,
      2,
      5.142236,
      5,
      2.963736,
      3.782129,
      0,
      1.053482,
      1,
      NULL,
      2.171195,
      0,
      NULL,
      1,
      1.040819,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.072233,
      NULL,
      0,
      0.947383,
      NULL,
      1.476443,
      0.717390,
      NULL,
      1.902113,
      NULL,
      NULL,
      0.500844,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.627968,
      2,
      NULL,
      2,
      NULL,
      2.865969,
      NULL,
      0.202495,
      NULL,
      1,
      NULL,
      0.425685,
      NULL,
      0.205199,
      NULL,
      0.246825,
      NULL,
      1.066901,
      NULL,
      NULL,
      NULL,
      0.990874,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      34,
      1.931766,
      19.026770,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.252429,
      NULL,
      1,
      NULL,
      NULL,
      104.694550,
      33.343505,
      0.162819,
      3,
      NULL,
      '43220',
      '',
      '',
      1.552104,
      NULL,
      '',
      '',
      0.810257,
      NULL,
      NULL,
      NULL);
commit;
end;
/


