set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5601823';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3140223',
      1,
      NULL,
      2,
      NULL,
      '0130',
      NULL,
      0,
      NULL,
      NULL,
      ' 7-14-1997',
      2.876897,
      NULL,
      NULL,
      NULL,
      0.849096,
      ' 5-19-1994',
      NULL,
      2.441462,
      339,
      111,
      1.474923,
      NULL,
      NULL,
      ' 3- 7-1982',
      2.479495,
      0,
      NULL,
      1.500265,
      0,
      3.691350,
      1,
      1,
      NULL,
      NULL,
      NULL,
      4.714794,
      NULL,
      6.788180,
      11.050453,
      3,
      14.906303,
      2.727192,
      1.510767,
      7,
      1.003837,
      1,
      1.447303,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.532009,
      0.671746,
      0.808653,
      1.711628,
      0.351098,
      0.128392,
      0.007703,
      0,
      1.047529,
      1.813970,
      0.186145,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.487387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266440,
      1.952489,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.233133,
      NULL,
      1,
      NULL,
      NULL,
      0.536189,
      0,
      NULL,
      3.597088,
      4.692972,
      NULL,
      NULL,
      NULL,
      1,
      1.169181,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.634534,
      1,
      1,
      1,
      0.890961,
      NULL,
      NULL,
      1.253568,
      1.722411,
      NULL,
      1,
      0.907058,
      1.776085,
      1,
      1.802685,
      1.747025,
      0,
      0.670651,
      1,
      0.481499,
      3.256458,
      3.860608,
      1,
      1,
      0.948277,
      1.024405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.944431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.212896,
      0.924717,
      0.607137,
      NULL,
      2,
      0.953391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755342,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1.996046,
      0.830122,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.367649,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879921,
      0,
      NULL,
      1.969485,
      0,
      NULL,
      0,
      NULL,
      0.939335,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      43.056280,
      NULL,
      NULL,
      NULL,
      3.891068,
      1,
      2,
      '40444',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      0,
      4.054661,
      583,
      6.728509,
      0,
      34,
      NULL,
      NULL,
      1,
      3,
      3,
      1,
      0.861962,
      NULL,
      NULL,
      1.148955,
      NULL,
      1,
      0.668482,
      NULL,
      NULL,
      0.359509,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.814344,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.858022,
      NULL,
      NULL,
      0.729987,
      NULL,
      NULL,
      11.135007,
      0.187823,
      1.631153,
      4,
      0.194283,
      NULL,
      NULL,
      NULL,
      0.570689,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.455097,
      1.191840,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1.873214,
      0.391109,
      NULL,
      1.884316,
      0.538407,
      0.810637,
      NULL,
      1.924122,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.337438,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254634,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.084645,
      NULL,
      NULL,
      0,
      0,
      0.654363,
      0.072500,
      2.969346,
      1.326763,
      1,
      NULL,
      NULL,
      8.815453,
      4,
      0.404307,
      NULL,
      2,
      0.935889,
      2.664592,
      NULL,
      NULL,
      NULL,
      NULL,
      3.178561,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.442263,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.274714,
      NULL,
      NULL,
      7,
      5,
      NULL,
      3,
      3,
      0.879155,
      2,
      3,
      1,
      6,
      NULL,
      1,
      5.229795,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.751732,
      13.973726,
      NULL,
      NULL,
      8.981452,
      NULL,
      0,
      3,
      0,
      0,
      1,
      2.747597,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      9,
      5.423146,
      NULL,
      3,
      7.145439,
      0.184822,
      3,
      3.036033,
      2,
      0,
      0,
      1.284041,
      1.245152,
      0.034885,
      1.623099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.335351,
      2,
      0,
      1.151144,
      0,
      0.681276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      1.780744,
      NULL,
      NULL,
      NULL,
      0.788876,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.509255,
      NULL,
      NULL,
      NULL,
      2.178673,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869551,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.843967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      974,
      NULL,
      1.498605,
      1856.008124,
      1996,
      NULL,
      NULL,
      NULL,
      1.652448,
      NULL,
      164,
      1,
      677,
      1837,
      NULL,
      NULL,
      NULL,
      3.722577,
      3.073671,
      1,
      96,
      7,
      1.862729,
      1.622192,
      0.795055,
      0,
      0.247926,
      NULL,
      1.578951,
      0.478145,
      1,
      0,
      1,
      0,
      0.971228,
      1,
      NULL,
      0.781712,
      1.323411,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947344,
      0,
      NULL,
      1.592446,
      2,
      2,
      5.436092,
      6.587553,
      9.999492,
      1,
      3.756942,
      0,
      1.929708,
      0,
      0.085450,
      0.011321,
      1,
      0.518710,
      1,
      0,
      1.248837,
      0,
      0,
      0,
      0.391143,
      0.603195,
      1.686969,
      NULL,
      2,
      1,
      1.790056,
      3.663190,
      0.867030,
      NULL,
      NULL,
      0.415202,
      0.125933,
      0.059192,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.383524,
      NULL,
      NULL,
      0.455435,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762737,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.065155,
      NULL,
      0.544609,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      152.997429,
      0,
      1119.607912,
      0.720991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.950745,
      0.563837,
      1.721155,
      0,
      1,
      0,
      11,
      2,
      1.402502,
      2.120417,
      25,
      2,
      NULL,
      1.111718,
      5,
      '31334',
      '43421',
      '24303',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


