set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8220268';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      3.409311,
      1,
      0,
      0,
      '3330',
      2.317582,
      1.034610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.134177,
      0,
      NULL,
      12,
      2.464896,
      111.288082,
      NULL,
      1.251762,
      ' 1-22-1986',
      '11-14-1996',
      ' 4-21-1997',
      2,
      NULL,
      2.341403,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      324,
      0.214906,
      NULL,
      5.297269,
      164.250393,
      NULL,
      6.716337,
      26,
      NULL,
      1,
      5.869640,
      1,
      NULL,
      1,
      1,
      1.304177,
      0.573336,
      0.704377,
      1.345135,
      1,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      5.008010,
      NULL,
      1,
      0,
      1.286813,
      7,
      3,
      NULL,
      3,
      NULL,
      1,
      NULL,
      8.925852,
      1,
      4,
      5,
      2.313365,
      0.583454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.513774,
      3,
      3,
      2,
      NULL,
      2.101580,
      2.534608,
      1.192116,
      2,
      2,
      NULL,
      NULL,
      0.555020,
      1.719192,
      1,
      3.222963,
      NULL,
      2,
      0.929890,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.552785,
      0,
      0.787942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.659511,
      1,
      0,
      0.452053,
      5.938070,
      0,
      0,
      0.514191,
      4,
      2.547855,
      NULL,
      NULL,
      6,
      1,
      0.874974,
      1.765690,
      1.644278,
      2.263926,
      NULL,
      1,
      6.192051,
      NULL,
      0,
      7,
      NULL,
      NULL,
      0,
      NULL,
      9.035559,
      3.374369,
      6.213892,
      NULL,
      6.255154,
      8.125321,
      10,
      10.622175,
      1.214314,
      5.343577,
      11.617771,
      3.482883,
      10.379014,
      1,
      9,
      NULL,
      9,
      NULL,
      1,
      ' 4-13-1986',
      NULL,
      ' 2- 6-1998',
      712.773021,
      0.963864,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      0,
      0,
      2,
      2.436066,
      NULL,
      0,
      6.250147,
      0,
      0.505872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.055618,
      NULL,
      2.946058,
      0.396444,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.975308,
      0,
      0.580307,
      2.414492,
      2,
      NULL,
      0.709976,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0.255603,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.424976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.326084,
      1,
      0.401281,
      2,
      0.814377,
      1.185655,
      0,
      1.430352,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.965812,
      3.633960,
      NULL,
      0.415898,
      2,
      NULL,
      1,
      2.649488,
      3,
      2.513592,
      NULL,
      NULL,
      0,
      0.233182,
      0,
      2,
      NULL,
      9.358204,
      10.891548,
      NULL,
      50,
      140.463376,
      73.363138,
      1.939487,
      0.361949,
      0,
      1.758170,
      NULL,
      1.698006,
      0.077829,
      9.089410,
      8.090967,
      1,
      9.522774,
      3.279048,
      0.246778,
      4,
      8.494204,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      2,
      2,
      NULL,
      41.636600,
      14,
      43.837472,
      0.238809,
      1,
      2.831587,
      '44234',
      '',
      NULL,
      0.415556,
      '',
      '',
      '',
      3,
      '10133',
      '',
      '',
      1,
      21.993870,
      NULL,
      23,
      1.063041,
      21,
      NULL,
      NULL,
      NULL,
      1.080797,
      2.475300,
      3.464478,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.149921,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.166458,
      NULL,
      NULL,
      1.151952,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.057322,
      NULL,
      NULL,
      1.737961,
      NULL,
      NULL,
      0.048057,
      1,
      NULL,
      NULL,
      NULL,
      0.253751,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2.021323,
      1,
      NULL,
      0,
      0.230787,
      NULL,
      NULL,
      3.596029,
      2,
      3.995771,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.695178,
      0,
      NULL,
      3.197798,
      3,
      1,
      2.848365,
      0,
      NULL,
      NULL,
      0.478849,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11,
      7.382668,
      7,
      1,
      1.385358,
      NULL,
      NULL,
      NULL,
      1.080772,
      NULL,
      NULL,
      NULL,
      0.334292,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.909663,
      NULL,
      NULL,
      5.468921,
      3.874346,
      3,
      0,
      NULL,
      0.826052,
      NULL,
      0.113305,
      0.317644,
      2.543568,
      6,
      0,
      NULL,
      NULL,
      NULL,
      1.947554,
      NULL,
      NULL,
      1.294597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124898,
      0.139578,
      1.692755,
      2.836506,
      1,
      0.588604,
      2.435778,
      0,
      1,
      0.212374,
      NULL,
      0,
      1,
      0,
      0.981223,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680435,
      1.525241,
      3.521905,
      1,
      0,
      1,
      NULL,
      1,
      0.320384,
      1,
      2.417778,
      3,
      1.790183,
      NULL,
      0.767684,
      0.688378,
      0,
      3.970204,
      3.071415,
      2,
      1.835109,
      NULL,
      0,
      1.627841,
      2,
      0.516607,
      NULL,
      4.400377,
      4.857232,
      3.164696,
      3,
      0,
      1,
      2,
      1.782608,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608202,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.171503,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.310305,
      0.873626,
      1.988653,
      1,
      0,
      3.710325,
      NULL,
      NULL,
      NULL,
      1,
      3.337566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653575,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1.969641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014048,
      0.922337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.549249,
      NULL,
      NULL,
      NULL,
      0.523641,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894764,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.552246,
      NULL,
      NULL,
      0.598386,
      NULL,
      NULL,
      NULL,
      1,
      1.220473,
      NULL,
      NULL,
      1.549668,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.296375,
      0.535498,
      5,
      5,
      1,
      NULL,
      186.649932,
      1,
      NULL,
      NULL,
      1.795122,
      NULL,
      NULL,
      1.980032,
      0,
      5.414318,
      0,
      NULL,
      NULL,
      2,
      NULL,
      4,
      0,
      NULL,
      NULL,
      13,
      6.167923,
      1.893621,
      0.184637,
      1,
      NULL,
      1.366824,
      1,
      0.168148,
      NULL,
      1,
      NULL,
      0,
      1.528718,
      1,
      1,
      1,
      0.131354,
      0.429908,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.592954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657273,
      0.333680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109918,
      1.633681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.883312,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.336951,
      NULL,
      0.980813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764311,
      NULL,
      NULL,
      NULL,
      0.629874,
      0,
      0.706718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.313870,
      NULL,
      5.327070,
      3,
      3,
      1.745920,
      4.084133,
      NULL,
      1.596011,
      0.142647,
      0,
      1,
      1.215066,
      NULL,
      1.920028,
      NULL,
      0.894310,
      1,
      1,
      0,
      NULL,
      1.469696,
      0,
      1,
      NULL,
      1.485797,
      0.179948,
      NULL,
      0,
      0,
      2.306346,
      NULL,
      0.280772,
      1.639485,
      1,
      NULL,
      0.959544,
      1.073781,
      1,
      1,
      0.251126,
      1,
      0,
      NULL,
      3,
      3.707583,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.547524,
      NULL,
      0.317555,
      4.307747,
      NULL,
      6,
      3,
      1,
      1.431236,
      NULL,
      NULL,
      2,
      1,
      2,
      '30003',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      3.191169,
      '00013',
      '',
      '');
commit;
end;
/


