set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6109422';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '2413304',
      NULL,
      0.332113,
      1,
      0,
      '0302',
      0.375583,
      0.525209,
      NULL,
      NULL,
      ' 6- 8-1989',
      34,
      NULL,
      NULL,
      1.201842,
      2.286729,
      ' 7-11-1995',
      13,
      0.592270,
      NULL,
      63,
      2,
      ' 4- 6-1985',
      ' 6-28-1989',
      ' 9-11-2002',
      0.148304,
      2,
      3,
      3.656573,
      1,
      2,
      NULL,
      0.118731,
      NULL,
      81.489949,
      13,
      15,
      1.646961,
      NULL,
      7,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.471220,
      1.189312,
      0,
      NULL,
      0.936700,
      1.914845,
      0,
      0.654626,
      NULL,
      99.610465,
      NULL,
      6.561434,
      NULL,
      1,
      0,
      0.732292,
      0.864084,
      1,
      0.449858,
      4,
      0.188323,
      0.016643,
      NULL,
      1.141053,
      0,
      0,
      4,
      1.101807,
      3.940290,
      1.522912,
      0,
      0.570737,
      NULL,
      NULL,
      1.402972,
      NULL,
      NULL,
      1.413764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.321835,
      NULL,
      1.097467,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.479326,
      NULL,
      NULL,
      6.538102,
      0.289896,
      9,
      0.106942,
      7,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1.609655,
      0.920492,
      0,
      0.555817,
      1.553217,
      NULL,
      NULL,
      NULL,
      9.039127,
      2,
      1.488777,
      3.692498,
      1,
      6.190599,
      NULL,
      2,
      4.358496,
      2.004215,
      NULL,
      NULL,
      6,
      4.747131,
      2,
      2.382791,
      6,
      1,
      7,
      4,
      6.319683,
      6.430704,
      3.908791,
      0,
      NULL,
      0.213461,
      NULL,
      '11-20-1977',
      61,
      NULL,
      41,
      1.092183,
      2,
      1.515449,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.203099,
      0.190519,
      0.980956,
      0,
      NULL,
      1.662191,
      0.711459,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905381,
      0,
      6.165374,
      3.059771,
      NULL,
      0.378257,
      2.302709,
      1,
      NULL,
      NULL,
      1.960769,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.509064,
      0.951565,
      3.297283,
      0,
      2,
      132.377562,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      NULL,
      1,
      1.582336,
      2.207469,
      0.979691,
      2,
      3.705518,
      2.384856,
      1.615964,
      2,
      1,
      0.819823,
      NULL,
      1.493789,
      1.148421,
      1,
      0.821516,
      2.455924,
      1,
      1.994723,
      0,
      0.089883,
      1,
      0.888726,
      1,
      1.191009,
      NULL,
      NULL,
      3.184997,
      1,
      5,
      2.288815,
      NULL,
      6.468933,
      0,
      1.197127,
      NULL,
      NULL,
      0,
      3,
      42,
      0.006166,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      0.637277,
      0.549046,
      2.136796,
      '32234',
      '',
      '',
      0,
      '',
      '',
      '',
      1.314515,
      '',
      '',
      '',
      NULL,
      14.213785,
      100.802899,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.414584,
      NULL,
      0.837440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481557,
      1,
      0,
      NULL,
      0,
      0.149356,
      NULL,
      NULL,
      3,
      3.437979,
      1,
      2,
      0.286156,
      1.384381,
      1.274152,
      1.816887,
      0,
      2,
      1.707633,
      0.969058,
      0.405407,
      0.130919,
      0,
      0.938323,
      NULL,
      NULL,
      8,
      7.439096,
      3,
      0,
      3.163629,
      NULL,
      3.728412,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335348,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.252306,
      0.780618,
      NULL,
      NULL,
      0,
      0.284617,
      1.631252,
      0.498519,
      0.311524,
      0.360955,
      0,
      NULL,
      3.794813,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.854862,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      0,
      3.673227,
      3.705662,
      14,
      7.675905,
      5,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      1.430315,
      2.900449,
      3.981932,
      0,
      0,
      11.985860,
      0,
      1,
      2,
      1.839412,
      3,
      NULL,
      1,
      7.446289,
      3.443378,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734083,
      NULL,
      NULL,
      0.397111,
      NULL,
      NULL,
      6.687288,
      NULL,
      1,
      NULL,
      NULL,
      2.132331,
      1,
      NULL,
      0.023308,
      4.041625,
      2.491391,
      NULL,
      8.346834,
      NULL,
      8,
      7.194793,
      0.533580,
      NULL,
      3.587949,
      3,
      NULL,
      0.947645,
      1.050535,
      3,
      1,
      3.066830,
      1,
      8,
      0,
      7,
      0.971815,
      1,
      2.255031,
      0.022938,
      NULL,
      NULL,
      0,
      2.223888,
      3.573440,
      NULL,
      0,
      3,
      0.842995,
      0,
      2.913035,
      7,
      3,
      NULL,
      2.145470,
      5.461300,
      1.239416,
      1,
      3.591972,
      0.739772,
      0.939377,
      3,
      1.358281,
      NULL,
      NULL,
      3.929586,
      NULL,
      11.091707,
      NULL,
      NULL,
      0.486714,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.589441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.944088,
      0,
      NULL,
      NULL,
      0.163753,
      NULL,
      3.929610,
      1,
      NULL,
      3,
      1.071188,
      NULL,
      NULL,
      0,
      NULL,
      1.998560,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.642228,
      2,
      3.345204,
      NULL,
      2.425952,
      0,
      0,
      NULL,
      0.153135,
      NULL,
      12.236898,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.720827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.143628,
      NULL,
      0.776462,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.096968,
      NULL,
      NULL,
      NULL,
      0.611062,
      NULL,
      NULL,
      NULL,
      1.871202,
      NULL,
      3.296734,
      NULL,
      0.748816,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.473535,
      NULL,
      3.774840,
      NULL,
      1.349455,
      NULL,
      0.013262,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.251528,
      NULL,
      2.392012,
      NULL,
      0.168253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.534192,
      21,
      8.383382,
      1.036127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523485,
      NULL,
      NULL,
      3,
      38.392679,
      12.609959,
      1.227511,
      0.029283,
      4.052027,
      2.384024,
      13.487279,
      0.420993,
      11916,
      1085.712921,
      0,
      0.781165,
      1,
      0.269583,
      1,
      1.254639,
      0.659411,
      1,
      NULL,
      NULL,
      0,
      0,
      1.420915,
      NULL,
      0.312635,
      1,
      1.985232,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.573248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.658457,
      NULL,
      NULL,
      NULL,
      1.485209,
      NULL,
      NULL,
      NULL,
      1.194004,
      NULL,
      0,
      NULL,
      1.119231,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507411,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.642437,
      2.805600,
      NULL,
      0.709520,
      NULL,
      1.229768,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.990238,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.911604,
      1.464079,
      NULL,
      3.106649,
      0,
      3.009222,
      2.367992,
      2.362091,
      6,
      NULL,
      1,
      1.528161,
      1.932372,
      0.893790,
      NULL,
      1.835318,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154401,
      0.623398,
      NULL,
      1.065431,
      2,
      NULL,
      1.873040,
      0,
      NULL,
      3.834792,
      0.149044,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      0.180103,
      0,
      NULL,
      0.305209,
      1.886071,
      NULL,
      0,
      0.774124,
      0.299890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.134524,
      NULL,
      0.351845,
      NULL,
      4,
      6,
      9.277388,
      0.274937,
      0.653796,
      3,
      33.641491,
      NULL,
      NULL,
      1,
      NULL,
      '02404',
      '32143',
      NULL,
      0.854277,
      '',
      '',
      '',
      1.201840,
      NULL,
      '',
      '');
commit;
end;
/


