set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6802799';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '0022244',
      0.278583,
      1.643158,
      3,
      3,
      '4113',
      3.734972,
      0,
      1,
      6,
      '11-13-1989',
      79,
      NULL,
      1,
      2.791866,
      1,
      ' 4- 3-2000',
      14,
      0,
      31.827692,
      129.644447,
      3.331790,
      NULL,
      NULL,
      '11-27-1982',
      2.649720,
      1.072519,
      1,
      1,
      0,
      1,
      1.686295,
      1.095803,
      NULL,
      NULL,
      NULL,
      2,
      4,
      12.178792,
      NULL,
      7.681953,
      3,
      7.219836,
      1,
      6,
      1.728124,
      2.329711,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1.332035,
      1,
      1,
      0,
      NULL,
      4.626617,
      1,
      NULL,
      NULL,
      0.492550,
      0,
      0.273375,
      NULL,
      1.207658,
      1.972400,
      0,
      NULL,
      3,
      1.426251,
      0,
      1.359840,
      0,
      1.817420,
      NULL,
      NULL,
      1.048461,
      NULL,
      NULL,
      0.185605,
      0.994443,
      1.049974,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.409229,
      1.687579,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.746474,
      3,
      1.765968,
      0,
      0,
      1.808648,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0.652168,
      1,
      1.773053,
      NULL,
      1.933540,
      5.954342,
      0,
      0.280718,
      4,
      0.770542,
      6,
      1.137411,
      2.162716,
      2,
      0.470738,
      1.499271,
      3,
      2,
      NULL,
      1,
      1,
      1.895455,
      0.092198,
      0.134393,
      NULL,
      1,
      NULL,
      4,
      0.913923,
      9.764387,
      2.111307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.111911,
      0.439376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458271,
      0,
      0,
      0.025582,
      0.209738,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770540,
      1.891657,
      1.204326,
      NULL,
      NULL,
      NULL,
      0.269406,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.894460,
      1.807103,
      NULL,
      0.756698,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      3,
      2.203796,
      3,
      0.836319,
      1.428754,
      2,
      2,
      3,
      0.046300,
      3.988732,
      2,
      NULL,
      NULL,
      1,
      3.369388,
      0.173901,
      0.785580,
      0.047918,
      0,
      1.366866,
      0.578474,
      0,
      1,
      NULL,
      NULL,
      3.802539,
      0,
      NULL,
      3.921721,
      NULL,
      4.785562,
      2,
      2,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      44.417346,
      2,
      0,
      123.223077,
      NULL,
      NULL,
      NULL,
      2.631006,
      1,
      1,
      '',
      '',
      '',
      1.894475,
      '44240',
      '',
      '',
      NULL,
      '31014',
      NULL,
      '',
      3.418313,
      4,
      25.596270,
      29,
      1.898166,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.658307,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.328479,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.286998,
      0,
      2,
      1,
      1.414005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.140895,
      NULL,
      NULL,
      NULL,
      1.767839,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.661666,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752643,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.818048,
      1.571959,
      1.612709,
      1.357202,
      NULL,
      NULL,
      NULL,
      0.948245,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.476568,
      NULL,
      NULL,
      0,
      0,
      0.069873,
      0.486988,
      NULL,
      NULL,
      5.480180,
      NULL,
      1.440541,
      NULL,
      8,
      1.471182,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984089,
      NULL,
      NULL,
      1.498783,
      NULL,
      NULL,
      0.593390,
      NULL,
      NULL,
      3.592969,
      3,
      2,
      1,
      2.365475,
      0.331269,
      6.993536,
      NULL,
      3,
      3,
      0.107636,
      3.915842,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.411815,
      3.839694,
      1.401739,
      3,
      NULL,
      1.517876,
      6.554559,
      1,
      3,
      3.193834,
      3,
      1,
      3,
      2.971246,
      0.007924,
      1,
      0,
      0.892695,
      0.622706,
      1.106136,
      NULL,
      NULL,
      7,
      5,
      1,
      2.620470,
      0,
      0.537467,
      NULL,
      NULL,
      1,
      NULL,
      0.433801,
      1,
      NULL,
      1.691299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.682647,
      9.654128,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655271,
      6.461524,
      1,
      NULL,
      NULL,
      NULL,
      1.575764,
      NULL,
      NULL,
      0.881709,
      NULL,
      0,
      NULL,
      1.652418,
      1.211820,
      NULL,
      0.693571,
      0.854675,
      1,
      0,
      0,
      1,
      1.212396,
      1,
      1,
      1.396681,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.957672,
      1.974838,
      5.783704,
      NULL,
      NULL,
      2.078291,
      4,
      NULL,
      0,
      0,
      NULL,
      0.934372,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.297593,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945707,
      NULL,
      NULL,
      0.337683,
      NULL,
      NULL,
      1.866732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.472136,
      1,
      1.787642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852430,
      NULL,
      NULL,
      1.928071,
      NULL,
      2.123785,
      NULL,
      0.479721,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.518956,
      NULL,
      1.595453,
      NULL,
      NULL,
      NULL,
      0.160484,
      NULL,
      0.312007,
      NULL,
      17,
      0.507443,
      3,
      0,
      NULL,
      0.164472,
      NULL,
      0,
      NULL,
      0.508173,
      3,
      5,
      NULL,
      NULL,
      NULL,
      98,
      121.729297,
      3.377958,
      1.855943,
      NULL,
      '01242',
      '',
      '',
      2,
      '12011',
      '',
      '',
      2.756364,
      '31130',
      NULL,
      '');
commit;
end;
/


