set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6316025';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      '2023',
      0,
      1,
      NULL,
      NULL,
      NULL,
      84,
      NULL,
      NULL,
      0,
      1,
      ' 0- 7-1990',
      104,
      2,
      298,
      13.808638,
      2,
      NULL,
      NULL,
      ' 5-25-1974',
      2.239534,
      0,
      1,
      1.066727,
      1.481376,
      1,
      NULL,
      1,
      0,
      376.451405,
      3.465695,
      7,
      NULL,
      7,
      3,
      1,
      NULL,
      1.181028,
      1,
      0,
      0.927499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341855,
      NULL,
      NULL,
      3.022571,
      0,
      0,
      0,
      0,
      1.168556,
      0,
      0,
      1.649247,
      NULL,
      NULL,
      1,
      0.518936,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666329,
      0.693284,
      0.370461,
      1.005557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.112765,
      0,
      0.486237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352694,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.581854,
      0.509802,
      0.120343,
      NULL,
      NULL,
      0,
      1.007327,
      1.378454,
      1.798528,
      0.809702,
      0,
      1,
      NULL,
      1.381631,
      0,
      0.982447,
      NULL,
      0,
      1,
      0.440161,
      0,
      0,
      1.688482,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0.299149,
      0.026744,
      0,
      NULL,
      1.017777,
      2.096741,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      7,
      1.698426,
      NULL,
      1,
      4.047480,
      NULL,
      1,
      2,
      3.344213,
      0.348220,
      3,
      2,
      0.332282,
      4,
      0.018794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.928259,
      1,
      NULL,
      NULL,
      NULL,
      1.323228,
      0,
      0,
      1,
      0.426776,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.999331,
      NULL,
      1.811351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376279,
      0.481959,
      0,
      3,
      1.980042,
      0,
      1.092059,
      NULL,
      NULL,
      0,
      1.687152,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      0.277574,
      2.593701,
      NULL,
      NULL,
      NULL,
      0.813896,
      1,
      0,
      2.442071,
      2,
      NULL,
      2.921542,
      8.766507,
      0,
      NULL,
      0,
      1.142505,
      NULL,
      NULL,
      1,
      0,
      0,
      0.947892,
      0,
      1,
      0.612215,
      0.596385,
      0.077880,
      7,
      7,
      NULL,
      6,
      NULL,
      NULL,
      1.047480,
      NULL,
      1.925512,
      NULL,
      3,
      0,
      17,
      3.284429,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.858017,
      0,
      2.389097,
      '04113',
      '31431',
      '',
      1,
      '',
      '',
      '',
      0.713782,
      '3422',
      '2223',
      '',
      0.314475,
      NULL,
      661,
      37.725370,
      NULL,
      34,
      0.813194,
      13.766934,
      1,
      0,
      NULL,
      NULL,
      0.783501,
      NULL,
      NULL,
      1.992017,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.769334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947032,
      NULL,
      NULL,
      0.267755,
      NULL,
      NULL,
      1.979193,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.147430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274688,
      NULL,
      NULL,
      1.437930,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038011,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.990186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705323,
      NULL,
      NULL,
      1.880197,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.164621,
      1,
      2.471267,
      2,
      1.556507,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.983215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493851,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.465541,
      NULL,
      NULL,
      0.643380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.014771,
      7.325518,
      1,
      1,
      3.162312,
      3,
      1,
      1,
      0,
      3,
      NULL,
      0,
      1.931980,
      NULL,
      0,
      4,
      6.317707,
      NULL,
      0,
      1,
      0,
      0.327736,
      0.682644,
      0.509751,
      3.005142,
      3.371718,
      NULL,
      0,
      NULL,
      NULL,
      0.047439,
      NULL,
      0.382416,
      3,
      5.176974,
      2.404946,
      NULL,
      NULL,
      NULL,
      0.738595,
      3.436034,
      0,
      NULL,
      NULL,
      1.856864,
      4.619845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.432753,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.517636,
      NULL,
      NULL,
      0.916168,
      NULL,
      NULL,
      3.526474,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.016592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      144,
      NULL,
      1,
      1.264060,
      1,
      1,
      0.680485,
      1.569203,
      1.753069,
      0,
      NULL,
      NULL,
      NULL,
      5.468220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.446484,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.640021,
      NULL,
      NULL,
      NULL,
      0.695197,
      NULL,
      NULL,
      NULL,
      1.352392,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452027,
      NULL,
      NULL,
      NULL,
      2.339778,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.889482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      140,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      334.774200,
      NULL,
      1,
      NULL,
      1486,
      NULL,
      NULL,
      NULL,
      0.438774,
      888.175256,
      NULL,
      2.568727,
      715,
      371,
      0,
      1431.788119,
      1594.503783,
      2.358809,
      9.493158,
      3.400385,
      209.838428,
      12,
      1,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.590418,
      1,
      0,
      1.016829,
      2.922969,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.487356,
      NULL,
      NULL,
      NULL,
      NULL,
      63.246188,
      NULL,
      0.206942,
      1.977297,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.391171,
      NULL,
      0.576622,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.522958,
      NULL,
      NULL,
      NULL,
      0.513428,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.723838,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.696217,
      7.311088,
      7.431415,
      5,
      3.128840,
      NULL,
      NULL,
      3.043382,
      2,
      NULL,
      3.106088,
      3,
      1,
      NULL,
      1,
      1,
      1.019680,
      0,
      1,
      1,
      1.895013,
      1.667440,
      1.514403,
      1,
      2,
      1,
      NULL,
      1,
      1.151431,
      1,
      1.274876,
      NULL,
      0,
      1.645650,
      0,
      1,
      NULL,
      0,
      NULL,
      0.476885,
      1.404942,
      NULL,
      0.889207,
      0,
      1.925540,
      NULL,
      3,
      2,
      0,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.755909,
      NULL,
      NULL,
      NULL,
      0,
      13,
      0,
      NULL,
      2,
      0.611258,
      3.875688,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.385038,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.906474,
      NULL,
      1.197283,
      NULL,
      0.973237,
      NULL,
      1.672836,
      NULL,
      3.866537,
      34,
      1.265822,
      1.630846,
      0,
      NULL,
      1.473861,
      NULL,
      1,
      NULL,
      0.589380,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      2,
      NULL,
      NULL,
      '32324',
      NULL,
      '42323',
      0,
      '',
      '',
      '',
      NULL,
      '3323',
      '0314',
      '40022');
commit;
end;
/


