set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106245';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '0030430',
      NULL,
      0.331355,
      1,
      0,
      '3123',
      3,
      NULL,
      NULL,
      NULL,
      ' 2-19-1976',
      33.328745,
      NULL,
      NULL,
      NULL,
      0.426320,
      NULL,
      NULL,
      1.811001,
      NULL,
      32,
      0,
      ' 2-17-1996',
      NULL,
      ' 3-11-1996',
      2,
      2,
      NULL,
      0.441074,
      0.297563,
      2,
      NULL,
      1.569554,
      1,
      194.493166,
      13.079619,
      8.062469,
      2,
      13,
      NULL,
      0.956181,
      NULL,
      2.607416,
      3.022070,
      6,
      1.561052,
      0,
      1.373181,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      31.619065,
      6.279054,
      6.114153,
      7,
      3,
      3,
      1,
      NULL,
      7.986662,
      1,
      4.488595,
      3,
      0.427701,
      2,
      0,
      NULL,
      0.937194,
      7.683872,
      1,
      3,
      0,
      0.898317,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.047280,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477469,
      0.442983,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.829983,
      5,
      1.757397,
      7.881474,
      5,
      NULL,
      0,
      1,
      7,
      2.837661,
      2,
      0.240479,
      4.088525,
      1.592504,
      NULL,
      0.250700,
      0.659216,
      1,
      NULL,
      1,
      1.255070,
      3.245592,
      0,
      1.501180,
      0.519689,
      1.266035,
      8,
      6,
      NULL,
      5,
      6,
      4,
      0,
      4.350389,
      0,
      NULL,
      NULL,
      2,
      NULL,
      7.853053,
      NULL,
      3.813451,
      9.692496,
      8.309238,
      5,
      5,
      3.270786,
      ' 8-14-1982',
      994,
      NULL,
      873,
      3.830493,
      1.255568,
      NULL,
      NULL,
      1.953328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256558,
      3,
      0.766913,
      4.095248,
      NULL,
      2.942106,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586736,
      1.454162,
      1,
      1.008257,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159961,
      NULL,
      1.896329,
      3,
      NULL,
      0,
      NULL,
      NULL,
      34.820207,
      0,
      0.463015,
      NULL,
      NULL,
      NULL,
      0.654024,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      2,
      0.165262,
      3,
      1.381039,
      0.804266,
      0,
      NULL,
      1.474622,
      1,
      0.035665,
      0.985777,
      NULL,
      0,
      0,
      1,
      0.428986,
      NULL,
      1,
      1,
      NULL,
      1.709371,
      0,
      2.326647,
      0.548307,
      11.463485,
      3,
      5,
      NULL,
      9,
      6.113326,
      NULL,
      2.196161,
      1.741060,
      0,
      2,
      0.269490,
      3.517022,
      0,
      2,
      NULL,
      63,
      60.864103,
      31,
      1,
      1.798933,
      2.611018,
      '03001',
      '0032',
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.342763,
      17.100671,
      77,
      13,
      0.227227,
      NULL,
      NULL,
      NULL,
      9,
      2,
      NULL,
      1.930971,
      0.380068,
      NULL,
      NULL,
      1.275935,
      NULL,
      NULL,
      3.695032,
      3,
      3.991587,
      0,
      NULL,
      NULL,
      3.136985,
      NULL,
      2.798031,
      0.979256,
      NULL,
      NULL,
      1.294308,
      NULL,
      NULL,
      0.609173,
      NULL,
      NULL,
      0.175510,
      NULL,
      NULL,
      0.838977,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      4.732490,
      0.347689,
      1.147079,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.668952,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.435117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772856,
      NULL,
      NULL,
      1.511784,
      NULL,
      0.016301,
      NULL,
      0.519809,
      1.801718,
      1.753150,
      NULL,
      NULL,
      0.176490,
      2.480323,
      7.492301,
      NULL,
      NULL,
      2,
      3.040136,
      2,
      NULL,
      2.601458,
      3.992980,
      6.711828,
      0.350076,
      NULL,
      NULL,
      1.153804,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.362224,
      NULL,
      NULL,
      0.536254,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.767254,
      NULL,
      3.406032,
      3,
      2,
      1.555645,
      NULL,
      NULL,
      NULL,
      1.380718,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      4,
      NULL,
      NULL,
      0,
      0.387926,
      NULL,
      1.117375,
      3.052500,
      3,
      3,
      NULL,
      0,
      2,
      3.325736,
      NULL,
      4.115049,
      1.253396,
      NULL,
      NULL,
      3,
      2,
      5,
      NULL,
      0.804696,
      0,
      0,
      1.866356,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345142,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.479752,
      NULL,
      NULL,
      1.939010,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1,
      0.519228,
      NULL,
      0,
      NULL,
      0,
      1.659180,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.482843,
      NULL,
      NULL,
      NULL,
      0.855681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949910,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.770974,
      NULL,
      NULL,
      NULL,
      0.219888,
      NULL,
      NULL,
      NULL,
      1.747596,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.240496,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      55,
      1.382734,
      NULL,
      NULL,
      1.023392,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.829202,
      NULL,
      NULL,
      0.891019,
      NULL,
      NULL,
      75.666411,
      1.432193,
      0.145041,
      0,
      0,
      NULL,
      0.891980,
      1.824955,
      1.617815,
      1,
      1,
      1.959137,
      0,
      1.577539,
      0,
      1,
      0.569846,
      1.850349,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      5,
      2.737237,
      4,
      4.853860,
      14.548855,
      2.418401,
      0.220954,
      0.272933,
      1.839990,
      1.292024,
      NULL,
      1.891444,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.815680,
      NULL,
      NULL,
      2,
      3.983570,
      NULL,
      0,
      0.428124,
      NULL,
      0.750008,
      0.126169,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651705,
      NULL,
      NULL,
      0.486912,
      0.553778,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.654778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.291314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.020692,
      11.323601,
      8.077801,
      NULL,
      1,
      3,
      63.332493,
      41,
      4,
      1.679455,
      4,
      NULL,
      '3143',
      '',
      1.147239,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


