set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655289';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      0.379209,
      1,
      NULL,
      4,
      0,
      0.351559,
      1,
      '424',
      '31412434',
      3.219141,
      23,
      '1132332',
      5,
      0.643056,
      1,
      3,
      '4144',
      3.403576,
      1.186448,
      NULL,
      NULL,
      ' 2- 5-1993',
      57.932093,
      NULL,
      NULL,
      2.755459,
      0,
      '11-11-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      2.608036,
      ' 1-25-1982',
      NULL,
      ' 2-21-1978',
      2.041257,
      3.911409,
      3,
      1,
      1,
      NULL,
      0,
      0.156422,
      0.870460,
      24,
      NULL,
      NULL,
      3.663749,
      NULL,
      NULL,
      NULL,
      NULL,
      6.694777,
      2.312097,
      NULL,
      0,
      3,
      1.511062,
      0.301641,
      0.893935,
      0.503286,
      0,
      1,
      0.490616,
      NULL,
      0,
      1.063375,
      3,
      6.060636,
      0,
      4,
      NULL,
      0.291659,
      1,
      0,
      0.397810,
      6.355390,
      NULL,
      0.991481,
      0,
      0,
      0,
      0,
      1.504027,
      0.924545,
      0,
      1,
      0,
      NULL,
      NULL,
      1.417373,
      NULL,
      NULL,
      8,
      4.070189,
      10.120447,
      3,
      1,
      0.973292,
      NULL,
      0,
      1,
      3,
      2.820700,
      1.330975,
      0.058715,
      3.472624,
      1.453202,
      2,
      2.690074,
      0.034122,
      1,
      1.450183,
      0,
      NULL,
      2,
      NULL,
      2,
      2,
      0.565445,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.204810,
      0.194041,
      4.768654,
      NULL,
      3,
      1,
      0.122197,
      0.008290,
      1.972384,
      5,
      0,
      0,
      0.048142,
      0,
      0.717160,
      0.328219,
      1,
      NULL,
      0.890168,
      NULL,
      NULL,
      3,
      0.456015,
      1.061136,
      1,
      1.561800,
      NULL,
      NULL,
      1,
      0.464517,
      0,
      0.965621,
      1.767997,
      1.616683,
      NULL,
      1,
      0.004527,
      7,
      5.520035,
      5.155874,
      3,
      3.469088,
      4,
      0,
      0,
      5.742081,
      4.777736,
      3,
      ' 3-18-2002',
      1110,
      NULL,
      541,
      3.973723,
      1.410249,
      0.254512,
      4,
      1.603853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049213,
      1.601229,
      1.693821,
      1.630027,
      1,
      0.209460,
      5.366203,
      1.196783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.415030,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.800454,
      3.752741,
      NULL,
      1.317111,
      1,
      4,
      2,
      4,
      4,
      2,
      1,
      0.261264,
      NULL,
      NULL,
      0,
      3.528898,
      0.254203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369633,
      1.894153,
      NULL,
      0.522019,
      0,
      0.953425,
      16,
      0.440008,
      0.753344,
      NULL,
      NULL,
      NULL,
      2.075654,
      NULL,
      2,
      1,
      1.912046,
      3.709375,
      3,
      3.075003,
      1,
      0.185677,
      2,
      1,
      3,
      3.802076,
      2,
      0.594772,
      0,
      NULL,
      1,
      0.563199,
      NULL,
      NULL,
      0.886981,
      1.463341,
      1.370478,
      1,
      0.789240,
      NULL,
      0.976135,
      0.853433,
      1.099371,
      1.522598,
      3.757905,
      2,
      NULL,
      2.773287,
      11.526272,
      7.765624,
      2.566263,
      2.448663,
      NULL,
      NULL,
      NULL,
      0.575101,
      36.355138,
      NULL,
      0,
      42.210330,
      NULL,
      35,
      NULL,
      NULL,
      4,
      7.871435,
      '12030',
      '43432',
      '44432',
      1.765777,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      1.464864,
      NULL,
      251,
      28,
      NULL,
      28,
      12,
      3,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.391037,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      0.697792,
      NULL,
      NULL,
      2,
      NULL,
      0.073829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614926,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.340097,
      NULL,
      NULL,
      11,
      0.138641,
      5,
      0.031728,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076107,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      2.946725,
      1.847080,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0.409625,
      2.156674,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      0.040290,
      0.607749,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.681453,
      NULL,
      0,
      0,
      0,
      0.049130,
      1,
      0.376631,
      0,
      NULL,
      NULL,
      3,
      0,
      0.501135,
      1,
      1.674472,
      2.482297,
      0.743518,
      NULL,
      NULL,
      2.558572,
      NULL,
      2.532742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025358,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.485280,
      3.139789,
      0,
      0.943654,
      0,
      7,
      1.306513,
      5,
      NULL,
      1.696284,
      0.337590,
      3,
      NULL,
      0,
      NULL,
      2.771713,
      2,
      3.771773,
      0.089213,
      2,
      1,
      0,
      0,
      9,
      NULL,
      0,
      1,
      3.178005,
      3.607584,
      3,
      0,
      3.275506,
      2.845845,
      3.439060,
      0,
      NULL,
      NULL,
      2,
      7,
      NULL,
      7.337152,
      NULL,
      0,
      1,
      NULL,
      3,
      3,
      NULL,
      1.055584,
      0.043173,
      0,
      0.456543,
      NULL,
      NULL,
      NULL,
      0.200526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515914,
      NULL,
      NULL,
      1.997556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.443600,
      NULL,
      NULL,
      0,
      NULL,
      1.256203,
      1,
      NULL,
      0.138646,
      0,
      NULL,
      NULL,
      1.782797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.918748,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.952670,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      2.620915,
      2,
      50.665755,
      22.080181,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.389244,
      3,
      2,
      1.585449,
      NULL,
      NULL,
      1.851925,
      NULL,
      NULL,
      0.744445,
      16,
      0.553788,
      NULL,
      3,
      1,
      1,
      0.526466,
      1.623144,
      1.588032,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2.409201,
      1,
      0,
      0,
      0,
      NULL,
      1.512878,
      NULL,
      1.272411,
      NULL,
      0.398604,
      NULL,
      0.705855,
      NULL,
      3.412294,
      NULL,
      NULL,
      NULL,
      1.368481,
      NULL,
      21.161433,
      NULL,
      NULL,
      2.183665,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.986177,
      NULL,
      3,
      NULL,
      3.062698,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.348973,
      NULL,
      NULL,
      NULL,
      0.468174,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.762956,
      NULL,
      3.231088,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.557336,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.123232,
      NULL,
      1.763598,
      NULL,
      0.934527,
      NULL,
      NULL,
      0.434541,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.303582,
      1.024031,
      0.477644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331707,
      1,
      NULL,
      1.160712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.959600,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.741842,
      NULL,
      NULL,
      NULL,
      2.484028,
      NULL,
      0,
      0.798970,
      21,
      NULL,
      2,
      1.841723,
      1,
      2.058427,
      1,
      2.103660,
      0,
      6.043423,
      1,
      0,
      1,
      5,
      12.496563,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.166863,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.105378,
      1.265973,
      NULL,
      3.875008,
      1,
      NULL,
      1,
      0.493470,
      NULL,
      2.786166,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.332430,
      0,
      NULL,
      1,
      1,
      NULL,
      2.456758,
      2,
      NULL,
      NULL,
      NULL,
      1.726810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.658569,
      NULL,
      0.012501,
      NULL,
      4.929965,
      1.584783,
      NULL,
      NULL,
      NULL,
      37.484225,
      3,
      3,
      NULL,
      '44124',
      NULL,
      '42432',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


