set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8724508';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '3303444',
      2,
      1.097962,
      3,
      NULL,
      '1004',
      0.078381,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      4.866818,
      1.632744,
      0.802174,
      '10-20-1976',
      51.521521,
      3.932868,
      NULL,
      NULL,
      2,
      '11-14-1993',
      ' 7-19-1987',
      NULL,
      3,
      2.323301,
      3.939668,
      2,
      NULL,
      1.907607,
      6,
      1.288352,
      0,
      3.812456,
      5,
      15.534794,
      NULL,
      17,
      23,
      7,
      23,
      0,
      4.122170,
      NULL,
      0.733605,
      0.719586,
      NULL,
      NULL,
      0,
      0.658603,
      NULL,
      0.909322,
      NULL,
      1.579856,
      0,
      NULL,
      1.234013,
      1,
      NULL,
      NULL,
      0.916636,
      1.781619,
      3.434544,
      NULL,
      3.253330,
      0,
      4.560385,
      1,
      NULL,
      NULL,
      3,
      4.171265,
      NULL,
      2.317166,
      NULL,
      1.507310,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      7.542591,
      1.727216,
      NULL,
      0,
      0.571209,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0.088601,
      1,
      1.072907,
      2,
      0,
      NULL,
      3,
      0.344450,
      1.991508,
      9,
      1,
      4,
      3,
      1,
      NULL,
      NULL,
      2.536781,
      3,
      1.538191,
      0,
      NULL,
      0,
      3.301567,
      2,
      4.428469,
      NULL,
      1,
      2,
      5,
      0.694491,
      0,
      NULL,
      4,
      0,
      0.504977,
      1,
      0,
      1,
      NULL,
      NULL,
      5,
      4,
      0.227193,
      4,
      1,
      4.825935,
      5,
      5,
      NULL,
      0,
      3.715403,
      2,
      4.144677,
      NULL,
      1.700104,
      5,
      1.396442,
      NULL,
      8,
      5,
      8.766446,
      3.416335,
      7.040974,
      3,
      5,
      4,
      2.118156,
      '10- 6-2001',
      908,
      ' 1-12-1989',
      204,
      1.878981,
      0.189134,
      0,
      4,
      0.182475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.403004,
      0,
      2.768450,
      3.626101,
      0.339731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.938016,
      NULL,
      0.461081,
      2.147857,
      NULL,
      1,
      1.006960,
      NULL,
      0.545398,
      3.998040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.959839,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.415173,
      NULL,
      NULL,
      0,
      6,
      0,
      5.537298,
      3,
      1.014458,
      0,
      ' 0-15-2003',
      2,
      ' 9-15-1999',
      8.760046,
      0.042764,
      2,
      NULL,
      0.592424,
      1,
      1,
      1,
      0.582059,
      0,
      0.982868,
      0,
      NULL,
      0.608546,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431385,
      3,
      3.763128,
      1,
      2.448993,
      3.188044,
      1,
      NULL,
      2,
      1,
      0,
      2.265785,
      2,
      0.799879,
      NULL,
      3.355856,
      NULL,
      0,
      0.874450,
      0,
      NULL,
      1.841755,
      1,
      NULL,
      4,
      1,
      0,
      2,
      NULL,
      NULL,
      0.390974,
      11,
      9.864462,
      NULL,
      2.069914,
      1.937617,
      4,
      4.161406,
      3.014304,
      3.301397,
      NULL,
      1,
      2.577911,
      38,
      2.681332,
      1.247130,
      NULL,
      24,
      62.750413,
      9.888439,
      0.944981,
      1,
      3,
      '31104',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      37,
      217,
      48.541430,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494519,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      0.967551,
      NULL,
      0.213683,
      NULL,
      2,
      3,
      0.979018,
      3,
      0,
      NULL,
      2.612918,
      2.596715,
      2,
      NULL,
      0,
      1,
      1,
      12,
      NULL,
      3,
      NULL,
      0,
      3.771449,
      0,
      1.448147,
      0,
      0.348243,
      1,
      6,
      1.127611,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0.044154,
      1,
      1.027362,
      NULL,
      NULL,
      NULL,
      0.432735,
      1.442191,
      0.152393,
      1.903251,
      1,
      3.338883,
      1,
      2.576265,
      3.048360,
      1,
      2.605899,
      NULL,
      3.526522,
      1.135810,
      1.111582,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.073610,
      3,
      0,
      1,
      1,
      5.182643,
      1.570835,
      1.791069,
      NULL,
      NULL,
      NULL,
      0.196499,
      NULL,
      NULL,
      NULL,
      0.971556,
      NULL,
      NULL,
      2,
      0.484383,
      0,
      0,
      NULL,
      NULL,
      0.198664,
      NULL,
      NULL,
      3,
      0,
      0,
      1.326092,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.405619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806711,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.956615,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.823752,
      NULL,
      0.040174,
      7.725610,
      2,
      0,
      3.156000,
      1,
      4.709878,
      1.337252,
      NULL,
      NULL,
      2,
      1.592084,
      0,
      3,
      1,
      0.522246,
      1.049137,
      0.425555,
      1.276899,
      7.641967,
      1.604756,
      1.952225,
      NULL,
      1,
      1,
      1.127307,
      1,
      1.151777,
      NULL,
      0.781879,
      3,
      2,
      1,
      NULL,
      9.991322,
      1.214972,
      3,
      4.279926,
      6.663987,
      5.480224,
      3,
      0.788132,
      9,
      1.379913,
      NULL,
      1.722957,
      1,
      0,
      1,
      NULL,
      NULL,
      4.377711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.744157,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.581744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688364,
      NULL,
      0,
      0.718060,
      1,
      3.418402,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317710,
      NULL,
      NULL,
      NULL,
      0.961623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680063,
      NULL,
      NULL,
      NULL,
      4.622615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568063,
      0,
      2,
      0.656502,
      NULL,
      NULL,
      1.589143,
      NULL,
      NULL,
      1.756576,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.304348,
      NULL,
      1.182664,
      4467,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1.485754,
      0.170015,
      1,
      1,
      1.041221,
      0,
      NULL,
      NULL,
      1.084506,
      1.545037,
      1.875062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.576960,
      NULL,
      NULL,
      1.959024,
      3,
      4.199587,
      NULL,
      3,
      1,
      1.949475,
      NULL,
      0,
      NULL,
      1.653603,
      3.502499,
      NULL,
      1,
      0,
      NULL,
      1.611985,
      0,
      NULL,
      1.650580,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.674175,
      2.673668,
      NULL,
      0.215209,
      1.528170,
      NULL,
      NULL,
      1,
      NULL,
      1.225112,
      0.485646,
      NULL,
      3.791582,
      0.766779,
      1.043682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.710657,
      NULL,
      1,
      NULL,
      1.579012,
      3,
      6.956309,
      0,
      NULL,
      NULL,
      52,
      13,
      6.933685,
      1.815751,
      2.694609,
      '04414',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.913360,
      '',
      NULL,
      '');
commit;
end;
/


