set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7919207';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      '1333',
      2,
      NULL,
      NULL,
      NULL,
      '10-15-1983',
      42.178191,
      NULL,
      4,
      2,
      1.172979,
      ' 1-15-1984',
      57,
      3.151638,
      213,
      133,
      0,
      ' 5-15-1979',
      ' 2-12-1977',
      ' 8-17-1999',
      1.704453,
      NULL,
      NULL,
      1.476195,
      0.042531,
      1,
      1.776535,
      1,
      NULL,
      833,
      NULL,
      4,
      NULL,
      NULL,
      15,
      NULL,
      4,
      4.914865,
      3.190037,
      4.935132,
      NULL,
      1.210221,
      1,
      1.078054,
      1.075282,
      0.895444,
      NULL,
      0,
      1,
      0.008747,
      76,
      8.716381,
      4,
      3,
      1,
      NULL,
      0,
      1.535699,
      NULL,
      3.277770,
      1,
      2,
      0,
      2,
      5,
      3.799192,
      1.798323,
      1,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.470473,
      1.833694,
      0,
      NULL,
      NULL,
      0.893363,
      NULL,
      1,
      1.870164,
      0.873634,
      0.750335,
      0,
      0.953161,
      3.732451,
      0.008031,
      0,
      0.790759,
      NULL,
      0,
      1.570837,
      0.643587,
      NULL,
      3.521562,
      1.875580,
      0.891382,
      0,
      1.130113,
      NULL,
      NULL,
      1.706639,
      NULL,
      NULL,
      1,
      3,
      6,
      1.189796,
      5.374131,
      NULL,
      8.289362,
      NULL,
      0,
      1,
      3,
      1.299327,
      NULL,
      NULL,
      1,
      1.604510,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      6,
      1,
      0.664870,
      2,
      NULL,
      1.387218,
      3,
      0,
      1.541559,
      1.052665,
      0.879846,
      2.012526,
      8.477887,
      3.316744,
      2.666960,
      NULL,
      NULL,
      5.539626,
      0.046616,
      1.254844,
      5,
      4,
      2.535298,
      5.433579,
      6,
      NULL,
      ' 3- 1-1984',
      700,
      NULL,
      NULL,
      2.708409,
      0.421572,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257305,
      0,
      NULL,
      1,
      1.227209,
      3.266444,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731604,
      0.650258,
      0.194746,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.009145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410339,
      1,
      1.313572,
      0,
      0.001781,
      NULL,
      2.363682,
      14270,
      0.717772,
      1,
      25,
      437.013345,
      NULL,
      1,
      1,
      2.086951,
      0.484991,
      3.967029,
      3,
      0.693654,
      1.145909,
      NULL,
      NULL,
      NULL,
      2.174421,
      3.908596,
      1,
      1,
      3.985110,
      3.502184,
      NULL,
      1.570710,
      NULL,
      1.404687,
      0.759138,
      1.377515,
      0.693188,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0.233406,
      0.893498,
      0.515342,
      0,
      4,
      0,
      NULL,
      0.443584,
      1,
      5,
      2,
      0.817561,
      0.351940,
      47.367553,
      2.197504,
      0,
      NULL,
      41,
      16.891240,
      17,
      3,
      0,
      0.176723,
      NULL,
      '10440',
      '',
      0,
      '',
      '',
      '',
      5,
      '24122',
      '43230',
      NULL,
      3,
      9.065297,
      702.036170,
      1.801509,
      0,
      NULL,
      1.169534,
      112,
      8,
      1,
      2.646537,
      3,
      1.189618,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.775147,
      1,
      0.189317,
      2.109887,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.751600,
      0.823582,
      NULL,
      NULL,
      1.812618,
      2,
      0,
      1,
      0,
      0,
      1,
      0.554092,
      NULL,
      0.409412,
      0,
      0.402018,
      0,
      1,
      5.809900,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860479,
      NULL,
      NULL,
      NULL,
      2.291019,
      3.290983,
      1.665166,
      1,
      0.920238,
      3,
      1,
      NULL,
      NULL,
      1.811506,
      1,
      0.522449,
      NULL,
      3,
      1,
      NULL,
      0.241367,
      NULL,
      1.467755,
      NULL,
      1,
      NULL,
      1.433338,
      0,
      NULL,
      0.449595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.402750,
      10.844864,
      1.784801,
      0.225268,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.313444,
      NULL,
      NULL,
      1.856760,
      3.553653,
      1.697834,
      2.822275,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      1.770044,
      NULL,
      NULL,
      1.466650,
      NULL,
      NULL,
      1.191022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249436,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      0.958436,
      6,
      NULL,
      3.428106,
      1,
      1.653944,
      8.455917,
      0.239462,
      2,
      1.264573,
      0.431064,
      0.841578,
      2.047069,
      NULL,
      1,
      0,
      0,
      1.569050,
      NULL,
      0,
      NULL,
      NULL,
      3.510504,
      1.631428,
      NULL,
      NULL,
      NULL,
      2,
      0.811977,
      NULL,
      NULL,
      3,
      5,
      4,
      4.852527,
      4,
      0,
      2,
      1.476190,
      0,
      3.622668,
      1,
      NULL,
      NULL,
      1.570765,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.829597,
      NULL,
      NULL,
      1.998466,
      NULL,
      NULL,
      3.010526,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      0,
      1.034200,
      0.742099,
      1.015487,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255054,
      NULL,
      NULL,
      NULL,
      1.306109,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.605316,
      NULL,
      NULL,
      NULL,
      1.066241,
      NULL,
      NULL,
      NULL,
      0.784639,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.777985,
      NULL,
      NULL,
      NULL,
      1.323011,
      73,
      57.466631,
      1,
      NULL,
      NULL,
      0.348786,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.748142,
      NULL,
      NULL,
      1.202322,
      NULL,
      NULL,
      2,
      169,
      NULL,
      NULL,
      1,
      1,
      0.054438,
      1.889363,
      0,
      1.257182,
      NULL,
      0.209370,
      1.072022,
      0.469168,
      0,
      1.349829,
      1,
      1,
      1.751601,
      1,
      1,
      0,
      0.950238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.205965,
      NULL,
      NULL,
      4.400635,
      2.061319,
      7.845610,
      0.661262,
      1,
      0,
      1,
      1,
      0.555119,
      NULL,
      0.754090,
      NULL,
      NULL,
      1.296618,
      NULL,
      1.681287,
      0.355158,
      NULL,
      1.098739,
      0,
      NULL,
      0.361483,
      1,
      NULL,
      0.747600,
      NULL,
      NULL,
      1.913997,
      2,
      NULL,
      0.489668,
      1,
      NULL,
      0.346367,
      1.695867,
      NULL,
      1.326967,
      NULL,
      NULL,
      0,
      1.534203,
      NULL,
      3,
      0,
      1.630962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154720,
      NULL,
      3.377300,
      8.242158,
      9,
      3.462770,
      2,
      2.500216,
      30,
      20,
      3.201692,
      NULL,
      1,
      '12213',
      '32411',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '00411',
      NULL,
      '03310');
commit;
end;
/


