set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0100555';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3.660988,
      3,
      2.030062,
      3.938772,
      3.652926,
      7,
      1,
      '131',
      '42212222',
      69,
      NULL,
      '0011003',
      3,
      0.760663,
      4,
      0,
      '3213',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      14,
      34.393717,
      NULL,
      0,
      2.603968,
      '11-29-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      2.409633,
      ' 8-11-1979',
      ' 9- 6-1977',
      ' 1- 9-1985',
      NULL,
      NULL,
      2.549479,
      NULL,
      NULL,
      3.539932,
      0,
      NULL,
      0.641120,
      12.665927,
      7.316063,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.759314,
      NULL,
      0,
      1.852943,
      NULL,
      0.648238,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      1,
      4,
      1,
      2,
      8.188032,
      1,
      NULL,
      0,
      1,
      1,
      11.026148,
      1.970499,
      0.007978,
      1.891061,
      1.178253,
      0.384456,
      7.861373,
      NULL,
      1.403067,
      4.272220,
      1.910988,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.838624,
      NULL,
      NULL,
      1,
      5,
      0.175430,
      4.599040,
      1,
      1.904487,
      0.996786,
      0,
      1,
      1.633705,
      0,
      0,
      1.619961,
      1,
      NULL,
      1,
      1.173210,
      0,
      0,
      0.424373,
      NULL,
      NULL,
      5.782742,
      3,
      2.288038,
      8.913546,
      0,
      0,
      2.180776,
      0.997779,
      6.121880,
      0,
      6.371496,
      8.541596,
      2,
      1,
      4,
      7.601452,
      2.405855,
      5,
      0.360791,
      2,
      3.498132,
      '11-17-1984',
      318.061758,
      ' 1- 4-1977',
      96,
      NULL,
      0.414199,
      0.212699,
      0.420310,
      1.048482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368826,
      NULL,
      4,
      3.701467,
      0,
      1.588720,
      5.285094,
      1.551729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.317656,
      1.090015,
      NULL,
      NULL,
      NULL,
      4.377094,
      1,
      NULL,
      6.322585,
      1.982027,
      NULL,
      0.884460,
      NULL,
      NULL,
      NULL,
      1.601531,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000148,
      0,
      1,
      3,
      1,
      NULL,
      1.643556,
      3.884161,
      14.616164,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.052564,
      1.005333,
      NULL,
      NULL,
      0.301302,
      0,
      2.912563,
      3,
      0.462022,
      NULL,
      3,
      2,
      2,
      3,
      3,
      1,
      2,
      3.741608,
      0.344742,
      6.339132,
      0,
      0.643395,
      1.928264,
      NULL,
      0,
      NULL,
      NULL,
      0.069819,
      1.182534,
      0.105615,
      3.285778,
      1,
      4,
      3.359906,
      6.922487,
      NULL,
      9,
      4,
      5.637814,
      3.126191,
      NULL,
      0.042997,
      0.045813,
      2,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      26.722807,
      55,
      4,
      5.232519,
      NULL,
      '03031',
      '40223',
      '',
      NULL,
      '0031',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.337779,
      2.053390,
      38,
      5,
      0,
      30,
      4,
      4,
      4.594903,
      0,
      NULL,
      0.106561,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.051940,
      1.853357,
      NULL,
      NULL,
      2.316365,
      3.570867,
      NULL,
      0.173361,
      NULL,
      0.499397,
      0.148004,
      NULL,
      NULL,
      2.760246,
      NULL,
      1.817280,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778997,
      NULL,
      NULL,
      NULL,
      2.962543,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739523,
      3.408482,
      3.393288,
      1.852232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.388505,
      0.025122,
      3,
      3,
      2.630714,
      0.113991,
      1.681538,
      3.981695,
      0.067873,
      NULL,
      NULL,
      NULL,
      NULL,
      7.302166,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      4.528822,
      0.127512,
      0.020010,
      1.113840,
      NULL,
      NULL,
      0.210745,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.717831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484443,
      0,
      3,
      1,
      NULL,
      NULL,
      3.668854,
      NULL,
      NULL,
      2.744629,
      0,
      4.989169,
      0,
      NULL,
      NULL,
      NULL,
      2.529633,
      NULL,
      2.480951,
      NULL,
      0,
      1,
      2.224117,
      2,
      4,
      9,
      9,
      NULL,
      0,
      3.872758,
      1,
      3.003710,
      0.797627,
      NULL,
      0,
      2.288642,
      NULL,
      NULL,
      1.119022,
      0.199951,
      2,
      NULL,
      5.072499,
      3,
      NULL,
      2.648491,
      3,
      2,
      NULL,
      0,
      NULL,
      1.244494,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073817,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.669862,
      NULL,
      NULL,
      0.454785,
      NULL,
      NULL,
      1.688966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133380,
      1.093507,
      1,
      1,
      NULL,
      1.531815,
      NULL,
      NULL,
      1.776689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.605102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823159,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.480718,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.967882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      32,
      0.097035,
      0.960219,
      1.960432,
      1,
      1.298459,
      NULL,
      NULL,
      1,
      1,
      2.050848,
      1.999375,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.860130,
      118,
      NULL,
      NULL,
      NULL,
      1,
      1.436504,
      0.544466,
      NULL,
      0,
      0,
      0,
      0,
      3,
      0,
      0.736004,
      0.444261,
      NULL,
      0.924822,
      3,
      1.837882,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.434264,
      NULL,
      3.733743,
      NULL,
      183,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      3,
      7.891435,
      1.928887,
      NULL,
      1.988655,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.201177,
      NULL,
      1.130091,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.947017,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894061,
      0.126937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194863,
      2.348777,
      NULL,
      0,
      NULL,
      1.951573,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.816196,
      NULL,
      0,
      NULL,
      0.203057,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.270150,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.705748,
      NULL,
      1.180519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      808,
      NULL,
      0,
      NULL,
      2.503649,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241077,
      8.051676,
      NULL,
      NULL,
      0,
      NULL,
      1.175109,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.632449,
      1.630056,
      4.437421,
      15.452460,
      1,
      2,
      0,
      1.190037,
      1.875811,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.528490,
      0.934751,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      2.119194,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.044697,
      NULL,
      NULL,
      1.964790,
      6,
      0,
      1.972015,
      2.391573,
      NULL,
      9,
      2.181656,
      3,
      3.245297,
      '42304',
      '40133',
      '',
      1,
      '0044',
      '',
      '',
      0.137948,
      '',
      '',
      '');
commit;
end;
/


