set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027300';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      NULL,
      26.061328,
      13,
      NULL,
      0,
      0.909492,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      '11- 8-1978',
      49.263040,
      NULL,
      NULL,
      0.771653,
      3.497764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1-11-2002',
      ' 0- 4-1998',
      ' 3-20-1996',
      NULL,
      NULL,
      3,
      0.798849,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.806479,
      1.593925,
      NULL,
      0.178000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.755797,
      3.122569,
      NULL,
      7.178346,
      1,
      0.076350,
      NULL,
      1,
      0.696176,
      1,
      0,
      3.451501,
      1.567593,
      NULL,
      0,
      5.889046,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.793922,
      NULL,
      NULL,
      1.383383,
      0,
      1.227612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780227,
      1,
      0.170887,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.039436,
      NULL,
      0,
      4.156417,
      1,
      1,
      1.721767,
      1,
      1,
      0.030379,
      0,
      1,
      2.513261,
      1,
      0,
      NULL,
      0,
      1.759583,
      NULL,
      1,
      3.877039,
      0.572052,
      NULL,
      0,
      2,
      1,
      0.797497,
      0,
      0.973245,
      1.882609,
      1.479899,
      1.439129,
      0.469486,
      1.249246,
      1,
      1,
      1.305356,
      1.431170,
      0.473348,
      1.089195,
      1,
      2,
      1.912149,
      0.748387,
      0.371837,
      0.260471,
      0,
      ' 2-28-1991',
      1.533725,
      ' 8-19-1997',
      0,
      3.141200,
      3.863885,
      0.071827,
      3.652338,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356988,
      7,
      0.117187,
      5,
      6,
      NULL,
      1.831760,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.329151,
      1.247775,
      3,
      NULL,
      1,
      1,
      NULL,
      1.766876,
      1,
      0.176192,
      NULL,
      0.991939,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.978392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101307,
      0.441006,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.501427,
      1.818840,
      NULL,
      NULL,
      NULL,
      0.836090,
      0,
      NULL,
      3,
      0,
      1,
      3,
      2.908800,
      1,
      1,
      3,
      NULL,
      3.141789,
      1,
      NULL,
      NULL,
      3.862059,
      1.171156,
      0,
      NULL,
      NULL,
      1,
      0.548808,
      0.522849,
      0,
      0.711149,
      1.757011,
      1.597679,
      1,
      2.496128,
      0.178440,
      NULL,
      7.432435,
      5.235491,
      7.586322,
      5.254006,
      9,
      NULL,
      2.857568,
      0,
      5,
      0.029524,
      2,
      1,
      35.508050,
      2.409571,
      0.339879,
      19.595993,
      NULL,
      18,
      NULL,
      1.928991,
      2.614801,
      NULL,
      '42430',
      NULL,
      '',
      1.242923,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.295299,
      33,
      63.684441,
      33.770437,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278630,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.561674,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.881059,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.839974,
      NULL,
      NULL,
      1.763485,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584063,
      NULL,
      NULL,
      0.112610,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.548809,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.370451,
      NULL,
      NULL,
      1.306529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.294165,
      NULL,
      NULL,
      0.498912,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.541434,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246016,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.077152,
      0,
      0,
      NULL,
      NULL,
      0.836327,
      NULL,
      2,
      1.831963,
      0.688129,
      NULL,
      NULL,
      1,
      3.819157,
      0.457772,
      1.847981,
      2.322728,
      1.974671,
      5.062217,
      2.478415,
      1.118680,
      1,
      NULL,
      NULL,
      0.201524,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3,
      0.793074,
      0,
      0,
      6.828037,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.229263,
      NULL,
      NULL,
      NULL,
      1.656375,
      NULL,
      NULL,
      NULL,
      0.658229,
      NULL,
      NULL,
      NULL,
      0.367409,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.918824,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0.985945,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.745572,
      0,
      0.977359,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622135,
      NULL,
      0.979014,
      NULL,
      2,
      0.168856,
      1.039091,
      1,
      1,
      1.331648,
      1.109493,
      NULL,
      0,
      0,
      1.124735,
      1.877234,
      0.088509,
      NULL,
      0,
      1,
      0,
      0.336272,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871331,
      1.661442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.231580,
      1.577289,
      0.887924,
      1,
      0.154866,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.965848,
      0.961794,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481089,
      0,
      1,
      5.129747,
      0.691248,
      1,
      3,
      0.746095,
      NULL,
      NULL,
      NULL,
      0.108257,
      0.850898,
      0,
      1.778778,
      1.222647,
      0.824375,
      1,
      1,
      1.515010,
      1.132666,
      NULL,
      1,
      1.288114,
      1.506007,
      1,
      1,
      1.884688,
      1,
      0.394131,
      0.222467,
      0.010654,
      1.899949,
      0.240775,
      NULL,
      1,
      1,
      0.407169,
      0,
      1.593782,
      2.388246,
      1,
      0,
      NULL,
      0,
      NULL,
      3.905253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.448883,
      1.019887,
      0.296028,
      2.480959,
      NULL,
      2,
      1.739039,
      NULL,
      NULL,
      NULL,
      139.780833,
      5,
      NULL,
      2,
      '34003',
      '30432',
      '',
      0.135218,
      '',
      '',
      NULL,
      3,
      '4004',
      '4123',
      '');
commit;
end;
/


