set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837432';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '43',
      3,
      3,
      '1030414',
      1.016485,
      1,
      3,
      2,
      '1243',
      2,
      0,
      NULL,
      NULL,
      '10-10-1982',
      46.948457,
      16,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 7-26-1977',
      ' 0-23-1984',
      '10- 9-1991',
      2,
      3,
      0.491256,
      1.600016,
      1,
      1.655494,
      1.605520,
      2.700394,
      NULL,
      NULL,
      NULL,
      5.419937,
      3.026236,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.628965,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      6,
      1.295066,
      NULL,
      NULL,
      2,
      1.420346,
      5,
      NULL,
      3.145565,
      0.085366,
      1,
      0,
      11,
      NULL,
      NULL,
      11.977806,
      0,
      1,
      NULL,
      1.643699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808623,
      NULL,
      NULL,
      11.889562,
      3,
      0.806922,
      3,
      1,
      NULL,
      0,
      1.186670,
      0,
      NULL,
      3,
      1,
      NULL,
      2.886829,
      0,
      0,
      3,
      1,
      0,
      3,
      0.160292,
      0,
      6,
      0.090206,
      3.985368,
      1.918455,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.120523,
      NULL,
      1,
      0.173915,
      1,
      0,
      0,
      0.512215,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1.270869,
      NULL,
      NULL,
      1.689907,
      1.001637,
      0.538931,
      5.178235,
      1,
      1,
      3.271611,
      NULL,
      0,
      0,
      1,
      0.391028,
      1,
      0.805190,
      1,
      NULL,
      NULL,
      2.966207,
      NULL,
      4.926092,
      5,
      1.457879,
      NULL,
      2,
      3,
      0,
      1.626166,
      0,
      '11-18-1983',
      39.028742,
      ' 9- 7-1987',
      1.895651,
      2,
      0.014895,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.650169,
      NULL,
      4.153556,
      0,
      1.885478,
      1.147801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.138421,
      1.852185,
      3,
      2.136901,
      1.312563,
      1.359952,
      NULL,
      0,
      5.811949,
      0,
      2.367422,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891088,
      NULL,
      1.665520,
      1.378665,
      0,
      0.152039,
      NULL,
      3,
      3.582511,
      1.195205,
      1.146100,
      NULL,
      NULL,
      NULL,
      3,
      0.178399,
      0,
      1,
      1.699024,
      1.516153,
      NULL,
      NULL,
      0.075749,
      1.956684,
      0,
      2.436207,
      0,
      1.250669,
      3.228629,
      1,
      0.120926,
      1,
      NULL,
      1,
      0,
      NULL,
      1.322345,
      NULL,
      0.923350,
      1,
      1,
      0,
      NULL,
      3,
      0.555299,
      1,
      NULL,
      9.755836,
      NULL,
      11,
      3,
      4.459361,
      3,
      1.124403,
      2.188453,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282009,
      NULL,
      0,
      NULL,
      26.299793,
      NULL,
      3.912071,
      0,
      1,
      NULL,
      '',
      '',
      0.069773,
      '',
      '',
      '',
      0.520037,
      '',
      '',
      '',
      0.489006,
      2,
      97,
      4.299094,
      1.091828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470186,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.595099,
      NULL,
      NULL,
      0.925361,
      NULL,
      NULL,
      1.502482,
      NULL,
      NULL,
      1.827483,
      NULL,
      NULL,
      1.821272,
      NULL,
      NULL,
      0.382665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.926700,
      NULL,
      NULL,
      1.377762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474623,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.057435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.094802,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.363716,
      NULL,
      NULL,
      0.073790,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.535564,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161830,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.906969,
      NULL,
      NULL,
      1.256046,
      NULL,
      NULL,
      1.807689,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.714187,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      4,
      2.545383,
      1,
      2,
      3.965244,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932679,
      NULL,
      0.404468,
      0,
      0.099468,
      1.842795,
      0,
      NULL,
      NULL,
      0.586459,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203942,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.122845,
      1.894357,
      0.603418,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623734,
      NULL,
      2.014975,
      3.133131,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.001545,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.462976,
      NULL,
      NULL,
      0.883699,
      NULL,
      0.497950,
      619,
      3.802148,
      0,
      NULL,
      1.264215,
      NULL,
      NULL,
      NULL,
      0.510487,
      0,
      1,
      1,
      1.165097,
      1.503584,
      NULL,
      1,
      0,
      1.161364,
      2,
      NULL,
      0.907773,
      NULL,
      1,
      NULL,
      0.871766,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.947183,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.744366,
      0,
      0.580754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558387,
      0.295477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185764,
      1.464097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175756,
      2.967090,
      NULL,
      1.651107,
      0.241608,
      1,
      NULL,
      NULL,
      0,
      0.555905,
      0,
      0,
      1.051739,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.389351,
      NULL,
      2.709278,
      1,
      2.887962,
      0,
      1.138694,
      0.013784,
      2,
      2.033158,
      1.240376,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.435564,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.894370,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.035918,
      NULL,
      NULL,
      0,
      NULL,
      0.231366,
      1.882233,
      NULL,
      1.158927,
      0.264713,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      5.225465,
      5.050822,
      0,
      NULL,
      NULL,
      127,
      46,
      2.844816,
      0.463111,
      3.046744,
      '44010',
      '',
      NULL,
      0.819439,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


