set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '0313321',
      1.202951,
      0.775510,
      2,
      3,
      NULL,
      3,
      0.859058,
      NULL,
      NULL,
      ' 5- 2-1975',
      24,
      NULL,
      1.009156,
      NULL,
      1.050612,
      NULL,
      14,
      2.461505,
      358.495870,
      126.466802,
      0.704032,
      ' 1-27-1982',
      ' 6-14-1995',
      ' 6- 5-1989',
      NULL,
      1.319902,
      3,
      1,
      0.845687,
      3.487648,
      NULL,
      0,
      0,
      4,
      12.794929,
      5,
      2.912142,
      2,
      18.212541,
      5,
      10,
      3,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.728761,
      0,
      9,
      NULL,
      2.492089,
      NULL,
      2,
      3,
      2.899982,
      0.572954,
      1.436977,
      NULL,
      4.287835,
      NULL,
      1.031590,
      3.634678,
      1.890012,
      1.367386,
      4.824078,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11.879214,
      NULL,
      2.321821,
      1.737180,
      1.319875,
      0.316064,
      2.437618,
      1,
      NULL,
      NULL,
      3,
      1.769056,
      NULL,
      2.706689,
      0.351714,
      1,
      0,
      1,
      1,
      0,
      2,
      2,
      2.008043,
      1.420175,
      NULL,
      1.398796,
      0,
      NULL,
      NULL,
      1.764490,
      NULL,
      NULL,
      1.098455,
      1.215800,
      2.634719,
      1.754281,
      3.918934,
      0,
      4.516577,
      1.320789,
      0,
      NULL,
      NULL,
      0.617283,
      1.891125,
      6.076040,
      0,
      NULL,
      0,
      0.153310,
      1,
      NULL,
      0,
      5,
      NULL,
      8,
      10,
      0.506641,
      7,
      NULL,
      1,
      2.953578,
      0,
      2,
      0,
      4,
      4.477976,
      NULL,
      2,
      4.945062,
      9.548477,
      9.697803,
      6.073081,
      5,
      2,
      NULL,
      8.642690,
      NULL,
      4.514833,
      3,
      ' 6-21-1979',
      31,
      NULL,
      15,
      0,
      3.137659,
      0.814710,
      2.516954,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613532,
      NULL,
      1.989614,
      0.550869,
      NULL,
      0,
      2.949927,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847265,
      0.145844,
      NULL,
      1.866399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951009,
      1.750312,
      3.704346,
      NULL,
      0.390819,
      1.715661,
      1,
      1.419569,
      NULL,
      0.878371,
      NULL,
      9,
      0.188294,
      1.249238,
      NULL,
      NULL,
      NULL,
      9.548735,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344328,
      1.767549,
      0,
      0,
      NULL,
      0.559707,
      1.195831,
      NULL,
      1.562916,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.189841,
      0.031398,
      NULL,
      2.892305,
      2,
      3.784530,
      3,
      1.020136,
      1,
      0.823173,
      1.677262,
      0.089824,
      2,
      0,
      1.529098,
      3.635505,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0.715805,
      1.973499,
      1.653089,
      NULL,
      1.165405,
      1,
      NULL,
      7.994638,
      4,
      4.991910,
      2,
      NULL,
      NULL,
      3.448634,
      3.397442,
      1,
      11,
      1.588039,
      3.604104,
      NULL,
      NULL,
      17.535825,
      62.961276,
      4,
      1,
      3.469033,
      '14304',
      NULL,
      '',
      1.060205,
      '',
      '',
      '',
      0.165452,
      '',
      '',
      '',
      1.189398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.877367,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.757954,
      NULL,
      NULL,
      0.389957,
      NULL,
      0.211557,
      NULL,
      12.033585,
      1,
      1,
      NULL,
      0,
      1.792924,
      1,
      NULL,
      1.897138,
      NULL,
      0,
      0.436457,
      NULL,
      NULL,
      0,
      1,
      1.940772,
      0.567525,
      1,
      NULL,
      0.728711,
      NULL,
      0.976312,
      NULL,
      1.029331,
      NULL,
      0.528975,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      36.103849,
      1,
      0,
      NULL,
      NULL,
      0.422158,
      NULL,
      0.332006,
      NULL,
      0.944630,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.907298,
      NULL,
      1,
      NULL,
      0.084943,
      NULL,
      NULL,
      NULL,
      0.341806,
      NULL,
      0.383784,
      NULL,
      1,
      NULL,
      0.615977,
      3.061611,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.660256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232870,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.893439,
      NULL,
      0,
      NULL,
      1.884259,
      0,
      1.340618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      34.000689,
      NULL,
      2,
      NULL,
      1.492334,
      NULL,
      1,
      1.611691,
      2,
      32,
      NULL,
      0.148716,
      NULL,
      NULL,
      NULL,
      4.364136,
      2,
      2.487934,
      1.156610,
      NULL,
      3,
      3.280981,
      5,
      4.582139,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3.056527,
      2,
      NULL,
      1.931023,
      2.301593,
      NULL,
      NULL,
      1,
      NULL,
      3.938965,
      3,
      NULL,
      0.732033,
      2,
      NULL,
      1.920184,
      1.192610,
      NULL,
      1.529416,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809082,
      0.367772,
      NULL,
      0,
      0.413686,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.138027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.252789,
      NULL,
      1,
      NULL,
      1.300555,
      7,
      0,
      1.332725,
      NULL,
      NULL,
      60,
      NULL,
      1.672160,
      2.622083,
      0,
      '30012',
      NULL,
      '30121',
      2,
      '30133',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


