set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '32',
      17,
      6.739638,
      '3020144',
      2.899962,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1988',
      NULL,
      9.138881,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 1-17-1982',
      ' 3- 0-1982',
      ' 1-26-1978',
      0.397006,
      2,
      1,
      0,
      1.570680,
      0.498673,
      NULL,
      3.451687,
      NULL,
      NULL,
      NULL,
      4,
      2.796864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.661116,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.522750,
      1.611127,
      0.877627,
      0.457555,
      3,
      NULL,
      0,
      3,
      NULL,
      1,
      8.912626,
      1,
      2.009312,
      0.974071,
      0,
      NULL,
      11,
      NULL,
      9.057449,
      1,
      NULL,
      7.894413,
      3.666080,
      NULL,
      3,
      1.536431,
      1,
      0.184198,
      NULL,
      NULL,
      1.596928,
      NULL,
      NULL,
      8,
      NULL,
      6.677651,
      1.582843,
      1,
      0.132806,
      0.997089,
      2,
      2.364865,
      1,
      2.546661,
      0,
      NULL,
      1,
      1,
      0.415578,
      0,
      1.628849,
      1,
      1,
      1.458096,
      0,
      6,
      1,
      2.837109,
      1,
      0.116047,
      NULL,
      NULL,
      0.167258,
      NULL,
      NULL,
      1.243780,
      0.073965,
      0.918340,
      0.269857,
      NULL,
      0,
      0.285933,
      NULL,
      0,
      NULL,
      0.188667,
      1.644606,
      0.245396,
      0,
      0.258238,
      1.006500,
      1.589495,
      1,
      1.701038,
      NULL,
      0,
      1.123462,
      1,
      0.576558,
      1.707073,
      0.006124,
      0,
      2.501293,
      1.728085,
      1,
      NULL,
      1,
      NULL,
      3.874521,
      NULL,
      4,
      4.404046,
      0,
      1.813658,
      3,
      0,
      8,
      2.663074,
      NULL,
      0.171670,
      3,
      3,
      NULL,
      ' 2-28-1990',
      9,
      '11-24-1974',
      7.925363,
      0.564127,
      1.618456,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677416,
      0.730854,
      0.222800,
      1.734882,
      0.408567,
      1.088046,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.369944,
      NULL,
      3.351781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507118,
      NULL,
      7,
      NULL,
      3,
      2,
      NULL,
      0.816804,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434728,
      0,
      0.477797,
      0.692000,
      1.409609,
      0.009941,
      0.951201,
      0.881945,
      38,
      1.179959,
      0.353343,
      NULL,
      NULL,
      NULL,
      2.647719,
      1.705418,
      1,
      1.792727,
      1,
      3.279485,
      0.240120,
      NULL,
      1.336137,
      2,
      3,
      NULL,
      2.191909,
      2,
      0,
      NULL,
      5,
      NULL,
      1.676576,
      NULL,
      0.306913,
      0.372255,
      NULL,
      NULL,
      0,
      1.435708,
      0.053431,
      0,
      0.745635,
      1.468962,
      0.790145,
      1,
      8.553471,
      NULL,
      2.805150,
      1.190252,
      5.548946,
      4.637913,
      2.999469,
      2.892582,
      0.890139,
      0,
      3.870666,
      2,
      26,
      0.484912,
      NULL,
      NULL,
      NULL,
      5.758645,
      70,
      1.854106,
      1.818299,
      1.794303,
      '03041',
      '2104',
      '',
      NULL,
      '',
      '',
      NULL,
      1.765339,
      '',
      '',
      '',
      1.195081,
      25.706991,
      4,
      36,
      2,
      NULL,
      NULL,
      2,
      0.535935,
      0.905457,
      2,
      1.100345,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103165,
      NULL,
      NULL,
      2,
      0.903875,
      0,
      1.284446,
      NULL,
      NULL,
      3,
      2.999335,
      1.395205,
      1.668785,
      NULL,
      NULL,
      0,
      3,
      0.858815,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.830276,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737569,
      NULL,
      NULL,
      NULL,
      2,
      0.234007,
      1.558715,
      0,
      NULL,
      3.699764,
      3,
      3,
      1,
      0,
      1.935008,
      0.715876,
      2,
      0,
      2,
      3.671023,
      2,
      1,
      NULL,
      0.251864,
      0,
      0.127855,
      0.143110,
      0.438553,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.484785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.138685,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.028652,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857113,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.214100,
      NULL,
      NULL,
      0.503758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.575972,
      NULL,
      NULL,
      NULL,
      3.428672,
      3.337719,
      1,
      2.571277,
      3,
      1,
      NULL,
      3.188109,
      NULL,
      NULL,
      1,
      1.742902,
      2.946886,
      0,
      3.744358,
      3,
      NULL,
      1.445155,
      1,
      2.147524,
      NULL,
      0,
      2,
      3,
      7.036751,
      6,
      3.377210,
      NULL,
      4,
      0,
      2,
      0.882682,
      NULL,
      1,
      NULL,
      1.677019,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.754742,
      NULL,
      NULL,
      2.470852,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.503707,
      NULL,
      1,
      1.171851,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5.916991,
      2,
      NULL,
      NULL,
      4.771682,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.240764,
      NULL,
      NULL,
      NULL,
      3.972689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.555091,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.112892,
      NULL,
      NULL,
      NULL,
      3.267056,
      NULL,
      NULL,
      NULL,
      0.810745,
      NULL,
      NULL,
      NULL,
      3,
      0.158479,
      NULL,
      NULL,
      0.466459,
      0,
      NULL,
      NULL,
      1,
      0.540863,
      NULL,
      NULL,
      NULL,
      0.989134,
      NULL,
      NULL,
      1.910193,
      2,
      NULL,
      NULL,
      1,
      1.602606,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.964593,
      2,
      0.388688,
      3.016657,
      NULL,
      0.775981,
      1.845704,
      0,
      1.257777,
      NULL,
      NULL,
      1.044150,
      NULL,
      NULL,
      1.786692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      299.821206,
      10,
      1,
      NULL,
      0,
      1.456671,
      2,
      NULL,
      1.453889,
      0.469904,
      0,
      0.069259,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.756766,
      0.665210,
      0,
      NULL,
      1,
      NULL,
      0.129315,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      61.414037,
      NULL,
      3,
      NULL,
      19,
      NULL,
      NULL,
      3,
      5,
      2.865065,
      NULL,
      1.014887,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1.819622,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354783,
      NULL,
      1,
      NULL,
      2.269099,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028664,
      NULL,
      1.854520,
      NULL,
      NULL,
      NULL,
      1.132027,
      NULL,
      2,
      0.708561,
      0.212148,
      NULL,
      NULL,
      NULL,
      404.720353,
      NULL,
      0,
      NULL,
      1.313019,
      NULL,
      1.249820,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804947,
      0.080864,
      0,
      NULL,
      3.321570,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      1.135734,
      9.382473,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      1.734203,
      0.603001,
      0,
      0,
      5.745694,
      1,
      3.688623,
      11.137243,
      1.195913,
      2.227838,
      NULL,
      0,
      0.476563,
      0.107202,
      0,
      3,
      2,
      NULL,
      NULL,
      2.085503,
      1.341720,
      1.786820,
      1.631784,
      1,
      0.807251,
      3.970547,
      NULL,
      1,
      1.529545,
      NULL,
      1,
      1,
      1,
      1.754814,
      0.635355,
      1.362662,
      1.042047,
      NULL,
      0.052640,
      1.201562,
      2,
      0.006388,
      0.611335,
      2.195461,
      1,
      1.395398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392711,
      1,
      NULL,
      0.537806,
      NULL,
      0,
      NULL,
      3,
      1.136543,
      0.583942,
      NULL,
      NULL,
      NULL,
      NULL,
      7.758758,
      1,
      NULL,
      '2104',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0.780226,
      '',
      '',
      '');
commit;
end;
/


