set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '33',
      NULL,
      39.799152,
      '4211144',
      1,
      0,
      6,
      1,
      '4213',
      0,
      0.816324,
      NULL,
      NULL,
      ' 9-25-1990',
      43,
      44,
      NULL,
      NULL,
      1.304728,
      ' 5-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 3- 3-1990',
      NULL,
      0,
      3.891118,
      1.953276,
      2.776980,
      0,
      2,
      NULL,
      1.499407,
      NULL,
      NULL,
      NULL,
      8,
      9.873769,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222739,
      1.959687,
      NULL,
      0.302436,
      1.379752,
      0,
      0,
      1.921794,
      1,
      NULL,
      1.785024,
      3,
      1.468557,
      0.857934,
      1,
      5,
      5.007253,
      0,
      0.530101,
      1.799910,
      1,
      10,
      3.659846,
      1.634145,
      0,
      0,
      1.921818,
      1.957698,
      NULL,
      1,
      5,
      0,
      3.371340,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.026969,
      1.387432,
      0,
      2,
      0.661200,
      1.481822,
      NULL,
      NULL,
      0,
      0,
      0,
      0.109751,
      3,
      0.950729,
      NULL,
      0,
      1,
      NULL,
      0,
      0.855633,
      1,
      NULL,
      0.091182,
      0.063426,
      0.083456,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      6.303334,
      NULL,
      0.324103,
      6,
      NULL,
      5.712424,
      0.846061,
      NULL,
      2.133289,
      4.770467,
      1,
      1,
      1,
      0.488746,
      0,
      NULL,
      1.858012,
      NULL,
      NULL,
      0,
      0.257094,
      NULL,
      1,
      0.787216,
      1,
      0.184608,
      NULL,
      0,
      0.030755,
      1.624341,
      NULL,
      0.437670,
      2,
      1.141777,
      1,
      0,
      0,
      4.549563,
      6.333593,
      2,
      2,
      9,
      NULL,
      3.507676,
      NULL,
      0,
      NULL,
      ' 8- 1-1981',
      175.004569,
      '11-15-2001',
      5.214133,
      NULL,
      0,
      3,
      3,
      1,
      NULL,
      4.735570,
      0,
      0.610273,
      3.008621,
      0.489850,
      0,
      2.453243,
      11,
      3.610002,
      NULL,
      1,
      0,
      0.304903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.833933,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.754642,
      NULL,
      NULL,
      1.178858,
      0.120635,
      5.608012,
      0.834533,
      0,
      0.510056,
      1.631292,
      NULL,
      NULL,
      NULL,
      1.763654,
      0,
      0.851898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.085118,
      0,
      0.518362,
      0.270248,
      0.383029,
      1.049685,
      NULL,
      2,
      7,
      3,
      1.065760,
      NULL,
      NULL,
      NULL,
      0.288967,
      1.509395,
      2.062592,
      2.065183,
      0,
      1.486326,
      0.928314,
      0,
      0.675406,
      3.813820,
      2.651473,
      3,
      1.377829,
      2.688323,
      4,
      1,
      1,
      1,
      1.774739,
      1,
      0.821346,
      NULL,
      0.176837,
      0.337223,
      1.854109,
      0.297403,
      0,
      NULL,
      1,
      NULL,
      1.798066,
      NULL,
      5,
      3,
      7.154196,
      NULL,
      NULL,
      0.084262,
      0,
      3.487096,
      1.219403,
      1,
      3.878489,
      NULL,
      3,
      2,
      2,
      NULL,
      NULL,
      37,
      15,
      3.228853,
      4.431942,
      NULL,
      '33204',
      '',
      NULL,
      1.239074,
      NULL,
      '',
      NULL,
      0.312278,
      '',
      '',
      '',
      2.649373,
      35.858493,
      43.325848,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708438,
      NULL,
      NULL,
      0.121742,
      NULL,
      NULL,
      0.482261,
      NULL,
      NULL,
      0.410665,
      0.928925,
      1.412184,
      NULL,
      NULL,
      3.219240,
      0.899745,
      NULL,
      NULL,
      2.249819,
      2.866970,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218564,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200404,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.655660,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547679,
      NULL,
      NULL,
      0,
      1,
      2,
      2.428695,
      2,
      3.814696,
      0,
      NULL,
      NULL,
      3,
      5,
      NULL,
      2.375867,
      2,
      2.773749,
      1.615071,
      NULL,
      NULL,
      1,
      0,
      2.828829,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833036,
      NULL,
      NULL,
      1.770229,
      NULL,
      NULL,
      1.483790,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415929,
      NULL,
      NULL,
      0.953183,
      NULL,
      NULL,
      1,
      2.790214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087377,
      NULL,
      NULL,
      2,
      3.601229,
      1.078800,
      3.978901,
      6.056512,
      0.352297,
      0.629647,
      NULL,
      2.989631,
      3,
      2.977692,
      NULL,
      0,
      3.882520,
      NULL,
      0,
      NULL,
      3.184962,
      6,
      NULL,
      NULL,
      NULL,
      3.157270,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.202390,
      1,
      0.622746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.776579,
      0,
      0.373751,
      0.744593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.086020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470038,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.218455,
      1,
      0.286928,
      0.385892,
      1,
      1.994331,
      1,
      0,
      0.619844,
      0.980483,
      0,
      1,
      0,
      0.460200,
      NULL,
      0.498331,
      1,
      1.363198,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.732693,
      0.848911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290060,
      1.598545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792063,
      0.374924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.361534,
      NULL,
      1.201322,
      NULL,
      NULL,
      NULL,
      1.544991,
      NULL,
      0.841094,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.731083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346853,
      0,
      NULL,
      2.196818,
      NULL,
      1.803258,
      NULL,
      NULL,
      NULL,
      0.956052,
      NULL,
      1.055446,
      NULL,
      NULL,
      0.619237,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.715136,
      1,
      2,
      3,
      NULL,
      0.086887,
      1.169253,
      NULL,
      3.985409,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2.435895,
      NULL,
      1.571449,
      2,
      NULL,
      0.863210,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.800448,
      1.089520,
      NULL,
      3.611195,
      0,
      0.070803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.048228,
      2.168198,
      0.823291,
      NULL,
      NULL,
      26,
      77.850781,
      5,
      2.077178,
      3.262606,
      '10022',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


