set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501739';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '4234331',
      3.740152,
      1.312001,
      0,
      0,
      '4443',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      40.292813,
      NULL,
      0.467244,
      1.097312,
      1.167455,
      ' 0-11-1976',
      113,
      NULL,
      118,
      18,
      NULL,
      NULL,
      ' 9-13-1976',
      ' 8-23-2003',
      3.416226,
      1,
      3.973282,
      2.130291,
      1.305279,
      3.556461,
      5,
      1.768484,
      NULL,
      NULL,
      NULL,
      0,
      0,
      12.146942,
      13.443947,
      8,
      16.296148,
      6.133802,
      3,
      NULL,
      3.714511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.244685,
      2.176216,
      2.937504,
      NULL,
      1,
      1,
      NULL,
      0.447088,
      1,
      1.744601,
      1.872437,
      0,
      0.000902,
      0.142802,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.959843,
      4,
      2.957437,
      0.449556,
      NULL,
      1.899911,
      NULL,
      NULL,
      3.779375,
      1,
      3.751677,
      1,
      0,
      2,
      1,
      NULL,
      2,
      3,
      0.342442,
      NULL,
      1.227469,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.671939,
      0,
      NULL,
      NULL,
      0.905762,
      NULL,
      0.012037,
      0.177185,
      1,
      1.246915,
      1.397413,
      3,
      1,
      3.861567,
      1.237599,
      1,
      1,
      1.189837,
      0.285238,
      NULL,
      0.707416,
      7,
      8.981978,
      0,
      3,
      0.993649,
      7,
      2,
      3,
      1,
      NULL,
      NULL,
      1.809870,
      2,
      1.786147,
      NULL,
      0.829152,
      0.253562,
      3,
      3,
      9.693152,
      4.946963,
      9,
      1.775906,
      NULL,
      6,
      2,
      1.870946,
      NULL,
      1485.759092,
      NULL,
      9,
      NULL,
      NULL,
      1.107878,
      0,
      1.497151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.674834,
      1.895810,
      0,
      1.389403,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333632,
      0.620328,
      0.287718,
      0,
      0.417540,
      0,
      1.748316,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102811,
      NULL,
      1,
      1.953548,
      NULL,
      1.310504,
      1.218012,
      36.521247,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.075191,
      NULL,
      1.363681,
      1.563925,
      3.124959,
      NULL,
      NULL,
      3,
      1,
      1,
      3.864378,
      1,
      0.298021,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      1,
      1,
      1,
      0.285096,
      1,
      1.890789,
      6.441695,
      3,
      5,
      NULL,
      7.711199,
      0.622049,
      4.076650,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      32,
      47,
      55.503090,
      0.182934,
      5.985211,
      1,
      NULL,
      '21121',
      '23414',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3,
      5,
      142.847601,
      49.100699,
      1,
      45,
      18.261852,
      107,
      3,
      3,
      0,
      3,
      3.542520,
      0,
      1,
      2.401495,
      1,
      1,
      0.734221,
      NULL,
      NULL,
      1.070119,
      NULL,
      NULL,
      1.854810,
      NULL,
      NULL,
      1,
      1.270587,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.975209,
      0.444975,
      1.033878,
      NULL,
      NULL,
      0,
      0.676371,
      NULL,
      1.156779,
      0,
      2.001617,
      NULL,
      0.862168,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.091144,
      0.378911,
      NULL,
      1.357942,
      1.725876,
      NULL,
      3,
      3,
      1.684271,
      2.260616,
      1,
      3,
      2.901036,
      1,
      1.983016,
      3.343945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120575,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.735827,
      6.182179,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248641,
      3,
      NULL,
      NULL,
      1.786859,
      1.183547,
      NULL,
      NULL,
      NULL,
      NULL,
      3.638667,
      6.239840,
      3,
      1.782508,
      1.071798,
      1.340393,
      NULL,
      NULL,
      1,
      0.185616,
      1,
      0,
      NULL,
      NULL,
      0.271463,
      NULL,
      NULL,
      0.413439,
      NULL,
      NULL,
      1.782215,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.802551,
      0,
      2.505623,
      1,
      1,
      7.237556,
      6,
      NULL,
      4.442818,
      5.488888,
      3,
      NULL,
      NULL,
      NULL,
      0.469733,
      NULL,
      NULL,
      1.372207,
      0,
      2.197315,
      0.348633,
      0.828071,
      0.679071,
      6.023093,
      1.631458,
      NULL,
      1.275077,
      1,
      2,
      3,
      0,
      3,
      3,
      1.076603,
      1,
      1.728533,
      1,
      NULL,
      8.552658,
      NULL,
      5,
      5.456033,
      1,
      5.928374,
      3.943054,
      0,
      2,
      NULL,
      0.637025,
      0.190824,
      NULL,
      0.531714,
      3.727792,
      NULL,
      NULL,
      2.108987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.936116,
      NULL,
      NULL,
      0.378791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.175162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.436181,
      NULL,
      3.793352,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.548667,
      NULL,
      NULL,
      NULL,
      0.830601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026322,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.432719,
      NULL,
      NULL,
      NULL,
      6.423589,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.605054,
      181.276232,
      461.027690,
      1.518774,
      NULL,
      NULL,
      1,
      66.235565,
      8.877892,
      0.257906,
      NULL,
      NULL,
      2,
      0.550151,
      2.671983,
      1,
      NULL,
      NULL,
      NULL,
      17,
      0.334903,
      153.867830,
      85.745923,
      NULL,
      NULL,
      1.448624,
      NULL,
      1,
      NULL,
      1.366029,
      0.483140,
      0.572359,
      0.722445,
      0.446780,
      1,
      1.941772,
      1.830717,
      0,
      1.071739,
      1.088222,
      1.523207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077468,
      NULL,
      0.845484,
      1.079061,
      0,
      NULL,
      1,
      0,
      0.823846,
      2,
      2.926933,
      3,
      1,
      0,
      0.458244,
      1,
      1,
      0,
      3,
      1,
      1,
      2.549364,
      1,
      2.028287,
      1,
      NULL,
      1.590345,
      NULL,
      1,
      1.387721,
      3,
      NULL,
      NULL,
      1.345360,
      0,
      NULL,
      NULL,
      NULL,
      1.409824,
      NULL,
      1,
      2,
      0.273787,
      1.685121,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.386111,
      0,
      1,
      4,
      0,
      6.013776,
      1.325151,
      NULL,
      NULL,
      66,
      19,
      3,
      4.157665,
      1.698339,
      '41302',
      '',
      '',
      1,
      '',
      '',
      '',
      0.008499,
      '',
      '',
      NULL);
commit;
end;
/


