set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      2,
      1.246923,
      NULL,
      0.582335,
      1.526379,
      NULL,
      3,
      NULL,
      '23442042',
      NULL,
      NULL,
      '2101202',
      1,
      0,
      2,
      2,
      '2234',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      88.843145,
      NULL,
      NULL,
      0.371756,
      1,
      ' 5-29-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-26-1979',
      0.152763,
      NULL,
      3.321005,
      3.029259,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.187048,
      7.343419,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.722323,
      NULL,
      1.175398,
      1,
      NULL,
      NULL,
      3,
      1.929001,
      0,
      0.690514,
      0.027811,
      0.218596,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932450,
      NULL,
      0,
      0,
      0,
      0,
      1.592080,
      0,
      0.476475,
      1.836336,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.684497,
      1.459483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.025999,
      1.982857,
      1.503873,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.894531,
      0,
      NULL,
      1.754172,
      0,
      0,
      0,
      0.354126,
      NULL,
      1,
      0,
      1.277423,
      NULL,
      1,
      0,
      1.100688,
      0.692306,
      1.455102,
      NULL,
      1,
      NULL,
      0,
      1.042530,
      0.437333,
      NULL,
      0,
      3.158193,
      4,
      NULL,
      0.894632,
      NULL,
      0,
      1,
      1,
      1,
      0.209585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.004268,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.185775,
      NULL,
      0,
      0.115076,
      0.101049,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.849363,
      0,
      1,
      1,
      3.902685,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.476007,
      NULL,
      0.488221,
      4.261733,
      0,
      0.519510,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.123886,
      0.963048,
      1,
      0.571035,
      0.685824,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883380,
      3.403408,
      0.998476,
      2.796778,
      NULL,
      NULL,
      0,
      2,
      2.413035,
      3,
      3.941589,
      0.173792,
      NULL,
      0,
      NULL,
      NULL,
      2.086225,
      1,
      2.250693,
      1.167449,
      0,
      1.286528,
      0.893444,
      0.736097,
      3,
      0,
      0,
      3,
      1,
      4.721611,
      1,
      6,
      9,
      5.630413,
      3.862875,
      9,
      3.168878,
      0,
      1.431030,
      3.455629,
      2.245913,
      1.033584,
      0,
      58.847192,
      0.645599,
      NULL,
      112,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.684563,
      '20412',
      '',
      '',
      0.825814,
      '',
      '',
      '',
      1.432851,
      '',
      '',
      '',
      3.220268,
      NULL,
      232,
      22,
      3.983695,
      30,
      0.736706,
      0,
      4,
      NULL,
      NULL,
      NULL,
      1.906995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.943389,
      NULL,
      NULL,
      1.658169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.977786,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4.227848,
      0.912236,
      0,
      3,
      0.988185,
      0,
      2,
      0.386971,
      NULL,
      NULL,
      0.395973,
      1.705786,
      0.000601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.113416,
      NULL,
      NULL,
      1.624274,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.570462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609672,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.745799,
      NULL,
      NULL,
      1.892391,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.227496,
      0.566836,
      NULL,
      2,
      0,
      1,
      5.770119,
      1,
      1,
      2,
      0.110125,
      1,
      2,
      1.075724,
      NULL,
      0.727969,
      0.117392,
      0.381223,
      0.017835,
      NULL,
      0.165729,
      2,
      0.048793,
      1,
      0.053856,
      NULL,
      NULL,
      1.115377,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      1.765019,
      NULL,
      2.624379,
      35.123561,
      NULL,
      NULL,
      0.206621,
      NULL,
      0,
      1.538224,
      NULL,
      1.487064,
      0,
      NULL,
      1.960202,
      1,
      NULL,
      3,
      0.588802,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.326692,
      NULL,
      0.666221,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2.116069,
      3,
      NULL,
      2.453645,
      1,
      NULL,
      1.203124,
      12,
      NULL,
      3,
      2.364966,
      NULL,
      1.942256,
      1.748831,
      3.564745,
      2,
      0,
      3.325049,
      0.555084,
      6,
      NULL,
      1.530037,
      NULL,
      11.786493,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.051301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188252,
      NULL,
      0,
      NULL,
      1.584036,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.423306,
      NULL,
      NULL,
      NULL,
      2.712059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930699,
      NULL,
      2.500074,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.751443,
      NULL,
      1.774045,
      NULL,
      0.542866,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030618,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      6,
      1,
      0,
      NULL,
      8.180673,
      1.543822,
      NULL,
      NULL,
      3,
      3,
      1,
      2,
      NULL,
      19,
      1,
      NULL,
      NULL,
      0.882832,
      NULL,
      1.009128,
      NULL,
      19.169664,
      0,
      NULL,
      1,
      1,
      1.724290,
      0.474041,
      1.751620,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0.647940,
      0.111341,
      1.433413,
      0,
      1.422533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.440812,
      NULL,
      1,
      1,
      NULL,
      1.711509,
      1.770194,
      2,
      3.014161,
      0,
      1,
      1,
      1.544055,
      1.929224,
      1.453601,
      0.517832,
      0.697677,
      0.317114,
      0,
      NULL,
      1.437478,
      1.721781,
      NULL,
      0,
      NULL,
      0.504351,
      1,
      1.083227,
      1.808668,
      0,
      0,
      NULL,
      0.636119,
      1,
      1,
      2,
      1,
      0.788845,
      0,
      0.253755,
      0,
      3,
      3.155806,
      1,
      NULL,
      2.942269,
      NULL,
      NULL,
      NULL,
      1.295441,
      NULL,
      3.969000,
      0,
      0.249059,
      0,
      0.729473,
      NULL,
      1.177883,
      0,
      0.356929,
      NULL,
      1,
      1,
      1.151898,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.477890,
      65.090718,
      0.680637,
      1.232598,
      0.361488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897457,
      0.571741,
      1.579120,
      NULL,
      0,
      0,
      5.073252,
      2,
      2,
      1,
      NULL,
      NULL,
      58.954523,
      62,
      5,
      NULL,
      3,
      '02121',
      '1030',
      '',
      0.049203,
      '',
      '',
      '',
      1.336930,
      '',
      '',
      '');
commit;
end;
/


