set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9003431';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2210413',
      2,
      0,
      3,
      1,
      NULL,
      1.300880,
      NULL,
      NULL,
      NULL,
      ' 6-15-1989',
      25,
      NULL,
      3,
      2.870221,
      1.453333,
      NULL,
      35.532253,
      1,
      NULL,
      31.764428,
      NULL,
      ' 8- 5-2000',
      NULL,
      ' 7-13-1975',
      1,
      1.419156,
      3.509916,
      0,
      0,
      0,
      7,
      NULL,
      0,
      NULL,
      2.107515,
      16.999754,
      5.395238,
      178,
      190,
      1.774597,
      17,
      6.246261,
      3.511942,
      5.721027,
      0,
      3,
      1.962937,
      0,
      1.989050,
      NULL,
      1,
      3.524941,
      NULL,
      0,
      0,
      1.993604,
      2,
      6,
      1.340726,
      0.277839,
      0.992031,
      NULL,
      2,
      NULL,
      6,
      1.686672,
      0,
      NULL,
      0.696651,
      2.932839,
      3,
      NULL,
      1.474141,
      NULL,
      0,
      NULL,
      1.145562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.001128,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0.103261,
      3.074752,
      1.874010,
      1,
      3,
      3,
      1.154683,
      3.623999,
      0,
      NULL,
      2.515033,
      NULL,
      0.727888,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.220037,
      NULL,
      NULL,
      1.199624,
      1,
      0,
      0.289266,
      4,
      NULL,
      5,
      1.075198,
      1.049892,
      4,
      1,
      0.694306,
      NULL,
      4.756763,
      1.984996,
      0,
      1,
      0,
      1,
      NULL,
      1,
      2,
      5,
      1,
      1,
      NULL,
      5.395738,
      8.922451,
      5.663639,
      2,
      NULL,
      NULL,
      7,
      9.489442,
      1,
      1,
      4.868404,
      NULL,
      NULL,
      11,
      NULL,
      6.001062,
      2,
      6.583364,
      2.367922,
      1,
      NULL,
      2.654833,
      ' 6-26-1979',
      118,
      ' 0- 8-1992',
      765.375467,
      0.373364,
      NULL,
      1.842641,
      6,
      1.480756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.327117,
      NULL,
      2.490071,
      NULL,
      1.794400,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284024,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100199,
      NULL,
      3,
      3,
      1.231544,
      0.612218,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.757317,
      0,
      0,
      0,
      1,
      1,
      19.369397,
      0,
      0.399287,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.218458,
      1.688033,
      2,
      0.810913,
      3,
      4.914465,
      3,
      3,
      NULL,
      NULL,
      4.082660,
      4,
      13.686307,
      19.930535,
      NULL,
      19,
      19,
      39,
      38,
      122.941293,
      NULL,
      168.016495,
      124,
      NULL,
      NULL,
      142,
      1.298150,
      1,
      5.364796,
      0,
      10.964384,
      11,
      7.896737,
      9,
      1,
      0,
      5,
      0.188093,
      6,
      NULL,
      NULL,
      1.472938,
      NULL,
      3.012694,
      NULL,
      NULL,
      15.693829,
      NULL,
      43.006128,
      2,
      NULL,
      0.105277,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '4142',
      '',
      NULL,
      46.406624,
      274.854532,
      NULL,
      3.619147,
      57,
      9.931433,
      22.641658,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882843,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      10.242621,
      NULL,
      3,
      4.358176,
      16,
      1.834749,
      NULL,
      NULL,
      NULL,
      3.349100,
      15,
      2,
      0.967444,
      8.213934,
      4,
      NULL,
      NULL,
      19.815413,
      NULL,
      NULL,
      17.243772,
      NULL,
      NULL,
      2,
      2.275421,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      2.674698,
      0,
      0.339172,
      11,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.125029,
      1,
      1.219056,
      0.017127,
      1,
      0,
      0.682851,
      1.349530,
      0,
      0,
      0.725511,
      NULL,
      2,
      1,
      1.497086,
      0.868995,
      17.878841,
      NULL,
      NULL,
      15.039580,
      NULL,
      NULL,
      6.537660,
      NULL,
      NULL,
      5,
      3,
      3,
      1.226276,
      1.886491,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.259115,
      NULL,
      NULL,
      1.770109,
      19.301288,
      NULL,
      0,
      NULL,
      1.945974,
      1,
      NULL,
      NULL,
      3.827421,
      1,
      1,
      4.866163,
      NULL,
      NULL,
      13.525198,
      NULL,
      NULL,
      0.964530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.026957,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.435056,
      NULL,
      NULL,
      18.702972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.567229,
      NULL,
      2.668859,
      NULL,
      7.927209,
      NULL,
      1,
      0,
      1,
      8,
      NULL,
      NULL,
      1.663440,
      2.004361,
      2.187315,
      NULL,
      0.391457,
      1,
      NULL,
      NULL,
      NULL,
      3,
      16,
      3,
      1,
      19.394345,
      NULL,
      7,
      3.678689,
      0,
      0.969247,
      NULL,
      NULL,
      2,
      NULL,
      4.666971,
      NULL,
      NULL,
      1.829741,
      1,
      1,
      2,
      NULL,
      NULL,
      0.456399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      0.038765,
      NULL,
      NULL,
      16.612864,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0.254691,
      NULL,
      7.155723,
      0,
      NULL,
      NULL,
      9.045115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      16.863827,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.736310,
      0,
      NULL,
      NULL,
      3.607515,
      0.350022,
      NULL,
      NULL,
      0.760546,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.573460,
      3.765412,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1.454298,
      NULL,
      NULL,
      NULL,
      NULL,
      0.156361,
      60,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      460.925210,
      NULL,
      1.350306,
      1.012615,
      1,
      1,
      1,
      0,
      0,
      1.695847,
      0,
      1,
      0.102710,
      0,
      0.752438,
      0,
      1.345337,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.419498,
      NULL,
      1.251398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337533,
      NULL,
      1,
      NULL,
      0.189875,
      NULL,
      NULL,
      NULL,
      0.463048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.855448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.014414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.532317,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.328938,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      3.308423,
      2,
      NULL,
      6.969314,
      9,
      NULL,
      NULL,
      4.374139,
      NULL,
      NULL,
      16.277756,
      NULL,
      NULL,
      14.119865,
      NULL,
      19.927101,
      11.278777,
      NULL,
      11.895489,
      NULL,
      NULL,
      12.274915,
      11.088872,
      NULL,
      13,
      NULL,
      NULL,
      12.257926,
      13,
      NULL,
      2.347354,
      NULL,
      NULL,
      4,
      17,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.528700,
      NULL,
      4,
      2.077444,
      0,
      0,
      27.505970,
      NULL,
      0.454029,
      1.496241,
      1,
      '03114',
      '',
      '',
      0.841057,
      '',
      '',
      '',
      NULL,
      NULL,
      '4344',
      NULL);
commit;
end;
/


