set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9864346';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1.577557,
      2.119122,
      1,
      1.696827,
      3,
      4.486430,
      2.563045,
      '334',
      '12224422',
      NULL,
      37,
      '4333031',
      NULL,
      1.298239,
      5,
      NULL,
      '4140',
      1.767262,
      NULL,
      NULL,
      NULL,
      NULL,
      49.968601,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185826,
      NULL,
      ' 8-14-1987',
      ' 1- 5-1983',
      0,
      1.794723,
      NULL,
      NULL,
      NULL,
      0.089454,
      3.232962,
      2,
      NULL,
      NULL,
      NULL,
      10.945087,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.953031,
      3,
      NULL,
      0.165661,
      3,
      0.578555,
      1.791806,
      1,
      1,
      1,
      1.626300,
      0,
      0,
      1,
      0.269922,
      3,
      3.710994,
      NULL,
      7,
      NULL,
      0,
      3.305520,
      0.581109,
      NULL,
      NULL,
      1,
      0,
      1,
      0.324301,
      1.772533,
      5.330875,
      NULL,
      1,
      4,
      1.634620,
      1.227462,
      NULL,
      NULL,
      1.354535,
      NULL,
      NULL,
      6.777457,
      NULL,
      0.513022,
      NULL,
      NULL,
      1.586646,
      0.936421,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      0,
      1.934634,
      2.203533,
      0,
      1,
      2.595525,
      1.711689,
      3.282321,
      2.576751,
      1,
      NULL,
      1.613807,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.433373,
      5.431139,
      NULL,
      NULL,
      0.202898,
      3.654194,
      1.764223,
      3,
      2.846224,
      1.389659,
      NULL,
      3.768905,
      1,
      4,
      0.955043,
      1.095330,
      0,
      1,
      0,
      NULL,
      NULL,
      1.015659,
      0,
      5,
      NULL,
      1.767315,
      4.939992,
      6.869288,
      2,
      3,
      4,
      0.044484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      6,
      NULL,
      4,
      8,
      8,
      4.683220,
      2,
      4.371095,
      NULL,
      ' 6-16-1996',
      235,
      ' 5- 5-1994',
      76.375073,
      3,
      0,
      1.639039,
      NULL,
      1.376336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484650,
      1,
      1.625687,
      1.221741,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146374,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.932676,
      3.813219,
      0.006385,
      1,
      6,
      9,
      1.221913,
      NULL,
      NULL,
      0.316902,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.752020,
      1.975540,
      1.401570,
      1.673762,
      0,
      1.204439,
      1,
      8.460972,
      0.914778,
      0,
      NULL,
      NULL,
      NULL,
      2.699315,
      1,
      1.001866,
      2,
      3,
      0,
      0,
      1,
      3.465630,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.365824,
      1.129522,
      4.032563,
      0,
      0.801877,
      1.013402,
      0.692592,
      NULL,
      0,
      1.429198,
      0.350633,
      1,
      NULL,
      1,
      1,
      NULL,
      1.187566,
      1,
      7.853643,
      3.144201,
      2.814204,
      3.166531,
      NULL,
      1.965655,
      1.180886,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.349244,
      1.540477,
      47,
      NULL,
      11,
      52,
      5.575154,
      5.040636,
      NULL,
      '43331',
      '34034',
      '',
      0.566514,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.806458,
      20,
      28,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      0.238062,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.982218,
      3,
      0.333217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.262943,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.288588,
      1.361465,
      1.909603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      2,
      0.656298,
      3,
      1.001595,
      NULL,
      NULL,
      3.067404,
      1.755167,
      1.909691,
      1.971123,
      0.646582,
      1,
      2,
      1,
      1.188705,
      0.289901,
      NULL,
      NULL,
      0,
      3.350617,
      1,
      NULL,
      1.608959,
      0.068624,
      1,
      NULL,
      0.195232,
      1.175583,
      1.164809,
      1,
      0.481939,
      0.331074,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.270979,
      2,
      0.237297,
      1.155986,
      0,
      1,
      0.276273,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      1.972502,
      NULL,
      NULL,
      NULL,
      0.043874,
      4,
      0,
      1.453471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.790692,
      NULL,
      NULL,
      1.460733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886103,
      NULL,
      NULL,
      1.041651,
      NULL,
      NULL,
      NULL,
      3.771527,
      3.058601,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.051471,
      0,
      2,
      0,
      3.124546,
      NULL,
      3.747575,
      7,
      4.523181,
      4.301096,
      NULL,
      2.342304,
      NULL,
      1,
      1,
      2,
      3,
      NULL,
      2,
      2,
      0,
      NULL,
      1,
      4.204685,
      6.351775,
      4,
      2,
      3.461469,
      2,
      3.651106,
      4,
      1,
      NULL,
      0,
      1,
      1,
      1.413402,
      NULL,
      NULL,
      1.979620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.143086,
      NULL,
      NULL,
      0.515704,
      NULL,
      NULL,
      3.983566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.494508,
      3,
      0,
      NULL,
      NULL,
      1.852285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.307418,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.895008,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.303213,
      NULL,
      NULL,
      NULL,
      1.511581,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.780021,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.922585,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      79.781368,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.904087,
      0.050380,
      1.279289,
      1.129027,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649074,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856186,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.546424,
      1.373959,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.653544,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.637616,
      5,
      9,
      2.165974,
      2.739853,
      1.567347,
      0.583913,
      9,
      2,
      0.594570,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.307435,
      NULL,
      0.545122,
      2,
      NULL,
      1.916705,
      1.092267,
      NULL,
      0,
      2,
      NULL,
      0.259785,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.187265,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.471648,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.159137,
      NULL,
      5.846883,
      1.449715,
      2,
      NULL,
      NULL,
      NULL,
      58.330497,
      119.087261,
      NULL,
      2.729680,
      3.364290,
      '22031',
      '04242',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


