set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      1.991838,
      0.806869,
      5,
      1,
      '1424',
      2.730484,
      1,
      NULL,
      NULL,
      ' 5- 8-1980',
      33.416562,
      NULL,
      2.327725,
      NULL,
      3,
      NULL,
      34.476534,
      2,
      302.624179,
      109,
      3.573007,
      NULL,
      ' 0-25-1983',
      ' 6-27-1988',
      NULL,
      1,
      NULL,
      1,
      1.956295,
      1.361978,
      3.276568,
      0.565008,
      1,
      1,
      8.512082,
      1.954541,
      1,
      12.199360,
      13.195098,
      2.079796,
      NULL,
      9,
      1,
      4.738912,
      0,
      1.832874,
      1.908014,
      NULL,
      1.776120,
      1,
      NULL,
      0,
      0,
      1,
      123,
      3.130552,
      8.874848,
      3.111908,
      2,
      3.105991,
      0.371887,
      0,
      1,
      2,
      1,
      3.286099,
      0,
      1,
      1.524492,
      NULL,
      1,
      5.973638,
      1,
      2.901317,
      1,
      1.111607,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.862219,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477051,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.738718,
      2,
      1.391823,
      NULL,
      NULL,
      0.251966,
      1.386304,
      1.656574,
      0,
      1.043729,
      1.362163,
      0.770102,
      1.617424,
      1.422782,
      0.320772,
      0.493003,
      NULL,
      NULL,
      7.233927,
      3.141605,
      1.924118,
      1.812960,
      NULL,
      4,
      5,
      1.178756,
      2,
      2.151790,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      8,
      4.875852,
      NULL,
      1.190224,
      5,
      6,
      NULL,
      2,
      9,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.637650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807691,
      NULL,
      0.328282,
      0.746828,
      0.397984,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.343016,
      3.506253,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208971,
      2.160162,
      3.278282,
      0,
      1.225295,
      NULL,
      1,
      3.241913,
      1,
      4.206285,
      NULL,
      9.063663,
      1,
      0,
      4,
      NULL,
      8.997341,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.081406,
      1.869322,
      1.252544,
      NULL,
      17,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3.951974,
      0.550587,
      3,
      2.663389,
      0,
      NULL,
      1.051352,
      1,
      2,
      2.333595,
      3,
      2,
      1,
      0.758967,
      1,
      NULL,
      1,
      NULL,
      1,
      4,
      0,
      0.304321,
      0.582157,
      1.083885,
      1.215075,
      NULL,
      1.996417,
      1,
      1,
      NULL,
      5.765307,
      1.687925,
      6.638935,
      8,
      1,
      0.868703,
      0,
      NULL,
      3.050196,
      0,
      6.364812,
      1.537685,
      0.634763,
      NULL,
      33,
      0,
      3.941140,
      NULL,
      34,
      32.505374,
      68,
      0.219354,
      1,
      0,
      '32413',
      '',
      '',
      2,
      '20331',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      0,
      9.475356,
      1.139710,
      NULL,
      0,
      19,
      13.381005,
      4.923371,
      2,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.234751,
      NULL,
      NULL,
      1.150340,
      NULL,
      NULL,
      0.330200,
      NULL,
      NULL,
      0,
      3,
      0.840146,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.909796,
      0.121917,
      0,
      1.751699,
      NULL,
      NULL,
      0.182817,
      NULL,
      NULL,
      4,
      3.636626,
      3.211588,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      NULL,
      0.296582,
      NULL,
      1.892760,
      NULL,
      NULL,
      NULL,
      1.983542,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.069917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173185,
      NULL,
      NULL,
      NULL,
      11.338810,
      0.342048,
      1.374786,
      NULL,
      NULL,
      2,
      1.689926,
      0,
      0,
      NULL,
      NULL,
      0.244568,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.098483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908000,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2.281511,
      2,
      3.872731,
      NULL,
      1,
      3.760660,
      2.300621,
      7,
      2,
      1.335083,
      NULL,
      NULL,
      0.722449,
      2.698374,
      NULL,
      0,
      3,
      0,
      NULL,
      1.731000,
      2.158280,
      8,
      5.783631,
      5,
      3,
      1.943073,
      NULL,
      1.601116,
      NULL,
      NULL,
      NULL,
      3.351571,
      NULL,
      0,
      1,
      NULL,
      2.647415,
      6,
      NULL,
      NULL,
      4,
      2,
      0,
      NULL,
      NULL,
      0.000246,
      1,
      1,
      1.871599,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257126,
      1.230458,
      0,
      2,
      0.349287,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602257,
      NULL,
      NULL,
      NULL,
      1.557852,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.224383,
      NULL,
      NULL,
      NULL,
      1.652132,
      NULL,
      NULL,
      NULL,
      2.819076,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.433240,
      NULL,
      NULL,
      NULL,
      0.087575,
      NULL,
      NULL,
      NULL,
      2.828866,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      0,
      15.864443,
      4.619974,
      0,
      NULL,
      NULL,
      0.854756,
      NULL,
      NULL,
      0,
      0,
      1.562585,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      1,
      NULL,
      0,
      35.719993,
      3.239614,
      0,
      0,
      0.394322,
      0.692404,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1.425710,
      NULL,
      0,
      1.841245,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      7,
      3.924257,
      3.326338,
      NULL,
      4,
      9.455161,
      NULL,
      2.550925,
      3,
      0.621245,
      0.679523,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.127383,
      2,
      NULL,
      2.881800,
      2.747936,
      0,
      2,
      0.353737,
      3.857238,
      2,
      2.143740,
      3.646411,
      NULL,
      NULL,
      NULL,
      1.902664,
      0,
      3.483986,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.209492,
      1,
      2,
      3,
      3.143331,
      1.305206,
      NULL,
      NULL,
      0.433464,
      2,
      0,
      0,
      NULL,
      0,
      3,
      NULL,
      3.127221,
      NULL,
      2.662847,
      NULL,
      1.686539,
      0.252775,
      0.309264,
      3,
      0.786586,
      20.934196,
      NULL,
      NULL,
      NULL,
      0.836891,
      1,
      0.376252,
      1,
      0.044602,
      1,
      NULL,
      NULL,
      NULL,
      49,
      42.141414,
      3.985333,
      0.584874,
      0.612450,
      '33014',
      NULL,
      '',
      2,
      '01121',
      '10333',
      '11333',
      0,
      '',
      '',
      '');
commit;
end;
/


