set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505264';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3043140',
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '10-24-2002',
      5.973713,
      NULL,
      1,
      1,
      0.342855,
      NULL,
      38.441302,
      1,
      NULL,
      14.468394,
      2.527031,
      NULL,
      '11-16-2001',
      ' 5- 7-1993',
      2,
      NULL,
      3,
      2,
      1.883032,
      NULL,
      4,
      NULL,
      1.124454,
      27.927944,
      8.422671,
      13.215314,
      8,
      25.037504,
      NULL,
      5.171937,
      NULL,
      6.900341,
      NULL,
      2,
      0,
      NULL,
      1,
      1.618568,
      NULL,
      1.280436,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      7.081239,
      2.505148,
      0,
      NULL,
      2.948958,
      10.108325,
      2.808434,
      0,
      0.624195,
      0.906826,
      1,
      0,
      5.167370,
      4,
      11,
      0.918864,
      2,
      NULL,
      3.736369,
      0.666365,
      NULL,
      NULL,
      1,
      2.906095,
      1.865550,
      7,
      4.619371,
      4.011938,
      3.189497,
      1,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      0,
      0.929553,
      1.907388,
      1.202071,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      7,
      1.423227,
      1,
      0,
      1,
      NULL,
      NULL,
      3.899608,
      0.028588,
      4.783368,
      NULL,
      6.819847,
      2,
      1.114029,
      1.662695,
      4.197185,
      0,
      1.754517,
      0,
      5,
      0.935320,
      3,
      NULL,
      5,
      0.103946,
      0,
      1.721601,
      0,
      1,
      NULL,
      0.357339,
      8.845858,
      2.260683,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.842788,
      NULL,
      1.186983,
      NULL,
      0,
      NULL,
      0,
      NULL,
      6.787227,
      0,
      5.376550,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      ' 3- 2-1989',
      NULL,
      ' 9-24-1999',
      619.311766,
      3,
      3.868764,
      4.532204,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940813,
      0,
      1.760610,
      NULL,
      0.190349,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.904172,
      NULL,
      0.094439,
      1.300534,
      3.018777,
      0,
      3.029363,
      0,
      1,
      0,
      2.525852,
      NULL,
      0.609333,
      0,
      1.287634,
      9,
      NULL,
      3,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1.834789,
      0.176800,
      NULL,
      NULL,
      8,
      7,
      8.450151,
      NULL,
      7,
      ' 1- 1-1991',
      1.582882,
      2,
      0.045519,
      4.400485,
      0,
      0,
      0.842030,
      NULL,
      3,
      1.831107,
      1,
      NULL,
      38.484811,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.705745,
      2.725680,
      3.468035,
      2.579891,
      2,
      3.282761,
      1,
      0,
      0,
      1.394898,
      1.980261,
      0.734423,
      3.051403,
      NULL,
      1,
      7,
      0,
      1,
      0,
      0,
      1.139588,
      3.057500,
      0,
      NULL,
      2.397270,
      1,
      1.095371,
      2.419012,
      0.483757,
      NULL,
      0,
      0,
      NULL,
      NULL,
      9.149134,
      1.240937,
      5.244273,
      3.512870,
      2,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3.154343,
      1.630194,
      NULL,
      80,
      30.318589,
      0,
      1.014355,
      NULL,
      5,
      NULL,
      '00432',
      '32324',
      2,
      '31002',
      NULL,
      '',
      2.995048,
      '1320',
      '3311',
      '',
      NULL,
      11,
      92,
      20,
      2,
      32,
      NULL,
      4,
      0.383854,
      NULL,
      0.726440,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      1.654703,
      1.755478,
      NULL,
      3.230674,
      3,
      3.802171,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.069195,
      0.782340,
      0.381342,
      NULL,
      NULL,
      1.003732,
      NULL,
      NULL,
      0.934378,
      NULL,
      NULL,
      0,
      1,
      1.585311,
      2,
      0,
      0,
      3,
      9,
      9,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.317198,
      NULL,
      NULL,
      NULL,
      2.717284,
      NULL,
      2.366271,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3.293248,
      NULL,
      0,
      1,
      2.820658,
      0.971319,
      3,
      1.330451,
      2.667573,
      NULL,
      3.922797,
      2,
      0.838509,
      0,
      NULL,
      0.515088,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.425416,
      1.803361,
      2,
      5,
      3.150505,
      NULL,
      0.751798,
      0.963037,
      NULL,
      NULL,
      NULL,
      1.791207,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.475620,
      3.101805,
      0.290270,
      1,
      NULL,
      NULL,
      5,
      11,
      0,
      1.003884,
      3,
      0.603038,
      0,
      NULL,
      NULL,
      2.495419,
      1,
      1,
      0.770926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.452028,
      NULL,
      NULL,
      1.347036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.252988,
      1,
      1.682476,
      2.108658,
      1.568171,
      7,
      NULL,
      2.587638,
      7,
      1.511709,
      0.923491,
      3,
      4,
      NULL,
      1,
      1,
      0.908123,
      1.181685,
      NULL,
      2,
      1.693940,
      NULL,
      2.172028,
      10.411766,
      2.396379,
      NULL,
      1.962284,
      1,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.820757,
      0.250913,
      3,
      8,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      2,
      0.985075,
      0.376386,
      0,
      1,
      0.532311,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.348737,
      NULL,
      NULL,
      1,
      1.789976,
      0.256401,
      NULL,
      1.475696,
      3,
      0.363886,
      NULL,
      NULL,
      0.488128,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.278608,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.203820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.646890,
      NULL,
      NULL,
      NULL,
      3.785499,
      NULL,
      NULL,
      NULL,
      3.495407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779183,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.264569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      4,
      8,
      4,
      1,
      42.904228,
      102,
      NULL,
      17,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.002290,
      1.941512,
      12.437769,
      18.242350,
      0,
      NULL,
      NULL,
      0.219185,
      NULL,
      0.353193,
      750,
      39.531551,
      1,
      1.179851,
      0.429241,
      1,
      0,
      1.259755,
      0.747331,
      1.197972,
      1.319579,
      1,
      1.563460,
      1.948639,
      NULL,
      1,
      NULL,
      1,
      0.548252,
      0.833900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.936809,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643649,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.229347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.357212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692472,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921351,
      3.716998,
      NULL,
      0.716838,
      NULL,
      1.070869,
      NULL,
      4.367656,
      NULL,
      NULL,
      NULL,
      0.059061,
      2.502455,
      NULL,
      1,
      NULL,
      783.968064,
      NULL,
      2.657773,
      NULL,
      NULL,
      NULL,
      0.528320,
      NULL,
      2.203988,
      NULL,
      20,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.547457,
      4.963048,
      7,
      3.026122,
      2,
      5,
      0.699356,
      16.748328,
      0.965778,
      2.265814,
      1.885312,
      NULL,
      0.948866,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.194765,
      NULL,
      1.739899,
      0,
      NULL,
      NULL,
      1.001902,
      NULL,
      NULL,
      0,
      NULL,
      0.979565,
      1,
      NULL,
      2.576811,
      3.304675,
      NULL,
      1,
      1,
      NULL,
      3.402737,
      NULL,
      NULL,
      0,
      0.416289,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014071,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.501727,
      NULL,
      0.688319,
      0.648068,
      3,
      40.491430,
      54.066322,
      3,
      1.853006,
      NULL,
      '32201',
      '00442',
      NULL,
      1.139573,
      '02103',
      NULL,
      '',
      4.356857,
      '0423',
      NULL,
      '');
commit;
end;
/


