set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2,
      NULL,
      5,
      NULL,
      3.306176,
      2,
      NULL,
      '343',
      '24303323',
      NULL,
      34.333630,
      '4034411',
      2.298300,
      NULL,
      2,
      2,
      '4214',
      NULL,
      1.123602,
      NULL,
      NULL,
      '10-22-2002',
      24.850114,
      7.129856,
      NULL,
      NULL,
      0,
      ' 6-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1989',
      ' 0-10-1994',
      ' 6-18-1995',
      NULL,
      2.419046,
      NULL,
      0.067522,
      1,
      1,
      3.972719,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.869033,
      NULL,
      1.175639,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.791791,
      0,
      5.968257,
      0.837098,
      5,
      5.956822,
      5,
      3,
      1.303921,
      NULL,
      1,
      NULL,
      0.171755,
      1.122833,
      7.915922,
      0.331152,
      1.967664,
      1,
      NULL,
      0.890601,
      4,
      1,
      3.798433,
      3,
      0,
      1.846451,
      1.711416,
      1.846627,
      1.382005,
      NULL,
      NULL,
      2.761635,
      0,
      NULL,
      2.688063,
      1.988349,
      1,
      2,
      NULL,
      2.586253,
      0.277043,
      0,
      NULL,
      1.764290,
      NULL,
      1.795138,
      1.742002,
      3.276104,
      1,
      1.811619,
      NULL,
      NULL,
      1.809287,
      2,
      0.874157,
      1.300384,
      0.260886,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.274188,
      1.839985,
      4,
      NULL,
      5,
      3,
      1.115095,
      1.956539,
      1,
      0.216068,
      4,
      0.242616,
      0.102751,
      2,
      1.095062,
      1.942523,
      0.274731,
      1.373262,
      1.153672,
      NULL,
      1,
      1,
      3.021966,
      NULL,
      1.436386,
      1.182642,
      3.289377,
      3,
      NULL,
      0.363751,
      NULL,
      1.936666,
      1,
      5.412410,
      1,
      1.041469,
      NULL,
      3.772693,
      NULL,
      4.711988,
      NULL,
      0,
      4.030156,
      2.032978,
      NULL,
      NULL,
      NULL,
      3.358887,
      '11-27-1999',
      13.725487,
      ' 0-29-1980',
      25,
      0.242749,
      NULL,
      3.427391,
      3.528180,
      4,
      NULL,
      2.281096,
      1,
      2,
      0.200018,
      1,
      4,
      4.950693,
      5.650813,
      NULL,
      6.695294,
      0.014434,
      2.204084,
      1,
      10,
      NULL,
      ' 6- 0-1975',
      7,
      ' 1-15-1988',
      1.992467,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.521582,
      NULL,
      0.523796,
      NULL,
      1.511439,
      NULL,
      1.539094,
      1,
      4,
      0.036507,
      1.033488,
      3.953778,
      2.941989,
      3.627853,
      1,
      0.949951,
      0,
      NULL,
      0.533693,
      3.088679,
      9.799682,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544373,
      5.504246,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.489414,
      1,
      0,
      1.407547,
      1,
      NULL,
      0.306079,
      1.583965,
      6.692453,
      0,
      1.046994,
      NULL,
      NULL,
      NULL,
      0,
      0.452198,
      0.689582,
      4,
      3,
      4,
      2.566963,
      3.408079,
      0,
      1.904795,
      3,
      3.035612,
      2,
      0.628807,
      3,
      2.779196,
      0,
      NULL,
      NULL,
      2.047138,
      0.821434,
      1.273292,
      0,
      1,
      1.396832,
      NULL,
      0.357538,
      0.409038,
      NULL,
      2.035648,
      0.706793,
      0.676414,
      NULL,
      5,
      NULL,
      5.919849,
      3,
      2.095866,
      NULL,
      2,
      4,
      3,
      3.282741,
      2.483175,
      63,
      2,
      3,
      53,
      NULL,
      66,
      26,
      NULL,
      NULL,
      2,
      '22033',
      '04031',
      NULL,
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678653,
      0.322591,
      0.430061,
      0.896388,
      NULL,
      NULL,
      1.331866,
      NULL,
      NULL,
      2.573668,
      NULL,
      0,
      1.049795,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      143,
      0,
      1.670441,
      3,
      0.767758,
      3,
      NULL,
      0,
      0,
      2,
      NULL,
      3,
      0.160127,
      1,
      0,
      NULL,
      0.290743,
      0,
      1.440569,
      3.772875,
      NULL,
      0.131512,
      NULL,
      1,
      NULL,
      0.031280,
      NULL,
      1.144226,
      NULL,
      0,
      NULL,
      21.175128,
      NULL,
      2.180554,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.840916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.285717,
      NULL,
      0.432236,
      NULL,
      1.151089,
      NULL,
      1.215090,
      NULL,
      1.596630,
      NULL,
      NULL,
      2.805697,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.479619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.887099,
      0,
      NULL,
      1.583794,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876068,
      NULL,
      0.524700,
      0.733019,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.588496,
      NULL,
      0.780750,
      1,
      1.365352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445940,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.440654,
      NULL,
      1.747183,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.170278,
      NULL,
      1,
      NULL,
      1.758726,
      0,
      5.336231,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.734023,
      0,
      0,
      1.818771,
      NULL,
      1.447408,
      0.740105,
      1.285153,
      0.503193,
      1.928363,
      3,
      0,
      0.390533,
      1.595431,
      NULL,
      0.615767,
      0.577586,
      NULL,
      1.134501,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.889194,
      NULL,
      0,
      0.189344,
      NULL,
      0.498046,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.546566,
      0,
      NULL,
      0.697866,
      0,
      NULL,
      1.211824,
      1.676756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168452,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.291218,
      NULL,
      1.706476,
      NULL,
      NULL,
      116,
      38,
      2.525233,
      NULL,
      7,
      '14204',
      NULL,
      '44232',
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


