set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      NULL,
      18,
      NULL,
      '2122020',
      0,
      0,
      NULL,
      2,
      '0320',
      4,
      0.460390,
      NULL,
      NULL,
      NULL,
      26,
      45,
      NULL,
      2,
      1.078702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065121,
      ' 9-19-1988',
      ' 1-24-1997',
      ' 0-29-1997',
      NULL,
      0,
      3.710138,
      2,
      1,
      1,
      2.223422,
      0,
      NULL,
      NULL,
      NULL,
      6.634454,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.194980,
      NULL,
      0,
      3.389662,
      0.437751,
      1.059335,
      0.043837,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1,
      NULL,
      3,
      2,
      4,
      1.186815,
      0.983243,
      NULL,
      NULL,
      NULL,
      4.229018,
      0,
      1,
      1.418560,
      1,
      1.811769,
      6.189187,
      0.134908,
      NULL,
      1.641552,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454371,
      3,
      2,
      0,
      0,
      NULL,
      0.044088,
      NULL,
      0.450018,
      2,
      1,
      NULL,
      1.628296,
      0,
      1.021688,
      1,
      1.055918,
      0.525506,
      2,
      1.365947,
      5,
      9,
      0.394415,
      5,
      3.264627,
      1.704413,
      NULL,
      NULL,
      1.990757,
      NULL,
      NULL,
      1,
      1,
      5,
      1.139688,
      2,
      5.509353,
      NULL,
      NULL,
      3,
      1,
      0,
      2,
      1.741708,
      0,
      0,
      0.162551,
      0.050977,
      1.558030,
      1.501305,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.433263,
      0.453701,
      1.728628,
      1,
      5.703207,
      0.212267,
      0.833247,
      NULL,
      0.607896,
      1,
      2,
      4,
      NULL,
      0.895769,
      NULL,
      NULL,
      5.566123,
      3.865988,
      NULL,
      NULL,
      NULL,
      NULL,
      3.783732,
      ' 0- 9-1974',
      3.459406,
      ' 7-17-2001',
      10,
      3,
      0.797901,
      1.960780,
      3.064256,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.939229,
      0,
      1,
      1,
      1.531830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      8.251266,
      1,
      2.123946,
      0.189661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.578090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190563,
      3.393296,
      3,
      1.675491,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401807,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868842,
      NULL,
      0.672086,
      1.278048,
      1.286234,
      1,
      0.847111,
      3.303617,
      28,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.946885,
      0,
      NULL,
      3,
      1.367415,
      1.937267,
      NULL,
      0.612040,
      NULL,
      3.762780,
      3.216109,
      2,
      0,
      0.149547,
      1.266104,
      1,
      1,
      5,
      NULL,
      0,
      0.406400,
      1,
      0,
      1,
      1,
      0,
      0.113991,
      3,
      0,
      0,
      NULL,
      6.139098,
      4.423602,
      2.573843,
      4.412181,
      NULL,
      1,
      1,
      NULL,
      0,
      1.134991,
      NULL,
      50.236094,
      NULL,
      NULL,
      23,
      NULL,
      71,
      NULL,
      5.481824,
      3,
      3.604353,
      NULL,
      '43100',
      '',
      1.479945,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      34,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818998,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.287513,
      NULL,
      NULL,
      0.351922,
      NULL,
      1,
      50.867053,
      4,
      0.147677,
      0,
      NULL,
      1.988859,
      1,
      1.260247,
      0.613448,
      0.060903,
      0,
      1.351820,
      0,
      0.431785,
      NULL,
      1,
      0,
      1.413665,
      0.921837,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.892565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.759071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942940,
      0.858292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913900,
      0.957437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917819,
      NULL,
      3,
      NULL,
      0.200176,
      NULL,
      0,
      NULL,
      144.249295,
      NULL,
      1.096883,
      NULL,
      1.552638,
      NULL,
      1,
      NULL,
      0.010075,
      3,
      32,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.697301,
      NULL,
      2.658829,
      6.961839,
      4,
      3.446256,
      2.065138,
      2.970837,
      NULL,
      2.714511,
      1.722772,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.842616,
      NULL,
      0,
      1.327928,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.271377,
      NULL,
      0.762945,
      1,
      NULL,
      2.058042,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2.666989,
      1.844167,
      1.765667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362867,
      NULL,
      0,
      NULL,
      1,
      0,
      8,
      1,
      NULL,
      NULL,
      20.125144,
      87,
      3.499522,
      4.621712,
      1,
      '22023',
      '44022',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


