set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7428476';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1982-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '0223242',
      0,
      0,
      2,
      NULL,
      '3010',
      0,
      1,
      NULL,
      NULL,
      ' 5-11-1977',
      NULL,
      NULL,
      1.132551,
      NULL,
      16.439868,
      ' 5-28-1993',
      9.693376,
      0.109325,
      219,
      683.395057,
      NULL,
      NULL,
      ' 0-18-2001',
      ' 8- 2-1985',
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.736635,
      1.728565,
      NULL,
      NULL,
      NULL,
      NULL,
      11.576694,
      3.841499,
      79.260609,
      117,
      1.392850,
      17,
      5,
      1,
      2,
      0.604330,
      1.265177,
      1.422336,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      2.706127,
      NULL,
      1.365337,
      NULL,
      NULL,
      1,
      1.229379,
      2,
      0,
      NULL,
      1.103086,
      0.256467,
      NULL,
      3.462623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.146176,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.342902,
      NULL,
      0.560244,
      4,
      0,
      1.772236,
      0.487352,
      0,
      6,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1.383778,
      1.566932,
      0.822247,
      NULL,
      0,
      1.417830,
      1,
      NULL,
      0,
      0,
      2.636522,
      0,
      1.040291,
      NULL,
      1.529776,
      NULL,
      NULL,
      5,
      1,
      2,
      0,
      1,
      5,
      1,
      0.492114,
      6,
      1,
      2.941858,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765522,
      0,
      1.586395,
      NULL,
      0,
      1,
      0,
      1.612678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283695,
      0,
      1.601026,
      0.838297,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.681631,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.851358,
      NULL,
      NULL,
      0.289757,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542693,
      1.716488,
      0,
      3,
      3,
      2,
      3,
      3,
      2.752426,
      2,
      1,
      0.774206,
      3,
      3.809435,
      0,
      NULL,
      0.603060,
      NULL,
      1.502459,
      NULL,
      2,
      0,
      0.930405,
      0.751861,
      0.520106,
      1.827498,
      1.908636,
      1,
      NULL,
      6,
      5.525816,
      1,
      0,
      1.329178,
      6,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.606939,
      3.890690,
      NULL,
      NULL,
      47.213908,
      NULL,
      NULL,
      5,
      0,
      1.916353,
      '',
      NULL,
      '',
      3,
      '23100',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.129435,
      13.634188,
      63,
      0,
      2.012835,
      5.247176,
      NULL,
      NULL,
      3.035606,
      0.978816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.844517,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.869138,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.467464,
      NULL,
      NULL,
      0.902294,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.918004,
      NULL,
      NULL,
      1.479960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.735870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550102,
      NULL,
      NULL,
      0.906771,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916724,
      3.245203,
      1,
      0,
      1,
      1.046259,
      1,
      NULL,
      NULL,
      0.874707,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.119683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.793536,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.376651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.639985,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.892475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.457760,
      NULL,
      NULL,
      1.988899,
      NULL,
      NULL,
      1.030068,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.766588,
      1,
      0.580147,
      7,
      8.698252,
      5.654633,
      6.798392,
      1,
      3,
      1.605442,
      NULL,
      NULL,
      1.832191,
      1,
      1.401626,
      0,
      1.060311,
      0.752122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.296316,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724008,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      15744.134334,
      209,
      NULL,
      0.444016,
      1.140644,
      NULL,
      1.387355,
      1,
      0,
      0.428625,
      1,
      1.845142,
      1.188077,
      0.045936,
      0.502943,
      0.366226,
      0,
      NULL,
      0.775322,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      5.146709,
      NULL,
      3,
      7,
      9,
      NULL,
      1,
      0.958947,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.715324,
      NULL,
      NULL,
      0.841242,
      NULL,
      NULL,
      1.278627,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.743610,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.283879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.318470,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.036142,
      2,
      NULL,
      2,
      0.657657,
      NULL,
      68,
      102,
      2,
      0,
      1,
      '',
      '',
      '',
      0,
      '30130',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


