set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3112021',
      0.848652,
      NULL,
      4,
      NULL,
      NULL,
      1.839598,
      NULL,
      NULL,
      NULL,
      ' 2-11-1982',
      24.685868,
      NULL,
      2,
      3.563528,
      12.797070,
      ' 9- 1-1998',
      NULL,
      NULL,
      277,
      NULL,
      0,
      ' 8-27-1996',
      ' 5-13-2001',
      ' 0-20-1993',
      NULL,
      1,
      NULL,
      1,
      1.431556,
      3.911685,
      3,
      0.580708,
      NULL,
      NULL,
      NULL,
      6.699843,
      4,
      NULL,
      NULL,
      4.695916,
      25,
      0.173372,
      1.394062,
      2.610400,
      0.988725,
      NULL,
      NULL,
      NULL,
      1.997658,
      0,
      1,
      1,
      1,
      1,
      1,
      3.459867,
      1.507534,
      1,
      3.434579,
      NULL,
      0.845781,
      2.190083,
      NULL,
      9,
      1.926257,
      9.343219,
      3,
      NULL,
      0.513652,
      NULL,
      2.520047,
      0,
      0,
      1.397851,
      NULL,
      NULL,
      0.868016,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.212330,
      0.227097,
      NULL,
      0.406393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754008,
      NULL,
      1.101251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.099094,
      3.664115,
      NULL,
      7.549002,
      NULL,
      3,
      1,
      0,
      1.285635,
      0,
      NULL,
      0.817458,
      1,
      1.023111,
      NULL,
      1.626050,
      NULL,
      0.674220,
      NULL,
      1.183772,
      3.033213,
      0.431280,
      1.424846,
      4.591933,
      3.891285,
      5.739870,
      5.484264,
      1.303791,
      1,
      2.710432,
      0,
      3,
      1.155474,
      1.063817,
      0.775500,
      NULL,
      1,
      4,
      5.711857,
      0.309658,
      0.668098,
      2.252656,
      NULL,
      3,
      1,
      NULL,
      3,
      ' 6-26-1991',
      17,
      ' 0- 0-1985',
      3,
      0,
      0,
      0.776008,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.174942,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.671480,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.828122,
      0,
      3,
      NULL,
      3.506456,
      7.888773,
      1,
      3,
      4,
      NULL,
      NULL,
      0.828365,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.894056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.673697,
      NULL,
      2,
      20,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.539582,
      1,
      2,
      2.444426,
      1.926138,
      0.221996,
      2.257269,
      3.716072,
      2,
      1.756686,
      NULL,
      2.797411,
      2.447320,
      3,
      NULL,
      1,
      1.722132,
      1.361466,
      NULL,
      4,
      1.599585,
      NULL,
      1,
      0,
      1.830639,
      1.458282,
      0,
      NULL,
      2,
      3.705990,
      3.864911,
      0,
      7,
      2,
      4.086600,
      10.748372,
      6,
      1.803779,
      5.786512,
      2.180956,
      2,
      3,
      2,
      2.136144,
      10.893222,
      2,
      1,
      NULL,
      57.251177,
      7.353723,
      48,
      4,
      NULL,
      0.955175,
      '20123',
      '',
      '',
      1.618095,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3.475805,
      17.814990,
      12,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.166406,
      1,
      1,
      1.370064,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      0.864894,
      1,
      3.659570,
      1,
      1,
      NULL,
      NULL,
      0.533293,
      2.098569,
      0,
      3,
      1,
      1.932733,
      NULL,
      NULL,
      NULL,
      2,
      2.244612,
      0,
      1.132427,
      3.033963,
      1,
      0,
      1.151666,
      1,
      0,
      NULL,
      0,
      0,
      1.734652,
      NULL,
      NULL,
      NULL,
      0.584703,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.009301,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.568726,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.068717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      1.746624,
      NULL,
      NULL,
      NULL,
      4.630111,
      0,
      NULL,
      0,
      1.502315,
      NULL,
      1.373469,
      1.145375,
      1,
      1.359261,
      1.578212,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.610006,
      NULL,
      NULL,
      0.455916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.908206,
      0,
      NULL,
      0.233953,
      NULL,
      NULL,
      4.702500,
      4,
      1,
      NULL,
      3,
      NULL,
      0.501648,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      3,
      0.671633,
      3,
      NULL,
      0,
      NULL,
      4.209692,
      1.609892,
      NULL,
      2,
      0,
      0.086929,
      1.900679,
      NULL,
      1.712675,
      0.657765,
      1,
      0.601516,
      0.668484,
      1,
      5.114142,
      1,
      1,
      7,
      5.132934,
      0,
      NULL,
      NULL,
      2,
      0,
      1.380523,
      NULL,
      1.240806,
      1.966623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.402351,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.294385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753671,
      NULL,
      NULL,
      0.358501,
      NULL,
      NULL,
      1,
      1.131457,
      NULL,
      0.618740,
      1,
      1.957090,
      3.821228,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.887314,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.058502,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.265081,
      NULL,
      NULL,
      0.758172,
      NULL,
      NULL,
      NULL,
      1.987848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.779098,
      1.939169,
      NULL,
      NULL,
      2,
      0.026021,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.318286,
      NULL,
      NULL,
      NULL,
      1.683093,
      7,
      2.449560,
      0,
      11,
      0.044498,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897293,
      NULL,
      NULL,
      0,
      NULL,
      0,
      292.434141,
      NULL,
      0,
      NULL,
      NULL,
      1.867350,
      0.498707,
      0,
      1,
      0.589098,
      0,
      1,
      1,
      NULL,
      0,
      1.277506,
      0,
      1.175939,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.991125,
      1,
      3.708303,
      2,
      2.852104,
      2,
      1.729987,
      3,
      1,
      1.271167,
      0,
      2.858515,
      1,
      NULL,
      0,
      1.020797,
      2.625963,
      0,
      1,
      0,
      0.273518,
      0,
      1,
      1,
      0.477458,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.346666,
      2,
      NULL,
      NULL,
      0,
      0,
      1.928859,
      NULL,
      1.215573,
      0,
      1,
      NULL,
      NULL,
      0.290133,
      NULL,
      1,
      2.594400,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.690654,
      1.284569,
      0.736496,
      0.394705,
      0.206114,
      0.452523,
      3,
      1,
      NULL,
      NULL,
      24,
      12,
      7.445841,
      0.900638,
      NULL,
      '41001',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.986595,
      '',
      '',
      '');
commit;
end;
/


