set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '1042012',
      NULL,
      0.631558,
      4,
      1,
      '4441',
      NULL,
      1,
      NULL,
      NULL,
      ' 4-18-1980',
      NULL,
      NULL,
      3.780356,
      NULL,
      NULL,
      '11-11-1995',
      28,
      0.482317,
      289,
      26,
      1.117992,
      ' 6-19-1996',
      ' 0-27-1988',
      ' 7- 7-1979',
      2.018430,
      NULL,
      2.984394,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      24,
      6.515874,
      NULL,
      2,
      1.828052,
      14.208470,
      2,
      NULL,
      0.841227,
      NULL,
      4,
      0.075227,
      0.392167,
      NULL,
      1,
      1.383674,
      NULL,
      1.473627,
      0,
      0,
      1.334083,
      0,
      NULL,
      1.404087,
      NULL,
      3.095640,
      6.919790,
      1,
      NULL,
      NULL,
      4.609826,
      NULL,
      5.077204,
      1,
      3,
      1.216835,
      1.612311,
      NULL,
      1,
      1.458158,
      2.720829,
      1.050258,
      NULL,
      0,
      NULL,
      NULL,
      1.294177,
      NULL,
      NULL,
      5.563924,
      2.507761,
      4.689190,
      2.457070,
      1.921379,
      1.586725,
      2.358904,
      2.299286,
      2,
      2,
      1.265582,
      NULL,
      2,
      NULL,
      0.566031,
      0.440021,
      1.492895,
      1,
      1,
      3,
      0.547935,
      0.517221,
      1.240974,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.776494,
      NULL,
      NULL,
      1.616075,
      0.949362,
      0,
      0,
      1.305391,
      5,
      8.858350,
      1.793754,
      1,
      8.022516,
      4.166698,
      2.609268,
      NULL,
      3,
      0.116679,
      1,
      1.053511,
      1.494970,
      1.070006,
      NULL,
      1,
      2.161134,
      4.768999,
      0,
      0.880179,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      2.157559,
      0,
      0,
      2,
      7,
      5.582379,
      8,
      4.092824,
      NULL,
      9,
      7.454953,
      7.255748,
      4,
      1.466803,
      0.068632,
      1.804536,
      ' 0-21-1986',
      166,
      ' 8- 5-1984',
      NULL,
      NULL,
      1.020143,
      1,
      NULL,
      3.948802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580297,
      4,
      7.439960,
      0.958341,
      NULL,
      0,
      0.441176,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.906383,
      0,
      3.481365,
      2,
      NULL,
      4,
      3.565289,
      0,
      NULL,
      NULL,
      NULL,
      3.374058,
      1,
      4.981523,
      2.233043,
      1.414799,
      3.692095,
      0.857717,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329806,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.694667,
      40.865412,
      1.671604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.034347,
      3.045944,
      3,
      1,
      1,
      1.907832,
      NULL,
      1.226579,
      1.569598,
      1,
      3,
      0,
      3,
      0.620652,
      5.517976,
      1,
      1,
      1,
      0.570057,
      0.771337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.589785,
      0.077642,
      0.731737,
      NULL,
      NULL,
      6.771735,
      0.422590,
      4,
      6.855414,
      1,
      4.517818,
      2.726563,
      6,
      0,
      1,
      NULL,
      51,
      2,
      1,
      NULL,
      51.080680,
      61,
      16,
      NULL,
      2,
      NULL,
      '41203',
      '',
      NULL,
      0.333110,
      '',
      '',
      '',
      1.264782,
      '',
      '',
      '',
      NULL,
      35,
      51.557130,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.169920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.346926,
      NULL,
      NULL,
      0.986698,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996041,
      NULL,
      NULL,
      1.823343,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080006,
      NULL,
      NULL,
      2.061712,
      NULL,
      NULL,
      1.871903,
      NULL,
      NULL,
      0.892905,
      NULL,
      NULL,
      3.575187,
      3.435346,
      0,
      1.144398,
      NULL,
      NULL,
      0.536599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      3.520084,
      5.821989,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.094974,
      1,
      NULL,
      1.485015,
      3,
      0.447795,
      NULL,
      2.639030,
      0.141937,
      4,
      NULL,
      NULL,
      2,
      1.286873,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325196,
      3.617718,
      1,
      0.675415,
      1.322552,
      3.343165,
      6.981134,
      NULL,
      7.678925,
      0,
      5.476361,
      1.845402,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0.657493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.689256,
      3.978988,
      1,
      1.013580,
      1,
      0.471000,
      5.515897,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      1.080495,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.772933,
      NULL,
      NULL,
      NULL,
      3.576105,
      NULL,
      NULL,
      NULL,
      1.756444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819136,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.420750,
      NULL,
      NULL,
      NULL,
      1.205773,
      NULL,
      NULL,
      NULL,
      0.835075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.521913,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.317329,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.316125,
      NULL,
      0.601371,
      0,
      1.681461,
      NULL,
      NULL,
      1.451571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452887,
      NULL,
      NULL,
      1,
      NULL,
      0.277834,
      155.993892,
      1,
      0,
      1.172142,
      0,
      NULL,
      1,
      NULL,
      0.182421,
      0,
      NULL,
      0,
      1.294877,
      1.120168,
      1.539659,
      0.076474,
      1,
      1,
      NULL,
      3.514130,
      NULL,
      NULL,
      NULL,
      0.113030,
      NULL,
      3,
      NULL,
      1.057285,
      NULL,
      0.639982,
      NULL,
      115,
      NULL,
      1,
      8.918355,
      8.330929,
      3.189361,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.888764,
      NULL,
      1,
      2.303747,
      1.010488,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000720,
      0.534726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.706250,
      3,
      NULL,
      0,
      NULL,
      1.357690,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.154618,
      NULL,
      0.936641,
      0.706321,
      3.723414,
      NULL,
      0.892212,
      NULL,
      1.194181,
      NULL,
      NULL,
      NULL,
      0.518269,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.764381,
      1.145706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.481864,
      NULL,
      0.340091,
      NULL,
      2.885257,
      NULL,
      182.563720,
      NULL,
      NULL,
      NULL,
      0.967296,
      NULL,
      NULL,
      1.162229,
      0.043779,
      8.982051,
      22,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.663487,
      1.908567,
      1.189331,
      1.523763,
      0,
      NULL,
      2.232371,
      NULL,
      3,
      NULL,
      2.442715,
      0.091365,
      NULL,
      3,
      NULL,
      1.888712,
      0,
      NULL,
      0.591107,
      3,
      NULL,
      1.927237,
      1.896380,
      2.231419,
      1,
      2,
      1,
      1,
      3,
      1,
      NULL,
      2,
      0,
      0,
      2.425074,
      1,
      0,
      2.338687,
      0,
      1,
      1.597720,
      0.183881,
      2,
      1.758013,
      3,
      3,
      0.088731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.767221,
      0,
      7,
      0.085156,
      0.608803,
      NULL,
      NULL,
      NULL,
      31.529588,
      33.523406,
      2.297677,
      5.703755,
      2.965542,
      '13334',
      '32030',
      '20120',
      0.780169,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


