set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '0420322',
      2.298293,
      0,
      1,
      NULL,
      '0101',
      0.252278,
      0,
      NULL,
      NULL,
      ' 6-12-1982',
      139.827983,
      NULL,
      NULL,
      1,
      2,
      '11-23-2001',
      59,
      3.896971,
      NULL,
      117,
      2,
      ' 2-10-1994',
      ' 5-21-1980',
      NULL,
      0.597979,
      0,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      0.500570,
      17.857193,
      3,
      NULL,
      3,
      19.960339,
      20.520981,
      1.191838,
      6,
      NULL,
      NULL,
      6,
      1,
      0.543072,
      0,
      0,
      0,
      1.477445,
      NULL,
      0,
      1,
      0.768292,
      0,
      NULL,
      4.482971,
      2,
      NULL,
      NULL,
      0.743025,
      1,
      5,
      5,
      0.763599,
      7,
      1.937058,
      0,
      3.208334,
      2.066039,
      3.761383,
      7,
      0.745305,
      5,
      0.489816,
      1.829482,
      1,
      NULL,
      NULL,
      0.001398,
      NULL,
      NULL,
      9,
      6.203014,
      9,
      3.203915,
      0.162722,
      NULL,
      2,
      0.415728,
      0,
      1.110180,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      1,
      1,
      3.805939,
      0.310231,
      1.631751,
      0,
      NULL,
      0.961331,
      0,
      0,
      0.346890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959204,
      2.604741,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      1.365763,
      3,
      5.184929,
      0.592693,
      NULL,
      1.278026,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.057432,
      1,
      1,
      0,
      0,
      1.335809,
      0,
      1,
      0.803156,
      NULL,
      3,
      NULL,
      0,
      0,
      4,
      9.436691,
      2,
      4.710227,
      7.777597,
      0.432807,
      5,
      4.226354,
      NULL,
      6,
      3.491422,
      1,
      7,
      1.743493,
      ' 8-17-1977',
      1037.539451,
      ' 0- 9-1982',
      2,
      1.053655,
      0,
      1.361764,
      3.345433,
      1.294377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670614,
      1.087542,
      0.790401,
      0.568404,
      1,
      1.221554,
      1,
      4,
      NULL,
      0.712093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.934612,
      2,
      0.107626,
      NULL,
      5,
      1.586011,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.405295,
      0.525573,
      1,
      NULL,
      NULL,
      1,
      47,
      3.049990,
      0.749544,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      3,
      NULL,
      1.687380,
      2.422826,
      NULL,
      NULL,
      2.968057,
      2,
      NULL,
      0.501344,
      2.369303,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.732815,
      1,
      NULL,
      0,
      1.799850,
      0,
      1,
      0,
      0.706681,
      1.445294,
      NULL,
      1.299984,
      1.484825,
      3.619481,
      2.112947,
      7.603246,
      9,
      4.554612,
      2.475911,
      1,
      2.099875,
      0.420833,
      2.492553,
      NULL,
      1.248595,
      24,
      NULL,
      1.052349,
      NULL,
      53,
      12.693107,
      NULL,
      0,
      0.947013,
      6,
      NULL,
      '22203',
      '10403',
      0.758986,
      '',
      '',
      '',
      1.936042,
      '',
      '',
      '',
      3.434355,
      12,
      81,
      9,
      0.150877,
      49,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.058224,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.065917,
      0.135070,
      0.565732,
      NULL,
      NULL,
      0.389806,
      NULL,
      NULL,
      2.245757,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.482549,
      0.128870,
      3,
      NULL,
      0.855979,
      NULL,
      NULL,
      NULL,
      1.813982,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.787932,
      1.814329,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      1.372398,
      0.664742,
      NULL,
      1.380681,
      NULL,
      1,
      NULL,
      0,
      2.517637,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1.551228,
      NULL,
      NULL,
      1.992703,
      NULL,
      NULL,
      5.401334,
      0.342269,
      0.255177,
      0.212807,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.832150,
      1.947232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511216,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.186751,
      0,
      1.478741,
      NULL,
      0.882863,
      1.032133,
      1,
      1,
      0.803812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914179,
      NULL,
      NULL,
      1.571385,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.218015,
      1.999316,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2.263527,
      0.268421,
      NULL,
      NULL,
      0.473864,
      2.941478,
      3.366642,
      3.786309,
      NULL,
      NULL,
      3,
      1,
      0,
      2,
      1.039524,
      NULL,
      0.208895,
      0.408421,
      1.351095,
      0,
      1,
      5.825838,
      4.037800,
      0,
      5,
      1.217975,
      5.064538,
      2.869536,
      NULL,
      1.680377,
      1.043853,
      1.627926,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.427185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.295024,
      NULL,
      NULL,
      1.571433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.584018,
      0.609749,
      3.827252,
      1,
      NULL,
      NULL,
      1.674406,
      0.045794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033867,
      1.377221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.111350,
      0.787464,
      NULL,
      NULL,
      NULL,
      1.486020,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0.589126,
      NULL,
      NULL,
      NULL,
      0.266219,
      NULL,
      NULL,
      3.879336,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.498082,
      1,
      NULL,
      NULL,
      1.632358,
      2,
      NULL,
      NULL,
      NULL,
      0.764330,
      NULL,
      NULL,
      0.239885,
      3.730354,
      NULL,
      NULL,
      NULL,
      0.411196,
      NULL,
      NULL,
      NULL,
      3.071761,
      NULL,
      NULL,
      1,
      0,
      1,
      3.384094,
      3.310117,
      9.967533,
      0.127284,
      1.618160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.742824,
      NULL,
      NULL,
      3.857405,
      7,
      2.600287,
      3,
      9.384148,
      1.831377,
      0.787641,
      NULL,
      0.428953,
      985,
      NULL,
      NULL,
      3,
      0.759757,
      3.011229,
      0.677533,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.785997,
      1,
      NULL,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.006016,
      NULL,
      1.067197,
      NULL,
      NULL,
      NULL,
      54.927608,
      NULL,
      5,
      16,
      18,
      1.259130,
      NULL,
      2.841113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095546,
      NULL,
      3.093704,
      NULL,
      0.894601,
      NULL,
      2.476646,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.835956,
      NULL,
      1,
      0,
      0,
      3.347357,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.220701,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.252858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.778737,
      NULL,
      0,
      NULL,
      1.629536,
      NULL,
      NULL,
      NULL,
      2.866363,
      NULL,
      1.294009,
      NULL,
      0.055529,
      NULL,
      1,
      1,
      0.667921,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.377230,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.205000,
      NULL,
      1.534903,
      NULL,
      1.526111,
      NULL,
      NULL,
      NULL,
      0.885750,
      NULL,
      3.563343,
      3.455161,
      3.053031,
      0,
      NULL,
      NULL,
      25,
      3.892486,
      0.058183,
      1,
      NULL,
      1,
      0.722772,
      0.946637,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.297350,
      2.550864,
      1,
      NULL,
      2,
      3,
      1,
      1,
      12,
      1,
      1,
      0.543060,
      NULL,
      2,
      1.784091,
      2.554644,
      1.865763,
      2.506439,
      NULL,
      0.309116,
      NULL,
      0,
      1.224252,
      0,
      1.256569,
      NULL,
      2,
      1,
      0,
      NULL,
      1.076110,
      0.034451,
      0.862285,
      1,
      0.715538,
      2.206811,
      0.990457,
      0.070397,
      NULL,
      0.073364,
      2,
      NULL,
      1,
      2,
      2.829456,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.600679,
      NULL,
      0,
      0.598056,
      1,
      76,
      4,
      4,
      NULL,
      NULL,
      '41224',
      '44124',
      '04431',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


