set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6916891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1043204',
      2.037981,
      0,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      ' 4- 8-1992',
      20,
      NULL,
      1.423691,
      NULL,
      0.871646,
      NULL,
      45.582352,
      1,
      138,
      NULL,
      1.518072,
      ' 4- 8-1974',
      ' 9-16-1994',
      ' 7-16-1974',
      1.731069,
      NULL,
      NULL,
      1,
      1.010886,
      1,
      3,
      1,
      1,
      167.138247,
      10,
      10,
      6.670044,
      NULL,
      NULL,
      NULL,
      7,
      5,
      NULL,
      0,
      1.145421,
      0,
      0,
      NULL,
      1.470783,
      0.044822,
      NULL,
      1.617201,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      1.868604,
      1.788390,
      1,
      5.297226,
      0,
      1.643790,
      NULL,
      5.917852,
      1,
      NULL,
      1,
      NULL,
      0.976074,
      8.664243,
      1,
      1.969108,
      1.645858,
      0.854364,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.676564,
      NULL,
      0.125300,
      0.099619,
      3,
      0.506965,
      1.481063,
      NULL,
      3,
      NULL,
      1.840121,
      0.024182,
      NULL,
      3.896453,
      3,
      3,
      1.424263,
      2.348499,
      1.349730,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      0.525837,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.577980,
      1.143728,
      0,
      1.189208,
      1,
      1,
      NULL,
      NULL,
      0.189305,
      1.538359,
      1.952382,
      1,
      1,
      0,
      1,
      NULL,
      0.425960,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.309397,
      1.437894,
      4.420256,
      NULL,
      0.315941,
      2,
      7.120109,
      4.841750,
      1.671257,
      7,
      1.782416,
      3,
      2,
      4,
      9.608508,
      3.928030,
      4,
      1,
      2,
      0,
      6.285166,
      NULL,
      6,
      3,
      ' 0- 4-1990',
      NULL,
      NULL,
      370.604713,
      2.931540,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181556,
      1,
      0.641767,
      0.912844,
      0,
      NULL,
      0.772183,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      350.380217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962477,
      2.650041,
      0,
      0.894510,
      NULL,
      1,
      0,
      0,
      NULL,
      5,
      7.220852,
      1.832574,
      NULL,
      NULL,
      NULL,
      1.355158,
      6.923394,
      2,
      3.552386,
      2.250548,
      NULL,
      2,
      NULL,
      1857,
      ' 2-10-1988',
      1997.138534,
      1,
      0.870998,
      1.543389,
      NULL,
      NULL,
      0.253285,
      NULL,
      3.660344,
      1.149977,
      0.533146,
      0,
      330,
      1.906218,
      1.575050,
      NULL,
      NULL,
      NULL,
      0,
      1.921349,
      NULL,
      NULL,
      1,
      1,
      1,
      1.313556,
      3,
      3.727243,
      2.145725,
      2,
      2,
      NULL,
      NULL,
      0.969763,
      0.994222,
      1.056868,
      NULL,
      9.850633,
      NULL,
      NULL,
      NULL,
      0,
      0.350604,
      3,
      0.802572,
      NULL,
      1,
      NULL,
      NULL,
      0.605662,
      NULL,
      1,
      3.691858,
      7,
      1.010273,
      3,
      5.630797,
      1.581861,
      6,
      0.410522,
      NULL,
      NULL,
      28,
      0,
      1.003948,
      NULL,
      25.662511,
      38,
      51,
      5.058200,
      1.686960,
      NULL,
      '30220',
      '',
      '',
      1.326778,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      448.836924,
      34,
      0,
      30,
      20.676931,
      54,
      1,
      3.366014,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.426722,
      NULL,
      3,
      NULL,
      0.992774,
      NULL,
      NULL,
      NULL,
      NULL,
      3.336582,
      NULL,
      NULL,
      NULL,
      0.716766,
      NULL,
      NULL,
      0.396615,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      7,
      1,
      3.866523,
      0,
      0.864089,
      0,
      0.853390,
      1,
      0,
      0.691445,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368026,
      NULL,
      NULL,
      NULL,
      1.255794,
      1,
      0,
      1,
      1.738198,
      NULL,
      0,
      1,
      2.257215,
      NULL,
      NULL,
      NULL,
      3.705327,
      NULL,
      0.004415,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      9.583783,
      4,
      2.098966,
      1.435742,
      0,
      0.541951,
      1.961790,
      NULL,
      NULL,
      1,
      NULL,
      0.763223,
      0.229740,
      NULL,
      NULL,
      0.604234,
      0,
      NULL,
      0,
      0.499186,
      1,
      0.524376,
      NULL,
      NULL,
      0.436279,
      0,
      0,
      0,
      NULL,
      NULL,
      1.239827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.167549,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.753040,
      NULL,
      NULL,
      1.216061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914869,
      NULL,
      NULL,
      1,
      0.705727,
      0,
      1.128432,
      NULL,
      NULL,
      NULL,
      3,
      2.998569,
      7.434028,
      NULL,
      0.963472,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.337133,
      1.983488,
      0,
      NULL,
      2,
      NULL,
      4,
      3,
      3.349738,
      1,
      0,
      NULL,
      NULL,
      3.220214,
      3,
      0.940086,
      0.083195,
      3.459631,
      1.859853,
      3.450563,
      NULL,
      5,
      5,
      2.376365,
      NULL,
      3.721536,
      1,
      1,
      1.616341,
      3,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.197980,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.298183,
      1.868184,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3.442444,
      1,
      NULL,
      0.010899,
      1,
      NULL,
      3.856604,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.600624,
      1.349899,
      2,
      0.161988,
      0,
      1.313766,
      0,
      0.773498,
      NULL,
      NULL,
      0.098293,
      NULL,
      NULL,
      NULL,
      263,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.731186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170156,
      NULL,
      NULL,
      NULL,
      1.672766,
      NULL,
      NULL,
      NULL,
      3.911964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509068,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.185925,
      NULL,
      NULL,
      NULL,
      2.690956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      64,
      33,
      NULL,
      43,
      17,
      0,
      NULL,
      NULL,
      2,
      3.540723,
      0,
      NULL,
      41.801743,
      8,
      1,
      35.949344,
      6,
      2,
      25,
      1.023369,
      239.755608,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1.353926,
      0.672697,
      NULL,
      0,
      1.238473,
      0,
      0,
      0,
      0.374037,
      NULL,
      1.553015,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.425551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.278641,
      1.496954,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1.268818,
      NULL,
      0,
      NULL,
      1.717085,
      NULL,
      NULL,
      1.701803,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.848234,
      NULL,
      NULL,
      NULL,
      NULL,
      1.862373,
      0.445456,
      NULL,
      NULL,
      1.224373,
      NULL,
      3.782193,
      1.503519,
      1.718689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141231,
      NULL,
      1,
      NULL,
      1.919822,
      NULL,
      0.427047,
      NULL,
      1,
      1,
      3,
      1,
      12.572813,
      24.721720,
      2,
      4,
      1,
      '22121',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.742053,
      NULL,
      '',
      '');
commit;
end;
/


