set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      '3220',
      NULL,
      0,
      NULL,
      NULL,
      ' 0- 1-1985',
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 4- 7-1989',
      12.789321,
      4,
      NULL,
      32.775628,
      2,
      NULL,
      NULL,
      ' 6- 5-1989',
      0,
      NULL,
      2.462454,
      0.015028,
      NULL,
      NULL,
      1,
      3.872532,
      NULL,
      NULL,
      NULL,
      1.252108,
      2.245164,
      38,
      11.760345,
      2,
      26.228671,
      0.840446,
      NULL,
      1.186908,
      0,
      1,
      0.818108,
      1.260029,
      0.158926,
      0,
      NULL,
      NULL,
      0,
      0.301823,
      NULL,
      5.188430,
      5,
      NULL,
      1,
      0.344170,
      0.561088,
      0.811563,
      1.074617,
      1,
      1.910116,
      1.511541,
      NULL,
      1.547580,
      NULL,
      0.759874,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.007626,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525212,
      0.986088,
      0.772314,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.027826,
      0,
      0,
      0.989120,
      1,
      0,
      1,
      1.932439,
      1,
      1,
      0.925615,
      NULL,
      1,
      0.086722,
      0.160475,
      0,
      NULL,
      1.463365,
      1.477910,
      NULL,
      NULL,
      1,
      1.279640,
      1.092502,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1.145462,
      0,
      0,
      0,
      1.006024,
      0,
      NULL,
      NULL,
      NULL,
      6.945500,
      4,
      3.567642,
      NULL,
      NULL,
      1.256118,
      1.082796,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.782363,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1.155717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999758,
      NULL,
      0.653711,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.981465,
      NULL,
      0.285700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048710,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1.640880,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.168316,
      3,
      1.549563,
      3.407815,
      0.365552,
      0.340788,
      1.352275,
      NULL,
      2,
      0.211513,
      3.131722,
      2,
      NULL,
      1.200656,
      NULL,
      0,
      1.463862,
      0,
      1.671078,
      0,
      0,
      0.439503,
      0.500641,
      1.916745,
      NULL,
      0,
      0.726482,
      0,
      0,
      1.879301,
      7.535464,
      7.367947,
      NULL,
      6.093654,
      0,
      0,
      0.831468,
      2.015534,
      5,
      NULL,
      NULL,
      0.470269,
      3.430266,
      1,
      1.285300,
      85,
      NULL,
      NULL,
      NULL,
      0.746965,
      3.808877,
      2,
      '43302',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      22.978316,
      46.730373,
      24,
      2.334644,
      NULL,
      9,
      0,
      0.991618,
      NULL,
      NULL,
      NULL,
      0.550152,
      NULL,
      NULL,
      0.931421,
      NULL,
      NULL,
      2,
      3,
      0,
      2,
      1.088170,
      1,
      0.375034,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.587525,
      1,
      1.472949,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.463099,
      8,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.800904,
      0,
      0,
      0,
      1.704916,
      0,
      11.103297,
      NULL,
      NULL,
      10.902378,
      NULL,
      NULL,
      3.449707,
      1,
      1,
      1.954559,
      0.443507,
      0.851754,
      NULL,
      0.631591,
      1,
      1.201774,
      NULL,
      NULL,
      0,
      0,
      0.693514,
      1,
      NULL,
      NULL,
      NULL,
      1.867404,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.885820,
      NULL,
      NULL,
      NULL,
      NULL,
      2.916067,
      NULL,
      3,
      1.855304,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.744264,
      NULL,
      NULL,
      0.229205,
      NULL,
      NULL,
      5.805662,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      1.524998,
      NULL,
      NULL,
      3.806288,
      1.162992,
      1.317082,
      3.316670,
      2.175338,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185299,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.281092,
      1,
      NULL,
      NULL,
      4,
      4.752502,
      3.392957,
      0,
      0,
      1.544920,
      2,
      0.036644,
      2.801304,
      NULL,
      NULL,
      0.992482,
      0.329168,
      2.823141,
      7,
      8,
      NULL,
      2,
      2,
      3,
      0,
      2.329045,
      NULL,
      0,
      0.170039,
      NULL,
      0.427812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.101806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.138592,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825809,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.979533,
      NULL,
      3.238742,
      1.068199,
      2.002675,
      1,
      1,
      NULL,
      NULL,
      5,
      4,
      NULL,
      5.376399,
      0.206903,
      2.770286,
      NULL,
      1,
      1.752120,
      NULL,
      NULL,
      0.579566,
      3.405521,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.950256,
      1.022420,
      NULL,
      NULL,
      3.777422,
      1.324666,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      0.628151,
      2.391111,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.055044,
      NULL,
      NULL,
      NULL,
      3,
      3.889735,
      1,
      NULL,
      1.664322,
      1.944695,
      NULL,
      NULL,
      2.375589,
      2,
      1.886799,
      NULL,
      3,
      2,
      0.575184,
      NULL,
      2,
      1,
      0,
      NULL,
      3.076213,
      3.835488,
      1,
      NULL,
      0.503314,
      1,
      1,
      NULL,
      5.820803,
      16,
      NULL,
      NULL,
      4,
      1.232166,
      NULL,
      NULL,
      NULL,
      1,
      33.955231,
      2.061029,
      2.953087,
      5,
      3.278209,
      1,
      NULL,
      NULL,
      0.985163,
      2.593755,
      1,
      1.168831,
      NULL,
      NULL,
      1.575668,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1.818997,
      0,
      1,
      NULL,
      0,
      0,
      1.778590,
      1,
      1,
      0.140771,
      0.415277,
      1,
      0,
      NULL,
      1,
      1.731625,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698902,
      NULL,
      0,
      1.070665,
      0,
      NULL,
      NULL,
      0.532172,
      2,
      2.712960,
      3,
      2.723678,
      0,
      1,
      1,
      1,
      NULL,
      2,
      0.927291,
      0.058198,
      2.244784,
      1.574600,
      1,
      0,
      2,
      2,
      NULL,
      0.885511,
      1,
      1,
      NULL,
      0,
      NULL,
      0.450114,
      0.880967,
      NULL,
      1.591745,
      0.336562,
      0,
      1.633121,
      1.940085,
      0.626932,
      1.465604,
      1,
      1.607839,
      2,
      3.966218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.325114,
      3,
      NULL,
      0.816636,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.229524,
      NULL,
      2.685744,
      NULL,
      2.555916,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.638913,
      NULL,
      3,
      26,
      3.935561,
      NULL,
      NULL,
      1,
      0,
      3.167147,
      0.598601,
      1,
      NULL,
      0.236883,
      5.805026,
      0.006771,
      NULL,
      NULL,
      74,
      4,
      1,
      5,
      2,
      '01111',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1.909364,
      '',
      NULL,
      '');
commit;
end;
/


