set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209180';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3044110',
      NULL,
      0,
      1,
      1,
      '0202',
      NULL,
      0,
      NULL,
      NULL,
      ' 8-19-2000',
      69.005765,
      NULL,
      NULL,
      1.705456,
      0.218028,
      NULL,
      42.026416,
      5,
      NULL,
      NULL,
      0.520718,
      '11-25-1994',
      NULL,
      ' 9-15-1994',
      0,
      0.674826,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      5,
      1.670889,
      16,
      5,
      25,
      17,
      3.709728,
      22.383325,
      2,
      0,
      NULL,
      0,
      1.555631,
      1.966888,
      0,
      0.605125,
      NULL,
      0,
      1,
      NULL,
      1.090111,
      0.028542,
      4,
      7,
      1.322660,
      NULL,
      9.835513,
      0.376706,
      6,
      NULL,
      3.596714,
      8,
      9,
      2.970645,
      1,
      4.692675,
      2.481592,
      2,
      2.377805,
      0,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      0.792862,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      2.800748,
      1,
      1,
      2.000446,
      1.287187,
      1,
      0,
      1.568774,
      0,
      NULL,
      NULL,
      1.317113,
      4.898961,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131617,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      4,
      0,
      1.955213,
      1,
      7,
      0,
      1.648393,
      1.618668,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.221462,
      0,
      2.176950,
      3,
      1.576002,
      1,
      1,
      0.438307,
      4,
      0.628985,
      NULL,
      0.406901,
      1,
      1,
      0.344894,
      4,
      0.874249,
      NULL,
      2,
      7,
      NULL,
      0,
      2,
      4.453175,
      0,
      '10- 3-1994',
      531.907670,
      ' 2- 3-1992',
      513,
      0.639861,
      0,
      1.215293,
      3.872212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.545019,
      1.191333,
      0.410142,
      1.323713,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      1.007327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.233520,
      0,
      0.815386,
      3,
      1.726225,
      5.026259,
      5,
      4,
      0,
      NULL,
      1.301891,
      0.513735,
      NULL,
      NULL,
      NULL,
      0,
      5.874205,
      1.663895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.558766,
      NULL,
      NULL,
      1,
      3,
      75.758190,
      1.239939,
      1.175722,
      NULL,
      NULL,
      NULL,
      4,
      0.754937,
      0,
      4,
      NULL,
      3.942714,
      NULL,
      1,
      1,
      NULL,
      2,
      0.970190,
      1.306690,
      NULL,
      NULL,
      2.712407,
      2.703983,
      1,
      1,
      1.640225,
      0,
      0,
      NULL,
      1,
      0.920443,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      4,
      NULL,
      1,
      3,
      0.877257,
      6.829947,
      5,
      1.813029,
      NULL,
      3.097753,
      0.547196,
      NULL,
      22.151986,
      2.220828,
      2.641739,
      NULL,
      49.263632,
      40,
      55.565947,
      NULL,
      0.524363,
      2.012977,
      '04422',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      25,
      18.474906,
      22.984592,
      0.705401,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.185095,
      3,
      1.350805,
      NULL,
      NULL,
      2.270154,
      NULL,
      2.325677,
      0,
      10,
      1,
      1.187468,
      NULL,
      NULL,
      2.003036,
      1,
      0.310834,
      1,
      0.249082,
      NULL,
      0.668348,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      0.244721,
      NULL,
      NULL,
      1.067346,
      NULL,
      NULL,
      10,
      7.848335,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.772353,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.210833,
      1.946845,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.884683,
      0,
      2.740242,
      0.395860,
      2,
      1,
      NULL,
      0.379181,
      1,
      0,
      1,
      1.881694,
      NULL,
      1.951154,
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      2,
      3.698911,
      1,
      2,
      4,
      5.822773,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.455917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.794819,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.138336,
      NULL,
      3,
      1,
      0.583894,
      3,
      2.244200,
      4,
      7.419788,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298412,
      NULL,
      NULL,
      0.021267,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.834617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2,
      4.656371,
      NULL,
      4.006107,
      5.457541,
      1,
      NULL,
      1.257454,
      NULL,
      NULL,
      1.095489,
      NULL,
      NULL,
      0.339998,
      NULL,
      NULL,
      0.443530,
      NULL,
      NULL,
      0,
      1.311776,
      0.848819,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.183191,
      NULL,
      1.885171,
      NULL,
      NULL,
      NULL,
      NULL,
      4.169393,
      1,
      0,
      2.264272,
      1,
      0.232632,
      3,
      1,
      4.789557,
      NULL,
      0,
      0.046855,
      1.275496,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.392878,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.671189,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.963043,
      NULL,
      NULL,
      0,
      0,
      0,
      0.229085,
      0.848933,
      3,
      0,
      NULL,
      NULL,
      6.564858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.231516,
      NULL,
      NULL,
      NULL,
      0.142385,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905984,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      2,
      3,
      19.750332,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.080752,
      0,
      NULL,
      NULL,
      0.639150,
      1.767351,
      1,
      0.011492,
      1,
      1.368996,
      1,
      NULL,
      0.974108,
      0.936322,
      0,
      1.431618,
      NULL,
      0.162800,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.949742,
      1.344746,
      6.009140,
      0,
      3,
      3,
      4,
      0,
      3,
      3.933220,
      1,
      1.467358,
      0.188074,
      NULL,
      NULL,
      1,
      NULL,
      1.635401,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.128506,
      0.804326,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.833579,
      NULL,
      1.543396,
      1,
      NULL,
      0.345209,
      0,
      NULL,
      1.929610,
      3.554640,
      0.351024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.165599,
      0,
      1.727469,
      1.836390,
      NULL,
      0,
      6.806496,
      NULL,
      3,
      2,
      NULL,
      42,
      69.331784,
      3.870273,
      0.084489,
      1,
      '43201',
      '',
      '',
      1.392380,
      NULL,
      '',
      '',
      0.142332,
      '',
      '',
      '');
commit;
end;
/


