set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2414113',
      2.495780,
      0,
      5,
      0,
      '4442',
      NULL,
      0.545560,
      NULL,
      NULL,
      ' 6-22-2001',
      NULL,
      NULL,
      4,
      2.827860,
      2.853690,
      ' 4- 0-1989',
      14,
      NULL,
      206,
      76.996055,
      3,
      ' 3-11-1982',
      ' 2-13-1984',
      NULL,
      0.912142,
      1,
      3,
      3,
      0.933470,
      NULL,
      2.151869,
      1.934917,
      NULL,
      28.664968,
      6,
      16,
      7,
      6,
      4,
      NULL,
      12,
      0.195390,
      NULL,
      9,
      NULL,
      0,
      1.323294,
      1.462666,
      NULL,
      1,
      NULL,
      0,
      NULL,
      134.910939,
      0.568489,
      0.100957,
      11.372120,
      NULL,
      0.142141,
      4,
      1.844078,
      0,
      0,
      4,
      0,
      9,
      3.961873,
      0.210464,
      1.317035,
      1.662319,
      8.598383,
      7.902050,
      1.814907,
      4.451575,
      NULL,
      3.183160,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244592,
      0,
      0.053098,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      9.999819,
      1.269997,
      7.903663,
      4,
      NULL,
      5.861822,
      0.243937,
      5.873132,
      0.552745,
      NULL,
      0,
      1.599080,
      1.034251,
      NULL,
      0,
      NULL,
      NULL,
      0.732869,
      NULL,
      0.064587,
      NULL,
      4,
      1.873857,
      NULL,
      NULL,
      1.922226,
      1.996665,
      0,
      7.159713,
      0,
      1,
      1.086528,
      3,
      NULL,
      0.487546,
      2,
      1,
      4,
      0.126874,
      0.182202,
      5.805343,
      0.553248,
      ' 4-17-1989',
      255.305210,
      ' 5- 3-1980',
      20.129566,
      1,
      1.384501,
      0.992735,
      0.423552,
      0.593030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261242,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867999,
      4.685668,
      NULL,
      3.128632,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.630878,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.495186,
      NULL,
      NULL,
      0.710752,
      1.767653,
      0,
      NULL,
      NULL,
      NULL,
      1.851516,
      NULL,
      NULL,
      NULL,
      3.036732,
      1,
      3.141710,
      NULL,
      NULL,
      2,
      3.189032,
      0,
      3,
      1.453525,
      3,
      1,
      3.609202,
      2,
      0,
      3.773389,
      3.253407,
      1,
      0.339780,
      7.732470,
      1,
      1.561389,
      1.050610,
      0,
      0.016210,
      0,
      0.507759,
      1,
      NULL,
      0.900920,
      NULL,
      0,
      NULL,
      5.469645,
      1.779530,
      1.553205,
      2,
      1.261527,
      0,
      2,
      0.716003,
      2,
      NULL,
      1,
      39.783376,
      0,
      0,
      NULL,
      NULL,
      54,
      62,
      1.556313,
      1,
      0,
      '00140',
      NULL,
      '',
      0.206925,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      3,
      15.500659,
      NULL,
      12,
      2,
      9.172314,
      1,
      3,
      3,
      1,
      3,
      NULL,
      0.640278,
      NULL,
      NULL,
      0.924622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.478933,
      NULL,
      NULL,
      0.624289,
      NULL,
      NULL,
      0.013773,
      NULL,
      NULL,
      1.926373,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      5.481562,
      1,
      0.786681,
      0.101036,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.378078,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.433957,
      NULL,
      NULL,
      0.038617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290190,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.122517,
      NULL,
      NULL,
      1.142186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598884,
      NULL,
      NULL,
      NULL,
      1.935139,
      3.335100,
      1.032689,
      NULL,
      NULL,
      0.337762,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.831646,
      3,
      0.238862,
      NULL,
      NULL,
      7,
      2.915221,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.909469,
      NULL,
      NULL,
      0.546117,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.496450,
      1.722076,
      3,
      NULL,
      3,
      0,
      3,
      7,
      4,
      4.002689,
      2.411754,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.840982,
      3,
      0.568900,
      NULL,
      NULL,
      NULL,
      3,
      1.537352,
      4,
      3.732532,
      3.243109,
      0,
      0.884025,
      3,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      0,
      7.182352,
      6,
      4,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.163174,
      1.007612,
      1.085547,
      0.705272,
      0,
      0,
      NULL,
      NULL,
      1.591623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.358781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.115558,
      0.214596,
      1.642702,
      NULL,
      3.068023,
      1.537453,
      NULL,
      NULL,
      1.000422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.351122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.685026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.101084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.122207,
      NULL,
      NULL,
      NULL,
      0.634665,
      2.830281,
      0.915739,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697478,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      11,
      1,
      NULL,
      0.616196,
      1.549215,
      0,
      1,
      1,
      0.293995,
      0.282149,
      1.669220,
      1,
      0,
      1,
      0.172487,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603083,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063101,
      1.800510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273561,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733116,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662162,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643863,
      1.447952,
      NULL,
      1.873826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.942768,
      1.898663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.554303,
      NULL,
      NULL,
      6.188341,
      1.107148,
      NULL,
      1,
      1,
      1.372460,
      NULL,
      1.190870,
      1,
      NULL,
      1.947039,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289657,
      0.358285,
      NULL,
      1.189148,
      0.350814,
      NULL,
      1.220432,
      1.519798,
      NULL,
      NULL,
      1,
      NULL,
      1.289230,
      2.621290,
      NULL,
      0,
      NULL,
      NULL,
      0.172750,
      0.990294,
      NULL,
      1,
      NULL,
      1.556506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001929,
      NULL,
      1.188398,
      NULL,
      0,
      NULL,
      5,
      4,
      7.786141,
      NULL,
      NULL,
      NULL,
      3.946055,
      NULL,
      1,
      1.793009,
      2,
      '23034',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.587671,
      NULL,
      '',
      '');
commit;
end;
/


