set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0101654';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      1.412062,
      1.851438,
      3,
      1,
      2,
      '310',
      '00414411',
      81.506189,
      24,
      NULL,
      3,
      0,
      0,
      1,
      '0133',
      1,
      1,
      NULL,
      NULL,
      ' 2-29-1983',
      7,
      205.655737,
      NULL,
      2,
      0,
      ' 9-19-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 1-11-1998',
      2,
      0.809405,
      1.261554,
      0,
      1,
      2.838144,
      2.267774,
      3.113016,
      NULL,
      NULL,
      NULL,
      2,
      3.832208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380971,
      0.756592,
      1.367804,
      NULL,
      1.408211,
      0.709009,
      0.088570,
      0.610976,
      1.889538,
      1,
      2,
      0,
      NULL,
      1.557508,
      2.655659,
      0.351689,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.994213,
      4,
      3,
      2.709909,
      1,
      NULL,
      1.722207,
      NULL,
      2.400898,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.926174,
      2.281988,
      1,
      1,
      0.610086,
      0.816093,
      NULL,
      NULL,
      3,
      3,
      1,
      1.514151,
      2.664476,
      0.183768,
      NULL,
      NULL,
      2.319120,
      0.095191,
      NULL,
      1.161233,
      1,
      2.890899,
      5,
      0,
      4.569954,
      3.879564,
      0.523589,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      3,
      1,
      4.669625,
      1.606181,
      NULL,
      1,
      NULL,
      1.196004,
      0,
      0,
      NULL,
      0,
      1.159898,
      3.356109,
      NULL,
      0.265523,
      1.382842,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      5.673529,
      0,
      1,
      4,
      1.531243,
      3.665751,
      4,
      1.978514,
      0.837947,
      3.741332,
      5.749740,
      0,
      1.650066,
      0,
      3.650740,
      ' 6-20-1975',
      NULL,
      ' 4- 3-1993',
      NULL,
      2.131784,
      1.126724,
      1.863386,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.925383,
      NULL,
      1,
      0.566474,
      1.503075,
      NULL,
      1.859236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.339148,
      1,
      2,
      3,
      2.217732,
      0.905032,
      NULL,
      NULL,
      5.402928,
      0,
      1.638909,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.653042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.850133,
      0,
      1.477966,
      0.768907,
      1.457851,
      0.295593,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.051848,
      0,
      NULL,
      5,
      2,
      2,
      2.910771,
      1.293070,
      1,
      3.474645,
      2,
      3.761536,
      NULL,
      0.865757,
      2.723385,
      1.793611,
      1.814415,
      1,
      0.926443,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.278794,
      0,
      1,
      0.106161,
      1.928855,
      3,
      5,
      0,
      6.908975,
      8,
      5,
      11,
      5,
      1,
      3.461957,
      2.979169,
      2,
      1.441379,
      3,
      2,
      24.892995,
      2.446284,
      0,
      81.986131,
      NULL,
      NULL,
      NULL,
      3.522555,
      0.063023,
      1,
      '00412',
      '',
      NULL,
      0.326501,
      NULL,
      '',
      '',
      3,
      '0310',
      '2321',
      NULL,
      NULL,
      0,
      175.928743,
      25,
      0,
      NULL,
      1,
      12.524432,
      3.168482,
      NULL,
      3,
      0.167094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119286,
      0.414778,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      3,
      3,
      1,
      0.024882,
      1.481490,
      2.391027,
      0.929876,
      3,
      1.673598,
      1.378152,
      3,
      1,
      0,
      0,
      2,
      1,
      0.031321,
      3,
      0.903039,
      1,
      9.509009,
      7.057847,
      1.354906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917877,
      1.022269,
      0.475878,
      NULL,
      3.577337,
      2.059953,
      0,
      1,
      0.777118,
      0.966587,
      1,
      1.165748,
      3,
      NULL,
      0.925046,
      2,
      3.311714,
      1,
      3,
      1.440410,
      1,
      0.511095,
      2,
      NULL,
      NULL,
      2.676778,
      3.761543,
      0,
      NULL,
      3,
      3,
      3.734269,
      0,
      1.401856,
      NULL,
      6.623336,
      NULL,
      1.854172,
      0.055172,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505277,
      3.509247,
      NULL,
      2,
      3,
      1,
      0.455191,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.237980,
      NULL,
      0,
      NULL,
      0.287747,
      1.591237,
      3,
      3,
      0.992858,
      0.190408,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.576984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.867382,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.310945,
      0,
      2.611972,
      6,
      1.497461,
      0.452747,
      5.686630,
      5.307613,
      1,
      1,
      NULL,
      NULL,
      3.083129,
      3.712447,
      NULL,
      1.320014,
      0,
      NULL,
      1,
      2,
      3,
      3.165005,
      2.821215,
      1,
      2.414776,
      1,
      0.182008,
      2.471180,
      1.262111,
      1,
      3.846080,
      3.268780,
      NULL,
      NULL,
      1,
      3.447433,
      NULL,
      3.544438,
      3,
      NULL,
      NULL,
      NULL,
      2.529850,
      2.674366,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.067422,
      1,
      NULL,
      NULL,
      1.920921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909576,
      NULL,
      NULL,
      0.486179,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.618354,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      0.468134,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.898315,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.591510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.758140,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.813445,
      NULL,
      NULL,
      NULL,
      0.628745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125195,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.240174,
      NULL,
      NULL,
      NULL,
      2.418120,
      NULL,
      NULL,
      NULL,
      1.745516,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      53,
      0.361454,
      27,
      1.354497,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.628904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      580.196298,
      8,
      0.469794,
      3,
      NULL,
      1.782458,
      1,
      0,
      1,
      1.551012,
      0,
      3,
      NULL,
      0,
      0.458802,
      1,
      1,
      NULL,
      0,
      2.744417,
      NULL,
      1.773554,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      21,
      NULL,
      1.207774,
      28.990727,
      NULL,
      0,
      1,
      3.870813,
      NULL,
      0.488294,
      NULL,
      0,
      NULL,
      1.686817,
      NULL,
      1,
      NULL,
      1.873053,
      NULL,
      NULL,
      NULL,
      0.946190,
      NULL,
      NULL,
      NULL,
      1.560722,
      NULL,
      0.701013,
      NULL,
      NULL,
      NULL,
      1.635200,
      NULL,
      1.831311,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170420,
      0.803918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.229946,
      0.758977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.838506,
      NULL,
      NULL,
      NULL,
      2.360858,
      NULL,
      1,
      NULL,
      1.957948,
      1,
      NULL,
      19,
      5.836328,
      0.604487,
      NULL,
      2,
      3,
      2,
      2,
      1.919548,
      3.232270,
      NULL,
      NULL,
      NULL,
      0.278121,
      NULL,
      3,
      0,
      0.554787,
      0.622896,
      0,
      NULL,
      0.247525,
      3.697509,
      NULL,
      1,
      1.379035,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0.881966,
      NULL,
      0,
      NULL,
      NULL,
      1.287524,
      1,
      NULL,
      0.867721,
      1.533834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037318,
      NULL,
      0.317360,
      NULL,
      1.313092,
      NULL,
      1.345314,
      8.264613,
      4,
      0,
      NULL,
      NULL,
      NULL,
      52,
      5,
      NULL,
      NULL,
      '42102',
      '02214',
      '13404',
      1,
      '',
      '',
      NULL,
      4.102970,
      '4231',
      NULL,
      '');
commit;
end;
/


