set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '34',
      32,
      NULL,
      '2334123',
      NULL,
      0.624659,
      5,
      0,
      '0343',
      3.314943,
      NULL,
      NULL,
      NULL,
      ' 0- 1-1984',
      11,
      71.399115,
      NULL,
      1,
      11,
      ' 7-20-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-29-1980',
      NULL,
      ' 7- 6-1982',
      0.927894,
      NULL,
      2.006665,
      NULL,
      NULL,
      0,
      6.175552,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.075192,
      3.195331,
      NULL,
      0,
      1.398796,
      NULL,
      1,
      1.599564,
      1,
      1,
      1.321327,
      0,
      1.168082,
      0,
      1,
      0,
      3.320187,
      0.710451,
      7.858608,
      NULL,
      1,
      0,
      7,
      9,
      1.519126,
      9.433572,
      0.244230,
      1,
      11,
      1,
      4.673782,
      1.910967,
      NULL,
      0.817101,
      0.590491,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.280627,
      3.859420,
      0.921001,
      2,
      0,
      1.711613,
      0,
      3,
      1,
      1,
      1.790981,
      0,
      1.624419,
      2,
      NULL,
      3,
      1,
      2.280966,
      2.011354,
      6,
      0.304717,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.828161,
      1.039129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.604914,
      1.960898,
      0,
      NULL,
      0,
      NULL,
      0.361689,
      NULL,
      0,
      1,
      NULL,
      0,
      0.336632,
      1.842873,
      0,
      1.081812,
      1,
      0,
      4.428192,
      0.310890,
      0,
      0,
      0,
      0.239496,
      0.441322,
      1,
      NULL,
      0.314025,
      5,
      3.900572,
      0,
      5,
      7,
      0,
      7,
      NULL,
      0.115878,
      2.436168,
      0,
      ' 3-21-1978',
      264,
      NULL,
      1065,
      2.243915,
      0,
      0.712881,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569683,
      NULL,
      0.893935,
      1,
      1.336364,
      0,
      0,
      1.291681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.426243,
      1,
      1,
      0,
      1.529775,
      1.452722,
      1.536642,
      3.842615,
      1,
      1.612936,
      2.428723,
      2.112225,
      NULL,
      NULL,
      NULL,
      0.791970,
      NULL,
      1.149630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.247962,
      0.365606,
      NULL,
      0,
      2,
      0.364521,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884178,
      0.603763,
      3.510929,
      0,
      2.021498,
      NULL,
      1.838338,
      NULL,
      0.591119,
      2.608472,
      2.437933,
      3.034869,
      2.207037,
      0,
      NULL,
      0,
      0.017285,
      1.843494,
      1,
      1.734595,
      0.984948,
      0,
      3.067861,
      0,
      0,
      4,
      1.521799,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.485439,
      NULL,
      2.075066,
      0.526066,
      7.193621,
      NULL,
      0,
      NULL,
      3,
      3,
      NULL,
      3.148622,
      49.205722,
      NULL,
      NULL,
      23.045016,
      NULL,
      11,
      56,
      5,
      1.938019,
      NULL,
      '02311',
      '',
      '',
      1,
      '',
      '',
      '',
      1.801818,
      NULL,
      '',
      NULL,
      0,
      32.398861,
      90,
      56,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.372485,
      3,
      3.419976,
      1.525793,
      NULL,
      NULL,
      1.585473,
      NULL,
      NULL,
      3,
      1.406432,
      0.561547,
      1.503795,
      2,
      2.073997,
      2,
      1,
      0.699572,
      NULL,
      1.551506,
      2.539995,
      2,
      NULL,
      2,
      1.902865,
      NULL,
      NULL,
      0.453158,
      NULL,
      NULL,
      0.523325,
      3,
      1,
      NULL,
      2.409538,
      1.591026,
      10,
      9,
      5,
      0.552828,
      0.534464,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      2.266511,
      1.681468,
      0.144225,
      0.061677,
      2.979742,
      0.733373,
      NULL,
      NULL,
      1.330681,
      1,
      1.706620,
      NULL,
      0.853890,
      1,
      NULL,
      0.615532,
      0,
      0,
      NULL,
      NULL,
      2,
      2,
      3,
      2.073602,
      1,
      1.644083,
      1,
      1.251026,
      0.878256,
      5.817897,
      0.388027,
      5,
      1,
      1.986795,
      NULL,
      NULL,
      NULL,
      1.582657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.080967,
      NULL,
      NULL,
      1.532080,
      NULL,
      NULL,
      1,
      0.711656,
      0.145520,
      1,
      1,
      NULL,
      1.056880,
      2,
      3.035019,
      6,
      1,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517739,
      NULL,
      NULL,
      0.074096,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.643075,
      NULL,
      NULL,
      NULL,
      1.225981,
      NULL,
      2,
      2.965527,
      0.054217,
      0.818878,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.185407,
      NULL,
      0.469388,
      2,
      1.480033,
      2.285475,
      7.324134,
      5,
      1,
      2.317351,
      NULL,
      1,
      1.953217,
      0,
      0.614836,
      0,
      1.898712,
      NULL,
      0,
      2,
      3,
      8.197620,
      0,
      1.664078,
      NULL,
      0,
      2,
      3,
      1.690523,
      5.662969,
      1,
      0,
      1.403653,
      1.391954,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504323,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.745426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994529,
      NULL,
      NULL,
      0.103490,
      NULL,
      NULL,
      1.852271,
      0.038401,
      1,
      1.161768,
      0.835727,
      3.343287,
      NULL,
      NULL,
      NULL,
      0.374840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661626,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.923205,
      NULL,
      NULL,
      NULL,
      0.406301,
      NULL,
      NULL,
      NULL,
      0.676989,
      NULL,
      NULL,
      NULL,
      1.413401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.506220,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.570552,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.914952,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      1.515692,
      0,
      0,
      1.938816,
      1.605745,
      NULL,
      1,
      0,
      0,
      1.639443,
      0,
      NULL,
      0,
      0.204189,
      NULL,
      NULL,
      1.623181,
      0.965307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.060567,
      NULL,
      NULL,
      1,
      NULL,
      0.927508,
      2.288618,
      6,
      1,
      NULL,
      1.779569,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.359918,
      1.029485,
      NULL,
      NULL,
      0,
      NULL,
      1.704677,
      0.906475,
      NULL,
      NULL,
      0.195440,
      NULL,
      1,
      0.848667,
      NULL,
      0.146883,
      NULL,
      NULL,
      0.993526,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.877154,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.746438,
      NULL,
      1,
      NULL,
      0.740930,
      NULL,
      6,
      3.900397,
      0.717412,
      2,
      15.980043,
      41.719345,
      0.900663,
      3.823309,
      1,
      '30103',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.654617,
      '',
      '',
      NULL);
commit;
end;
/


