set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758092';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      NULL,
      2,
      1.547271,
      NULL,
      2.713749,
      2,
      3,
      NULL,
      '04334110',
      18,
      16,
      '0023122',
      1.509191,
      0,
      2,
      3,
      '1110',
      0,
      0.697947,
      NULL,
      NULL,
      NULL,
      158,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 7- 6-1979',
      ' 9-26-1982',
      2,
      3.206796,
      1,
      1,
      1,
      2.138205,
      1,
      0.975530,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.242134,
      1.794323,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794701,
      1,
      1.925941,
      2,
      0.633944,
      NULL,
      NULL,
      1,
      NULL,
      1.684504,
      0.346589,
      NULL,
      0,
      NULL,
      0,
      9.601499,
      1.784857,
      4.313343,
      NULL,
      1.274924,
      1.418712,
      NULL,
      NULL,
      NULL,
      1.188207,
      3,
      0,
      1.158438,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.450446,
      4.244328,
      1,
      1,
      3.089895,
      0.732134,
      NULL,
      NULL,
      1.073068,
      1.321521,
      1,
      0.938719,
      1.093862,
      4,
      NULL,
      0.559956,
      4,
      1.418968,
      0,
      1.141795,
      2,
      NULL,
      1.856124,
      0.321187,
      NULL,
      1.106781,
      NULL,
      NULL,
      NULL,
      0.593797,
      NULL,
      0,
      3.400547,
      NULL,
      0.182141,
      5.927580,
      1,
      2,
      1.671978,
      9.337828,
      NULL,
      0,
      NULL,
      4.073004,
      2.793664,
      NULL,
      NULL,
      3.193997,
      9.488874,
      NULL,
      NULL,
      0,
      NULL,
      8.685289,
      1,
      NULL,
      2.779764,
      8.383701,
      0,
      NULL,
      2,
      ' 2-25-2001',
      NULL,
      1.617010,
      3.534307,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225623,
      NULL,
      2,
      1.012393,
      0,
      1,
      0.172414,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.038103,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1.052091,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.155923,
      6.919099,
      NULL,
      NULL,
      NULL,
      1.742649,
      2,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.824422,
      0,
      1.500701,
      NULL,
      NULL,
      1.309142,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.165829,
      2,
      0.674302,
      NULL,
      2,
      NULL,
      NULL,
      1.755898,
      2.433711,
      1,
      1.524624,
      0,
      0,
      NULL,
      4.396527,
      1.982079,
      NULL,
      NULL,
      1.135038,
      1,
      1,
      1.554978,
      1.479453,
      1.212570,
      1,
      1,
      1.023609,
      1.353435,
      1,
      NULL,
      4.103714,
      5.668170,
      4,
      1,
      11,
      2,
      3.387211,
      3.150709,
      5,
      NULL,
      2.641141,
      1,
      47.192060,
      0,
      0.570335,
      23.880079,
      NULL,
      16.360569,
      46.614499,
      3.714698,
      4.976716,
      2.587810,
      '11223',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.321376,
      '',
      NULL,
      '',
      0.486927,
      6,
      5.866593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.282192,
      0.255415,
      0.628594,
      0.674206,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245715,
      NULL,
      NULL,
      0.887260,
      NULL,
      NULL,
      0,
      NULL,
      1,
      123.982771,
      NULL,
      1,
      1,
      0.944506,
      0,
      NULL,
      0,
      NULL,
      1.734245,
      1,
      1.938892,
      1.520362,
      1,
      0,
      1,
      NULL,
      NULL,
      1.159838,
      1.957128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.689967,
      0.983951,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.230752,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955662,
      1.668370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.127704,
      NULL,
      1.592503,
      NULL,
      NULL,
      NULL,
      1.869465,
      NULL,
      NULL,
      NULL,
      0.985807,
      NULL,
      0.000986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111795,
      2,
      NULL,
      1,
      5.638814,
      0,
      4,
      3.018251,
      0.490736,
      0,
      NULL,
      0,
      0.952527,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452281,
      NULL,
      0,
      2.126649,
      NULL,
      1,
      1.376157,
      NULL,
      1.026938,
      1,
      NULL,
      0.406873,
      NULL,
      NULL,
      0.622651,
      NULL,
      NULL,
      1,
      1.438337,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.398488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.388619,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.738995,
      NULL,
      NULL,
      NULL,
      2.657943,
      NULL,
      0,
      NULL,
      0.571803,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.841681,
      NULL,
      2.217780,
      NULL,
      0.563896,
      NULL,
      37,
      NULL,
      0,
      1.221077,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.830951,
      3.714135,
      4,
      NULL,
      NULL,
      NULL,
      118,
      14.266907,
      3,
      NULL,
      1,
      '30100',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.144932,
      '',
      '',
      '');
commit;
end;
/


