set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4614445';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '2441400',
      2.843319,
      1,
      1,
      1,
      '3202',
      0,
      1,
      NULL,
      NULL,
      ' 7- 2-1986',
      7,
      NULL,
      4,
      NULL,
      0.385253,
      '11- 7-1976',
      72.218682,
      3.047193,
      201,
      NULL,
      3.970151,
      NULL,
      NULL,
      ' 1-12-1999',
      3.110365,
      0,
      1.555851,
      0,
      1,
      0,
      1.749016,
      0.935611,
      NULL,
      NULL,
      11.241840,
      14.392913,
      11.501102,
      NULL,
      NULL,
      0.877593,
      19.699480,
      0,
      0.021881,
      5,
      0,
      1.596736,
      0.314690,
      1.670822,
      NULL,
      1,
      NULL,
      2,
      3.185407,
      1,
      0,
      1.917175,
      4,
      NULL,
      3.998393,
      0.266951,
      0,
      NULL,
      NULL,
      0.995510,
      0.581189,
      1.039738,
      1.487692,
      1.095233,
      1,
      1.988832,
      0,
      0.758464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.343756,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.452921,
      1.591115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298775,
      1.545640,
      1,
      NULL,
      NULL,
      0,
      0,
      1.767837,
      NULL,
      0.196568,
      0,
      0.051099,
      5,
      0.515044,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.441540,
      0.307410,
      0,
      1,
      NULL,
      NULL,
      0.549332,
      NULL,
      1,
      1,
      NULL,
      0.709658,
      NULL,
      0.076367,
      2.138319,
      0.737607,
      4.878776,
      1,
      4.987621,
      4,
      NULL,
      1,
      7,
      7,
      NULL,
      1.056896,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.925378,
      NULL,
      1,
      0,
      0,
      0.557369,
      1.056877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809088,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.619298,
      0.799433,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394355,
      0,
      1,
      1,
      1.528331,
      1.433188,
      0.784778,
      1.715121,
      NULL,
      0.804290,
      1,
      NULL,
      NULL,
      NULL,
      0.550747,
      0.033649,
      3.701105,
      0,
      2,
      3,
      1,
      0,
      3,
      0,
      3.569569,
      3.743152,
      0,
      3.291805,
      NULL,
      NULL,
      NULL,
      1.774583,
      NULL,
      5.129243,
      NULL,
      NULL,
      NULL,
      0.261808,
      1,
      1.114468,
      1,
      0.691101,
      0.786054,
      NULL,
      6.633258,
      0.521833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897129,
      104.603771,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315434,
      1.957970,
      '43244',
      '43430',
      '',
      0,
      NULL,
      '',
      NULL,
      0.069415,
      '',
      '',
      '',
      NULL,
      NULL,
      540,
      43,
      3.558867,
      NULL,
      2.816096,
      8.887921,
      0.225773,
      3.288822,
      0,
      0,
      1.171836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.946582,
      1,
      NULL,
      0.303286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955887,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114098,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.198353,
      0,
      0.484902,
      0,
      3.147897,
      2,
      2,
      NULL,
      1.399612,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768442,
      NULL,
      NULL,
      0.044469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.582514,
      0.518006,
      3.481028,
      0.662556,
      1.554038,
      0,
      0,
      NULL,
      NULL,
      0.825608,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.374461,
      3.269548,
      NULL,
      0,
      0.736989,
      NULL,
      NULL,
      1.937945,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084815,
      NULL,
      0.809728,
      3,
      0,
      NULL,
      3,
      5,
      0,
      1,
      3,
      0.559464,
      NULL,
      6.094977,
      NULL,
      2.721953,
      NULL,
      NULL,
      3.473252,
      NULL,
      1,
      2.017569,
      2,
      0.037283,
      9,
      7.688121,
      NULL,
      2.481209,
      2.704734,
      0,
      2.613170,
      NULL,
      2.807404,
      1.186573,
      NULL,
      NULL,
      0.987374,
      1.313033,
      1.006755,
      7.334980,
      5.664658,
      0,
      5,
      5.024133,
      3,
      0.917534,
      NULL,
      5.081758,
      3,
      0.393866,
      1.872204,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      76.836768,
      NULL,
      NULL,
      2.860683,
      NULL,
      NULL,
      2.780616,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.807326,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750866,
      NULL,
      NULL,
      1.886716,
      NULL,
      NULL,
      4.048900,
      NULL,
      NULL,
      2,
      0,
      1.429439,
      1.623111,
      0.040327,
      NULL,
      NULL,
      0.356336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940500,
      NULL,
      NULL,
      0.264888,
      NULL,
      NULL,
      1.090449,
      NULL,
      NULL,
      0.297871,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.422122,
      NULL,
      NULL,
      2.343691,
      33.764642,
      1.043465,
      2917.435582,
      1,
      0.949882,
      NULL,
      0.649495,
      0.093135,
      NULL,
      0,
      0.579409,
      0.036895,
      1,
      0,
      1,
      0.237669,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      4,
      7,
      3,
      NULL,
      1,
      1,
      NULL,
      1,
      1.551871,
      0,
      1.079357,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.883518,
      0,
      1.942625,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859541,
      NULL,
      1.969389,
      NULL,
      1.214366,
      1.901633,
      1.980075,
      1,
      0.072125,
      1,
      0.199299,
      0,
      0,
      1,
      3.653210,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151015,
      1,
      1,
      1.161315,
      0.035558,
      1.704578,
      NULL,
      4.589391,
      5.877248,
      3,
      1.699488,
      0,
      112.106615,
      27.908755,
      2.025298,
      NULL,
      1,
      NULL,
      '32041',
      NULL,
      0,
      '',
      '',
      '',
      0.659696,
      '',
      '',
      '');
commit;
end;
/


