set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815085';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '3040323',
      2.945417,
      0,
      0,
      0,
      '3242',
      3.190831,
      1.202789,
      NULL,
      NULL,
      ' 9- 8-1997',
      NULL,
      NULL,
      1,
      NULL,
      1.477967,
      NULL,
      56,
      NULL,
      333,
      148.474036,
      0.890332,
      ' 3-29-1996',
      ' 9-22-1979',
      NULL,
      2,
      0.007523,
      3.463381,
      0,
      0,
      3.884008,
      2.346833,
      NULL,
      NULL,
      NULL,
      NULL,
      2.784922,
      1,
      163.424727,
      103,
      NULL,
      18,
      NULL,
      1.445140,
      6,
      0.557033,
      3,
      0.577381,
      NULL,
      1.501167,
      0.286936,
      NULL,
      0.482406,
      0,
      1,
      1.203681,
      2.896945,
      NULL,
      11,
      3,
      4.222672,
      NULL,
      NULL,
      NULL,
      1.738567,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.259644,
      1.274304,
      1.676259,
      4.012313,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782450,
      1.039723,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.303254,
      6.295584,
      6.316057,
      7.753901,
      1,
      5,
      1,
      NULL,
      3,
      0,
      0.708508,
      1,
      1,
      0.072688,
      1.925956,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      3.889689,
      5.081827,
      1.823024,
      1,
      1.481511,
      3.642334,
      NULL,
      0.651744,
      1.953903,
      0,
      1,
      1,
      2,
      0.086597,
      1,
      1,
      5,
      1.721914,
      4,
      3,
      2.464162,
      5,
      2.633654,
      ' 3-18-1978',
      110.994732,
      ' 7-14-1999',
      69,
      0,
      0,
      0,
      9.428963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.300060,
      1,
      0.321316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.605312,
      1.494653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756417,
      1,
      0,
      1.948714,
      0.798095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.890085,
      NULL,
      NULL,
      0,
      0.624436,
      1,
      NULL,
      1.822804,
      21,
      3,
      0.982687,
      NULL,
      NULL,
      NULL,
      1.766122,
      NULL,
      3.583898,
      3,
      3.598007,
      0.668430,
      1.019897,
      1.499422,
      1.772424,
      0.832220,
      3,
      NULL,
      2,
      1.156176,
      2.300324,
      0.256545,
      0,
      NULL,
      1.619521,
      5.433259,
      1.640311,
      1.887563,
      0.174207,
      1.610619,
      NULL,
      1.167788,
      0,
      0.377102,
      1.752254,
      NULL,
      NULL,
      0.721056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.008598,
      48.385333,
      70,
      1.384865,
      1.451321,
      NULL,
      '10314',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      3.590049,
      39,
      NULL,
      32,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.960441,
      1.592687,
      3.074740,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.410705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143278,
      NULL,
      NULL,
      0.254241,
      NULL,
      NULL,
      0.129568,
      NULL,
      NULL,
      0.537707,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.695747,
      NULL,
      NULL,
      0.251533,
      NULL,
      NULL,
      1,
      NULL,
      9.257363,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.043392,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.041041,
      1.201228,
      NULL,
      1,
      1.745356,
      1,
      0.832403,
      0,
      NULL,
      0,
      0,
      1.329246,
      1,
      1.216380,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.291908,
      0,
      2,
      0,
      1.058561,
      NULL,
      NULL,
      NULL,
      1.176038,
      NULL,
      NULL,
      NULL,
      2,
      0.922841,
      2,
      NULL,
      NULL,
      NULL,
      0.699707,
      0.450963,
      0.676175,
      1.848476,
      NULL,
      NULL,
      5.047817,
      2,
      1,
      0.884610,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.636705,
      4.533631,
      0.551554,
      0,
      NULL,
      NULL,
      1.563871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1.487714,
      1.014288,
      0,
      0.381839,
      7,
      0.038612,
      2,
      3.184839,
      1.352023,
      NULL,
      1.192826,
      NULL,
      NULL,
      1,
      3,
      2,
      0,
      NULL,
      NULL,
      0.084489,
      NULL,
      NULL,
      0,
      NULL,
      4.737553,
      1.544440,
      3,
      1.853383,
      0,
      1,
      2,
      3,
      1.732156,
      3.780309,
      3.288581,
      0,
      1.348827,
      10,
      NULL,
      8,
      5,
      3,
      0,
      2,
      3.412032,
      6.696817,
      0.770031,
      0.196769,
      1,
      NULL,
      1.516680,
      0.523110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.353782,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.027403,
      NULL,
      NULL,
      0.247090,
      0,
      1.134654,
      NULL,
      NULL,
      NULL,
      1.352753,
      NULL,
      NULL,
      NULL,
      239.443027,
      NULL,
      NULL,
      NULL,
      0.099148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003869,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.911245,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.836136,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      53.743415,
      1.333756,
      NULL,
      503.722157,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265050,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.749868,
      NULL,
      0.078868,
      14403,
      0.777062,
      1,
      1.136519,
      1,
      1.797430,
      0.871071,
      0,
      0.948423,
      1.959318,
      0.854362,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.338071,
      NULL,
      0,
      0.141378,
      5.525493,
      6.706363,
      3.292300,
      3.412918,
      15.540297,
      1,
      2.051841,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.764120,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.528660,
      NULL,
      0.929068,
      2.317119,
      NULL,
      1,
      1,
      0.875210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439640,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      NULL,
      2.378734,
      NULL,
      1,
      1.236957,
      70,
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      1.722730,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


