set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '2400311',
      1.219534,
      0.171955,
      NULL,
      1,
      '4104',
      2.884346,
      0.783041,
      NULL,
      NULL,
      ' 3-26-1990',
      8.254431,
      NULL,
      7.112756,
      NULL,
      NULL,
      ' 3- 0-1993',
      NULL,
      4.891502,
      242.791350,
      64,
      NULL,
      ' 6-29-1996',
      NULL,
      ' 9-27-1979',
      0,
      1,
      NULL,
      1.759326,
      1.334293,
      3,
      0,
      1.087780,
      1,
      184,
      NULL,
      NULL,
      5,
      2,
      NULL,
      4,
      NULL,
      NULL,
      2,
      3.036546,
      1.150799,
      0,
      1.544433,
      5,
      NULL,
      1.995638,
      0.643210,
      1.054205,
      0.678052,
      1,
      0.400687,
      2.979470,
      NULL,
      6,
      NULL,
      NULL,
      0,
      3.236835,
      NULL,
      5.902222,
      3,
      NULL,
      3,
      0.536782,
      1,
      NULL,
      1.881849,
      NULL,
      NULL,
      5.554974,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      0,
      0.944757,
      1.176604,
      0,
      0.447455,
      1,
      3.550082,
      2.901160,
      2,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1.187298,
      1,
      0.678175,
      NULL,
      1.765955,
      2.901507,
      0,
      0,
      NULL,
      NULL,
      1.403037,
      NULL,
      NULL,
      1,
      1,
      0,
      0.806642,
      NULL,
      5,
      3.527466,
      0.401260,
      2.618701,
      1.240026,
      NULL,
      1,
      1,
      2,
      1,
      0.967097,
      1,
      1.667504,
      1,
      NULL,
      0,
      0.011530,
      5.989818,
      1,
      4.556119,
      3.150639,
      0.226393,
      7.157656,
      NULL,
      0.728884,
      2,
      NULL,
      0.629288,
      5.182046,
      0,
      NULL,
      6.103961,
      3,
      0.723268,
      NULL,
      6,
      0,
      0.338119,
      6.329657,
      5,
      NULL,
      3.413261,
      1,
      ' 9-27-2000',
      2.650380,
      ' 1- 9-1987',
      12,
      0.936793,
      NULL,
      1.483654,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.548778,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.329253,
      0.419652,
      2.769659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666589,
      1.429306,
      3,
      3.350304,
      2,
      0.135053,
      1,
      0.142011,
      3.964225,
      4.718884,
      1.779075,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.952164,
      2,
      1.004489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.775556,
      NULL,
      NULL,
      0.278943,
      1,
      NULL,
      1.569050,
      29,
      0.465446,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.269679,
      0.563532,
      2,
      0,
      5.340926,
      1,
      1.998375,
      3.396446,
      3,
      2,
      3.829915,
      1,
      0,
      2.576253,
      1.071510,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036854,
      1.330370,
      3.008937,
      1,
      0.142167,
      2.767074,
      1,
      1.750304,
      0.702435,
      1.717584,
      5.004572,
      1,
      7,
      1,
      6.863407,
      NULL,
      NULL,
      5.831914,
      NULL,
      NULL,
      NULL,
      2.880677,
      1,
      0.253380,
      42.382251,
      2,
      3,
      NULL,
      50,
      19.968616,
      53,
      4.456410,
      0,
      1.267370,
      '10202',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.704584,
      0,
      NULL,
      NULL,
      1.867727,
      NULL,
      NULL,
      1.751116,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.943455,
      1.180479,
      0.699374,
      0,
      1.208588,
      1,
      NULL,
      0,
      1.869895,
      1,
      0,
      1.964731,
      1.690033,
      1,
      1.697458,
      NULL,
      1,
      1.631667,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      0,
      3.113768,
      6,
      4,
      NULL,
      4.444643,
      0.755056,
      2.582844,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.896059,
      1,
      NULL,
      1,
      3.895758,
      NULL,
      3.794014,
      0,
      NULL,
      1.284260,
      2.486832,
      NULL,
      1.234063,
      0.292475,
      NULL,
      3,
      1,
      NULL,
      1,
      1.248651,
      NULL,
      1.497639,
      NULL,
      NULL,
      1.103531,
      NULL,
      NULL,
      3,
      0.065976,
      0.926646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040959,
      NULL,
      NULL,
      NULL,
      0.212639,
      NULL,
      0.675111,
      7.923827,
      5.300416,
      1,
      3.077209,
      0,
      NULL,
      NULL,
      0.589739,
      1.543514,
      1.143432,
      '03212',
      '',
      '',
      1.455324,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


