set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9823126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      NULL,
      1.602016,
      2,
      3,
      0,
      0.183729,
      '042',
      '02031303',
      NULL,
      29,
      '2342122',
      0.136944,
      NULL,
      2,
      3,
      '3230',
      2,
      1,
      NULL,
      NULL,
      ' 8-17-1998',
      8.392639,
      NULL,
      NULL,
      3,
      0.080321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308632,
      NULL,
      NULL,
      ' 2-21-1998',
      1,
      1.542252,
      3.139663,
      1,
      1.729368,
      1.243041,
      2.777110,
      0.262712,
      NULL,
      NULL,
      NULL,
      13.439327,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601180,
      1,
      0.114554,
      0,
      1.571824,
      0.908511,
      1.583853,
      3,
      1.723293,
      NULL,
      NULL,
      1,
      3,
      3,
      1,
      1.637390,
      NULL,
      0,
      0,
      1,
      0.153656,
      0.256388,
      0.547086,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      2.916080,
      0.006566,
      0.257120,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.758600,
      1.642095,
      NULL,
      1.828015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.156772,
      NULL,
      1.966221,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710277,
      1.372543,
      NULL,
      NULL,
      1,
      1,
      1.602438,
      1,
      0,
      NULL,
      1.022873,
      0.517204,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1.518708,
      3.618407,
      NULL,
      0,
      4.568933,
      1.464298,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.480184,
      1.409075,
      4.087125,
      1,
      2,
      NULL,
      1.756090,
      1,
      3.141883,
      4,
      4.535455,
      0.140903,
      1.203549,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347941,
      1,
      0,
      0,
      0.302421,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.296343,
      1.067486,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.367035,
      7.310689,
      3.511366,
      2.321956,
      2,
      NULL,
      0.761363,
      NULL,
      NULL,
      1.553147,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.253610,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      3.714149,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331000,
      1,
      1,
      NULL,
      1.921587,
      1,
      3,
      2,
      3,
      NULL,
      1.297557,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910708,
      1.033769,
      1.057990,
      0,
      1,
      NULL,
      0.496868,
      NULL,
      NULL,
      1.784513,
      3.333854,
      8.625396,
      1.372745,
      7,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      0,
      0.614032,
      3,
      NULL,
      NULL,
      70,
      NULL,
      NULL,
      NULL,
      0.960209,
      0.595403,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      3.528017,
      5.570486,
      23.466568,
      1,
      2.041869,
      31,
      2,
      2,
      NULL,
      1.128686,
      3,
      1.085211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828666,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.596966,
      NULL,
      NULL,
      1,
      1.766747,
      NULL,
      0.275359,
      NULL,
      NULL,
      2.596333,
      1,
      NULL,
      3,
      1.223545,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.802354,
      3,
      3.630472,
      0.077724,
      1.498256,
      NULL,
      NULL,
      NULL,
      3,
      1.359961,
      NULL,
      1.492164,
      1.126452,
      1.619150,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.703058,
      0,
      2.867237,
      1,
      1.975553,
      NULL,
      0,
      1.791841,
      1,
      0.937573,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.815162,
      NULL,
      1.177645,
      NULL,
      0.831292,
      NULL,
      NULL,
      NULL,
      2.892568,
      NULL,
      0.825177,
      1.151822,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204622,
      NULL,
      NULL,
      1.436373,
      NULL,
      NULL,
      0.583024,
      NULL,
      NULL,
      0.736466,
      NULL,
      NULL,
      0.738961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.000255,
      1.896347,
      3.569678,
      0.601235,
      NULL,
      NULL,
      1,
      4.364256,
      5,
      1,
      3,
      NULL,
      1.796257,
      NULL,
      NULL,
      3.775824,
      0.755517,
      NULL,
      0,
      2,
      3.943128,
      0,
      0.885993,
      3.611162,
      9.682139,
      3,
      5,
      2.745450,
      3.399620,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.267539,
      3.427367,
      0,
      0,
      NULL,
      4,
      4.221012,
      NULL,
      5,
      NULL,
      0,
      0.972795,
      2.282878,
      1.167646,
      1.779717,
      1,
      0,
      0,
      NULL,
      1.910542,
      NULL,
      NULL,
      0.179938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.715142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383125,
      NULL,
      NULL,
      0.455863,
      NULL,
      NULL,
      0.321142,
      NULL,
      NULL,
      1.415666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.900161,
      3.999955,
      1.840492,
      0,
      1.899245,
      1.054129,
      NULL,
      4.869936,
      9,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      3.240957,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.367972,
      NULL,
      NULL,
      1.948633,
      0,
      NULL,
      NULL,
      3.920015,
      1,
      NULL,
      NULL,
      NULL,
      3.729034,
      NULL,
      NULL,
      1.661204,
      0,
      NULL,
      NULL,
      0,
      0.780564,
      NULL,
      NULL,
      2.029510,
      1,
      NULL,
      NULL,
      0.253713,
      3,
      NULL,
      NULL,
      1.883223,
      1.171950,
      NULL,
      NULL,
      2.820626,
      2.554213,
      NULL,
      NULL,
      0,
      0.634466,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      1.785097,
      NULL,
      NULL,
      2.081499,
      1,
      NULL,
      NULL,
      6.744395,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940382,
      NULL,
      NULL,
      NULL,
      NULL,
      7.678350,
      3.233818,
      1.916306,
      6,
      NULL,
      0,
      NULL,
      NULL,
      3.192580,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.382327,
      NULL,
      NULL,
      0.450575,
      NULL,
      0.173303,
      146,
      0.532894,
      0.013200,
      1,
      0,
      1.772593,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.517623,
      NULL,
      1,
      0,
      0.649234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722434,
      1.501157,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359964,
      1.029032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871807,
      0.902803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697368,
      1.240846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960823,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865311,
      0.823039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369682,
      NULL,
      0,
      0.018333,
      0.748322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.095174,
      2.261374,
      NULL,
      NULL,
      NULL,
      0.637680,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.243497,
      2.910600,
      1.555817,
      2.237024,
      1,
      3.712973,
      2,
      1,
      1.039690,
      1,
      0.632244,
      0.051845,
      2.075177,
      0.244709,
      1,
      0,
      0.175438,
      1.478970,
      0,
      0,
      1.385914,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.942977,
      NULL,
      1.767184,
      1,
      2,
      1,
      1.061008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738211,
      0.189902,
      1,
      NULL,
      1.435129,
      NULL,
      4.035299,
      2.966138,
      7.045933,
      0,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      '31430',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.022404,
      '',
      '',
      '');
commit;
end;
/


