set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '43',
      NULL,
      7,
      '4330332',
      0,
      0,
      6,
      1,
      NULL,
      NULL,
      1.107001,
      NULL,
      NULL,
      '11-23-1980',
      9.877723,
      NULL,
      NULL,
      0,
      NULL,
      ' 8- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1.406487,
      ' 0-23-1998',
      ' 8- 2-1977',
      NULL,
      3,
      3.682085,
      1,
      NULL,
      0.570218,
      0.665710,
      1.150364,
      0.747793,
      NULL,
      NULL,
      12.743736,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084477,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.489040,
      1.073527,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1.427729,
      5,
      NULL,
      NULL,
      0,
      1,
      1,
      1.766730,
      5,
      1.839218,
      2,
      NULL,
      NULL,
      2.178302,
      NULL,
      2.345073,
      1,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.620147,
      NULL,
      0.833833,
      2,
      0.652306,
      0,
      2.637164,
      1.160683,
      1,
      3,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      2.020526,
      0,
      0,
      1.871619,
      0,
      1.830208,
      2,
      0.994620,
      0.005365,
      1.085644,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.694019,
      1,
      NULL,
      0.636750,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1.855282,
      1.775340,
      0,
      1.643445,
      1.373210,
      0,
      0,
      NULL,
      0,
      1,
      2,
      0,
      1,
      NULL,
      0,
      2.480414,
      0.403042,
      2.120508,
      5,
      NULL,
      0.346259,
      1,
      0.196282,
      NULL,
      NULL,
      1,
      4,
      0,
      5,
      4.788173,
      4,
      4,
      3,
      4.854920,
      NULL,
      3,
      ' 5-26-1983',
      3,
      ' 6-22-1975',
      2.200985,
      1,
      0.285209,
      1,
      NULL,
      0.476491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705654,
      0.880790,
      5.118624,
      0,
      0.628138,
      1,
      1,
      0.845329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865009,
      NULL,
      NULL,
      NULL,
      2.818626,
      5.939969,
      0,
      NULL,
      1.623468,
      2,
      1.019391,
      4,
      NULL,
      NULL,
      3.456524,
      NULL,
      NULL,
      2.971310,
      0.865559,
      5.974745,
      NULL,
      NULL,
      4.769754,
      5,
      1.643909,
      NULL,
      NULL,
      0.302094,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.313238,
      1.080999,
      1.312803,
      0.827303,
      0.688842,
      NULL,
      2,
      62.090061,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.766927,
      2,
      NULL,
      NULL,
      1,
      1.240679,
      1.004361,
      1.011932,
      3,
      NULL,
      2,
      3.770863,
      0,
      1,
      1.041010,
      1.597926,
      1.663385,
      1.516679,
      NULL,
      1.940040,
      0,
      0.775470,
      1.058092,
      1,
      0,
      NULL,
      1.640255,
      0,
      0.557350,
      NULL,
      6.904497,
      6.704045,
      0.989418,
      5,
      7,
      3.656686,
      0.118117,
      NULL,
      2,
      2.867253,
      NULL,
      NULL,
      NULL,
      2.896706,
      3,
      NULL,
      48.293246,
      90.953821,
      5,
      3.604466,
      NULL,
      '24430',
      '',
      '',
      0.245269,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0,
      15.170039,
      13,
      NULL,
      1,
      26,
      8.219056,
      0,
      5.031530,
      0.554362,
      NULL,
      1.955241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.001460,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.145228,
      0.785053,
      0.334918,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769235,
      NULL,
      NULL,
      1.749214,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.644897,
      NULL,
      3.359589,
      2,
      2,
      0.837656,
      3.667486,
      1,
      1,
      1.166706,
      NULL,
      NULL,
      NULL,
      0,
      0.181407,
      2.895089,
      0,
      0,
      3,
      0,
      0.689453,
      3.092925,
      0.178281,
      1,
      0.541584,
      0,
      0.041032,
      0.790909,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817454,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0,
      1.668747,
      NULL,
      NULL,
      NULL,
      NULL,
      3.117510,
      NULL,
      2.930883,
      0.184203,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.366410,
      NULL,
      2.306096,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      1.575468,
      0,
      1,
      1,
      1.322872,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      1.489158,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      5,
      2.990387,
      NULL,
      0.399955,
      0,
      2,
      0.408402,
      1.760866,
      0,
      0,
      0.833696,
      1.150099,
      2,
      1.634019,
      0,
      2,
      NULL,
      2,
      0.853773,
      1.004343,
      2.494924,
      1,
      NULL,
      2,
      1,
      0.456502,
      0.018601,
      NULL,
      NULL,
      NULL,
      5.958653,
      2.245881,
      0,
      7,
      5,
      NULL,
      0,
      5.120262,
      NULL,
      0,
      1.359021,
      0.740803,
      0.527794,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961729,
      NULL,
      NULL,
      1.384950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466212,
      NULL,
      NULL,
      1.486227,
      NULL,
      NULL,
      1.884689,
      0,
      3,
      0.719048,
      3.869926,
      0.068853,
      2,
      NULL,
      5.305222,
      NULL,
      4,
      NULL,
      15.128294,
      NULL,
      1,
      NULL,
      3.506040,
      NULL,
      1,
      NULL,
      2.447262,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.534193,
      NULL,
      1.464045,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.595868,
      NULL,
      3,
      NULL,
      0.677537,
      NULL,
      1,
      NULL,
      0.280026,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.801991,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.670186,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      11.149058,
      NULL,
      15.098078,
      NULL,
      2.959368,
      3,
      7.379029,
      7,
      2,
      NULL,
      9,
      2.434994,
      1,
      1.747857,
      1,
      NULL,
      NULL,
      NULL,
      1.289845,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.102959,
      NULL,
      NULL,
      NULL,
      14.611771,
      0.027588,
      NULL,
      NULL,
      NULL,
      0.775430,
      1,
      1.392706,
      1.143244,
      1.267216,
      NULL,
      NULL,
      1.353752,
      1.548865,
      0,
      1,
      0,
      0,
      1.763901,
      1.960725,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.327627,
      2,
      0.044258,
      NULL,
      2,
      1.898685,
      2,
      5.136326,
      2.545488,
      3.590143,
      0.769283,
      NULL,
      1.702768,
      1.484485,
      1,
      0,
      1.121005,
      1,
      1.259207,
      NULL,
      1.447113,
      0.572311,
      NULL,
      0.644228,
      0.786045,
      1,
      NULL,
      0.804278,
      0.688234,
      1.066108,
      0,
      1.538436,
      0.130982,
      NULL,
      1,
      0.027421,
      1,
      1.093493,
      NULL,
      2.302150,
      3.904176,
      0.177522,
      NULL,
      3.815116,
      2.028190,
      NULL,
      0.800133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365982,
      0.172930,
      NULL,
      NULL,
      1.753610,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.773044,
      65.771779,
      0,
      5.475605,
      3,
      '12140',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      '233',
      NULL,
      '');
commit;
end;
/


