set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.674147,
      2.652175,
      NULL,
      NULL,
      1,
      1,
      0,
      2.270144,
      NULL,
      '33241220',
      31,
      45.236711,
      NULL,
      0.216103,
      0,
      2,
      NULL,
      NULL,
      1.930584,
      0,
      NULL,
      NULL,
      ' 9- 9-1997',
      173,
      157,
      NULL,
      1.160880,
      2.790593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-13-1976',
      NULL,
      ' 6-25-1993',
      1,
      1,
      3,
      1,
      1.469933,
      0,
      2,
      1,
      0,
      5.257380,
      0.958467,
      NULL,
      10.301547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.115145,
      5.516145,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.236285,
      0.887527,
      4.674099,
      5.025307,
      0,
      6.455313,
      NULL,
      0,
      9.546482,
      0.999314,
      5.573745,
      0,
      NULL,
      1.681430,
      NULL,
      NULL,
      0.554626,
      NULL,
      NULL,
      7.100801,
      2.771255,
      6.826315,
      1.735541,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      3,
      2,
      NULL,
      1,
      NULL,
      2,
      1,
      2.900058,
      2.352573,
      NULL,
      0,
      1.819293,
      7,
      0.446915,
      1.908678,
      NULL,
      1.231436,
      NULL,
      NULL,
      0.728282,
      NULL,
      NULL,
      1.851199,
      1,
      3,
      0.272355,
      0.658133,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.545765,
      0,
      NULL,
      1,
      1.399655,
      NULL,
      NULL,
      1.221799,
      1.123454,
      0.307061,
      5,
      0.531161,
      1.652324,
      4,
      NULL,
      0,
      4,
      1.585063,
      3.644842,
      8.136303,
      0.457035,
      4.323493,
      6,
      9,
      9,
      2,
      2,
      1.959580,
      0,
      4.941587,
      1,
      '10-15-1991',
      156,
      ' 8- 8-1990',
      2.718098,
      1.720610,
      0.335130,
      0.102326,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337561,
      NULL,
      0.768956,
      NULL,
      1.507630,
      1,
      3.812736,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823375,
      0.702530,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      0.408122,
      5,
      1.428820,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.845101,
      3.463387,
      1,
      1,
      0.738027,
      NULL,
      1.669549,
      2,
      5.100604,
      3.652753,
      0.691776,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.033772,
      1,
      2.280399,
      0,
      NULL,
      3,
      0,
      3,
      0.218754,
      1,
      3,
      3.127023,
      1,
      1.107678,
      1,
      0,
      0,
      0,
      NULL,
      1.561257,
      0,
      0.600107,
      NULL,
      0.039292,
      1.609307,
      0.845956,
      1.887937,
      NULL,
      5.283864,
      NULL,
      6,
      NULL,
      0,
      4,
      5.799503,
      2.801435,
      1,
      1,
      NULL,
      0.501779,
      0.997348,
      NULL,
      9,
      3,
      2,
      35.496392,
      NULL,
      14.015612,
      5,
      2.919704,
      5.582197,
      3,
      '21400',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      2,
      NULL,
      7.403550,
      22,
      1.284525,
      26,
      13.663769,
      0.427123,
      0,
      1,
      1,
      0,
      0.655454,
      NULL,
      NULL,
      0.329221,
      1.886115,
      1.576157,
      2.339546,
      2.580949,
      1.957463,
      0.734005,
      0,
      NULL,
      3.553406,
      3.125759,
      NULL,
      0.723045,
      1,
      NULL,
      1.250538,
      NULL,
      1.952904,
      1.254343,
      3,
      3.400350,
      3,
      3,
      3.155373,
      0,
      1.293403,
      0,
      2.109247,
      1.765244,
      2.698709,
      4,
      6.406319,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.922610,
      0.728955,
      0,
      0.550885,
      1.015165,
      2,
      3.060073,
      2.518478,
      1.049011,
      NULL,
      NULL,
      0,
      0,
      1.588017,
      3.966809,
      1,
      1.742539,
      1.101330,
      0.772620,
      0,
      0,
      0.623481,
      0,
      1.021261,
      0.341148,
      NULL,
      2.200779,
      NULL,
      1,
      1.604142,
      NULL,
      NULL,
      1.074078,
      NULL,
      NULL,
      0.404887,
      NULL,
      1,
      5.648465,
      2.721971,
      5,
      0,
      0.847529,
      NULL,
      NULL,
      NULL,
      1,
      0.844592,
      3.690666,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.028803,
      1,
      NULL,
      NULL,
      2.330460,
      NULL,
      1,
      0.615783,
      1,
      0,
      1.419317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739192,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.804616,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.684529,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.475912,
      0.700776,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      4,
      2,
      4.852238,
      NULL,
      1,
      2.749111,
      NULL,
      NULL,
      2.359918,
      3,
      NULL,
      3.414547,
      0.912404,
      2,
      1.843862,
      3.264184,
      5.746991,
      2.553629,
      2,
      NULL,
      3.741618,
      0,
      1,
      NULL,
      0.039837,
      NULL,
      1,
      NULL,
      0.347880,
      7.801856,
      6.134145,
      3.929257,
      6,
      4,
      1,
      0.655315,
      1.662009,
      0,
      1.679844,
      0.781897,
      NULL,
      NULL,
      1,
      0.649775,
      NULL,
      NULL,
      1.783176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207466,
      NULL,
      NULL,
      0.634655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      1.153373,
      1.496051,
      NULL,
      7.531210,
      NULL,
      2.335605,
      NULL,
      4.833702,
      NULL,
      0,
      NULL,
      2.547556,
      1,
      2.846564,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042045,
      0.644324,
      1.204888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.742020,
      0.549399,
      1,
      NULL,
      3.140254,
      2,
      1.114511,
      NULL,
      1.625378,
      0.783368,
      NULL,
      NULL,
      2,
      1.753275,
      0,
      NULL,
      NULL,
      3,
      1.066226,
      NULL,
      1,
      0,
      0.140384,
      NULL,
      2,
      2,
      5.250797,
      NULL,
      2.612050,
      NULL,
      0,
      5.628659,
      1.602388,
      0.291916,
      44,
      NULL,
      1.802800,
      NULL,
      0.759043,
      1,
      NULL,
      NULL,
      1.572236,
      2.096968,
      2.022006,
      1.135864,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.025928,
      1.763719,
      0.840887,
      1.893356,
      1,
      1,
      0,
      1,
      0,
      1.349148,
      1,
      1,
      0.152204,
      1,
      1.714428,
      0.479425,
      NULL,
      0.097365,
      NULL,
      0,
      1.946691,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848619,
      1.092668,
      2,
      1.766760,
      3,
      2.234113,
      NULL,
      3,
      2,
      1,
      3,
      NULL,
      0,
      1.125570,
      0.136929,
      0.635460,
      0,
      1.905036,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.537813,
      1,
      NULL,
      1.224407,
      0.693517,
      NULL,
      1,
      1,
      1.569044,
      0,
      1.828470,
      0.865203,
      0,
      NULL,
      3.780363,
      2,
      NULL,
      0,
      0,
      3,
      0.705276,
      0,
      0.997851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.536137,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      4.384122,
      1,
      NULL,
      NULL,
      110.082273,
      121.275253,
      4.423332,
      5.498654,
      0,
      '32424',
      '14230',
      '',
      1.505313,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


