set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303862';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '3423242',
      1,
      0.128526,
      4,
      2,
      '3233',
      2.198705,
      0.439240,
      NULL,
      NULL,
      ' 4-16-1986',
      51,
      NULL,
      0.501067,
      NULL,
      2.969731,
      NULL,
      19.787880,
      NULL,
      4.157380,
      NULL,
      3,
      ' 3- 5-1978',
      NULL,
      ' 6- 5-1991',
      2.913150,
      1,
      1.952866,
      2,
      1,
      2,
      0,
      1.809192,
      NULL,
      NULL,
      NULL,
      11.480979,
      NULL,
      17,
      1.596251,
      1,
      NULL,
      1,
      NULL,
      5.475300,
      0.007228,
      0.655344,
      0,
      NULL,
      NULL,
      1,
      1,
      0.087014,
      1.837580,
      0.064055,
      NULL,
      4.555622,
      2,
      NULL,
      2,
      6,
      NULL,
      1,
      4,
      NULL,
      0.339756,
      8,
      NULL,
      NULL,
      1.206693,
      0.621328,
      0,
      5,
      1,
      3,
      0,
      1.123666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735925,
      0.473775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075249,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.584845,
      3,
      0,
      0.755574,
      1.347284,
      NULL,
      1.913875,
      NULL,
      1,
      0,
      1.048451,
      1,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0.844434,
      NULL,
      NULL,
      0,
      1.010781,
      1,
      1,
      6.536618,
      0,
      NULL,
      1,
      0.303599,
      1.917726,
      6.824235,
      NULL,
      0.195283,
      NULL,
      2.469352,
      NULL,
      1.814861,
      7.447682,
      5.852263,
      NULL,
      1,
      NULL,
      3.089628,
      2,
      2.646359,
      ' 5-18-2001',
      108,
      ' 1-14-1975',
      21.482292,
      0.267359,
      0,
      0.578206,
      3.327678,
      0.574053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031778,
      1,
      4,
      0.386096,
      0,
      NULL,
      0.862747,
      0.429657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.864193,
      NULL,
      3,
      2.928340,
      0.275495,
      0.749643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.415809,
      0.118562,
      NULL,
      9,
      NULL,
      5.328317,
      4,
      0.991445,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.621014,
      1.433655,
      1,
      1,
      1.197093,
      1.547821,
      3.889066,
      1,
      3.746190,
      0,
      NULL,
      NULL,
      NULL,
      3.402732,
      NULL,
      2.515676,
      2,
      0.932216,
      NULL,
      3,
      1.603182,
      3.921299,
      0.541087,
      NULL,
      1.997634,
      3.068820,
      2,
      0,
      0.453700,
      NULL,
      0.503560,
      0,
      NULL,
      0.125823,
      NULL,
      0.465597,
      0.661952,
      NULL,
      NULL,
      1.503637,
      0,
      NULL,
      2,
      3.263778,
      NULL,
      NULL,
      NULL,
      6.845900,
      4,
      NULL,
      0.639186,
      NULL,
      NULL,
      1,
      NULL,
      0.572198,
      3.341699,
      47,
      3.664094,
      NULL,
      NULL,
      10,
      2.863147,
      38,
      3,
      1,
      1,
      '33023',
      '03311',
      '',
      1.395519,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.530327,
      2,
      11,
      8,
      2,
      26.750326,
      1.484639,
      NULL,
      2,
      0.128440,
      1.489697,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.005648,
      3.907438,
      3.205049,
      3,
      2.912181,
      NULL,
      2.888025,
      1,
      NULL,
      NULL,
      NULL,
      2.212404,
      NULL,
      0,
      NULL,
      NULL,
      2.819133,
      NULL,
      3.096391,
      0,
      NULL,
      NULL,
      0.334243,
      NULL,
      NULL,
      1.297114,
      NULL,
      NULL,
      3,
      7.069609,
      6,
      1.429058,
      0.108975,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.514792,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103078,
      NULL,
      NULL,
      1.417047,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.191951,
      NULL,
      NULL,
      0,
      0.692038,
      NULL,
      3.479439,
      NULL,
      NULL,
      1.886384,
      NULL,
      NULL,
      0.107918,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.359590,
      NULL,
      NULL,
      1.946816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.856138,
      1.195038,
      2,
      2.290612,
      5,
      0.932250,
      0.165806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      2,
      3,
      2.836060,
      2,
      2.324526,
      NULL,
      NULL,
      1.158915,
      0.575502,
      2,
      2.793863,
      0,
      2.445245,
      3,
      7.458992,
      7,
      3,
      2.769180,
      2,
      3,
      2.438196,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      1.592655,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.278874,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.936924,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.829765,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.874870,
      NULL,
      1,
      1.936309,
      NULL,
      4.768708,
      NULL,
      NULL,
      NULL,
      26.728564,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.501318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.535270,
      NULL,
      NULL,
      NULL,
      1.649794,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.607659,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.042875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822271,
      NULL,
      NULL,
      NULL,
      3.813475,
      1.913498,
      1,
      0.530387,
      1.289085,
      1.364029,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311225,
      NULL,
      1,
      564.970048,
      1.262545,
      NULL,
      NULL,
      1.398475,
      0,
      1,
      0.522948,
      0,
      1.503630,
      NULL,
      NULL,
      1,
      1.002224,
      0.995070,
      0,
      1,
      NULL,
      0.088714,
      1.541790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.420796,
      1.949380,
      1.899935,
      1,
      0,
      0.088817,
      1.681797,
      5,
      3.082347,
      2.658279,
      NULL,
      1,
      1,
      NULL,
      1.612334,
      0.237828,
      NULL,
      3,
      2.932254,
      NULL,
      0.348593,
      0.303183,
      NULL,
      2,
      1,
      NULL,
      2.106716,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.735903,
      NULL,
      NULL,
      1.680580,
      0,
      NULL,
      1.974824,
      0,
      NULL,
      0,
      1.095477,
      NULL,
      NULL,
      0,
      0.667472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2,
      NULL,
      0.623803,
      NULL,
      1.019276,
      NULL,
      NULL,
      NULL,
      3.645268,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.923212,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.440911,
      NULL,
      13.753267,
      3,
      NULL,
      0.491145,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      1,
      7.904604,
      1.237070,
      NULL,
      NULL,
      39.082293,
      49,
      3.343396,
      NULL,
      NULL,
      '23001',
      '00330',
      '',
      3.323130,
      '31034',
      '',
      '',
      0.370965,
      '',
      '',
      '');
commit;
end;
/


