set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7944128';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '1110410',
      1.218695,
      0.714535,
      0,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      '10-17-1998',
      13,
      NULL,
      3.421669,
      3.286975,
      NULL,
      ' 0- 6-1997',
      NULL,
      NULL,
      NULL,
      146,
      0,
      NULL,
      ' 3- 3-1985',
      NULL,
      NULL,
      0.183668,
      2,
      NULL,
      0.335063,
      NULL,
      NULL,
      0,
      0,
      100,
      2,
      13,
      8,
      106.474951,
      60.475979,
      1,
      5.716620,
      4.030051,
      0.847850,
      6,
      0.905604,
      NULL,
      0.779017,
      0,
      0.105017,
      0.513264,
      NULL,
      1,
      0.557240,
      1,
      169,
      15,
      NULL,
      3,
      1,
      4.458339,
      1,
      NULL,
      1.535468,
      0.284319,
      6,
      7.459762,
      1.551885,
      NULL,
      0,
      0,
      0,
      8,
      1.998541,
      5.631531,
      0.233170,
      0.008712,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      8,
      1,
      2.207192,
      0.931390,
      1.835038,
      1,
      0.892424,
      NULL,
      0,
      1.962441,
      NULL,
      NULL,
      0.499760,
      NULL,
      0.108385,
      0.820543,
      0.421780,
      NULL,
      1.599151,
      3,
      1,
      8,
      8.292145,
      NULL,
      2.986857,
      NULL,
      2.391546,
      NULL,
      NULL,
      0.685894,
      NULL,
      NULL,
      0.197070,
      3.372257,
      NULL,
      1,
      NULL,
      7.912146,
      4,
      1.952766,
      1,
      9.221047,
      1,
      9.627036,
      NULL,
      2.255782,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1.884693,
      1.679461,
      1.117888,
      3.151968,
      0.328149,
      0.275142,
      NULL,
      2,
      0,
      0.679946,
      NULL,
      NULL,
      1.648440,
      2.223525,
      10.059101,
      8.688381,
      1.706856,
      0,
      1,
      0.354794,
      9,
      7,
      7,
      4.434016,
      8.630780,
      7,
      NULL,
      1,
      ' 6-28-1981',
      1013.133118,
      '10- 2-1980',
      NULL,
      NULL,
      1,
      0,
      7,
      6,
      NULL,
      0,
      NULL,
      1.992155,
      1,
      NULL,
      NULL,
      2,
      2,
      7.922294,
      4.842984,
      2,
      0.970747,
      3.662567,
      1,
      2.421955,
      NULL,
      NULL,
      NULL,
      3.530271,
      NULL,
      0,
      0.992872,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.227389,
      1.156913,
      2.875196,
      NULL,
      0.177911,
      3,
      1.296097,
      NULL,
      NULL,
      NULL,
      1.580179,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456440,
      1.060391,
      NULL,
      NULL,
      1.397100,
      0,
      NULL,
      NULL,
      28,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.981472,
      2,
      2,
      NULL,
      1,
      3,
      2,
      0.401958,
      0.994962,
      3.869935,
      3,
      2.654892,
      1.711341,
      0,
      0,
      6.059643,
      0,
      1.371733,
      NULL,
      1.674249,
      0,
      1.428414,
      1,
      1.290021,
      1.252985,
      1.110171,
      3.804315,
      1.386820,
      3.854691,
      1,
      3,
      3.237959,
      4,
      1,
      2.936934,
      NULL,
      4,
      0,
      1.407143,
      2,
      42,
      1.885564,
      2,
      NULL,
      7,
      25,
      35.458559,
      2.864879,
      0,
      0.491761,
      '44124',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3,
      '1241',
      NULL,
      '',
      0,
      5,
      143.698036,
      8,
      1.706098,
      40.782187,
      13,
      148.589408,
      0,
      1.180882,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.556907,
      1.879317,
      1.834679,
      0,
      1.634083,
      3.414259,
      1,
      1.073643,
      1.452749,
      NULL,
      1,
      3,
      1,
      3.111737,
      1.617684,
      0,
      1,
      0.506177,
      1,
      NULL,
      NULL,
      1.891402,
      NULL,
      NULL,
      0.304952,
      NULL,
      NULL,
      0.141648,
      7,
      0,
      NULL,
      0,
      NULL,
      2.802071,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.940710,
      NULL,
      NULL,
      NULL,
      7.292258,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.221129,
      0.424308,
      1.289040,
      0,
      1.534666,
      1.342450,
      1.081978,
      1.017614,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704053,
      0,
      2.903106,
      5,
      1.875005,
      0,
      1.878417,
      10.538264,
      4,
      0.715610,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      3.010468,
      2.907453,
      2,
      2.624483,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      0.740839,
      3.394127,
      1,
      0,
      1,
      7,
      3.989938,
      4.455621,
      0.813316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786206,
      NULL,
      NULL,
      1.328987,
      NULL,
      NULL,
      1.738655,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      2.800889,
      NULL,
      8.239819,
      NULL,
      1,
      6.005738,
      7.148171,
      0,
      8.071219,
      NULL,
      3.142468,
      3.158288,
      2,
      1,
      2.105224,
      2.354980,
      NULL,
      1.538443,
      NULL,
      NULL,
      4,
      8.628293,
      2.625895,
      2.153496,
      1,
      3.880874,
      0.877705,
      1.404596,
      1.141423,
      2.534418,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      9,
      9.823270,
      NULL,
      0,
      5,
      9.838080,
      1.521282,
      NULL,
      1,
      0.544765,
      2,
      2.727814,
      NULL,
      5,
      8.177654,
      NULL,
      37,
      0.244253,
      NULL,
      1.106878,
      1.001953,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      2.071317,
      3.792869,
      NULL,
      0.782146,
      1.046267,
      NULL,
      0,
      3.723965,
      NULL,
      1.768319,
      1,
      NULL,
      3.940960,
      1,
      NULL,
      2,
      1.347853,
      NULL,
      2.775407,
      1.702972,
      NULL,
      0.356282,
      0.540202,
      NULL,
      7.769869,
      4,
      NULL,
      4,
      1,
      1,
      0.871737,
      0.727155,
      0.805515,
      1.965729,
      0,
      NULL,
      NULL,
      0.927854,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.235566,
      NULL,
      NULL,
      NULL,
      2.805961,
      NULL,
      NULL,
      NULL,
      0.992147,
      NULL,
      NULL,
      NULL,
      1.459024,
      0,
      NULL,
      NULL,
      1.385515,
      NULL,
      NULL,
      NULL,
      1.427710,
      3.269121,
      NULL,
      NULL,
      1.452604,
      0.625671,
      NULL,
      NULL,
      1.490951,
      1.216094,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.202051,
      0.703412,
      NULL,
      NULL,
      4,
      4,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      63.453213,
      174,
      NULL,
      34.888394,
      NULL,
      0.116021,
      NULL,
      NULL,
      3.632397,
      23.724075,
      5.304988,
      1,
      76,
      36,
      0.084955,
      2,
      0.952307,
      0.847410,
      41.427032,
      NULL,
      55,
      10,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      1.204496,
      0,
      0.649911,
      1,
      1.398104,
      0,
      1.296450,
      NULL,
      0.263213,
      1.110726,
      1.906109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.732818,
      NULL,
      0.655344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410501,
      NULL,
      NULL,
      NULL,
      1.659796,
      NULL,
      0,
      1,
      0.279814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.793357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.282643,
      NULL,
      NULL,
      NULL,
      1.994455,
      NULL,
      NULL,
      NULL,
      1.043554,
      NULL,
      0.284045,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.032182,
      0,
      1.185797,
      1.616562,
      0,
      3.162817,
      NULL,
      3.751941,
      0,
      0.117458,
      0,
      3,
      NULL,
      0.774560,
      0,
      1,
      1.670707,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.433607,
      1.594542,
      1.184598,
      0.809476,
      0.419366,
      1,
      1.517684,
      1.821299,
      1.049924,
      0,
      1.378852,
      0,
      NULL,
      0.487733,
      NULL,
      1.830706,
      1.768680,
      1.543851,
      NULL,
      2.897043,
      0,
      2,
      1.958918,
      0.533434,
      NULL,
      1.595783,
      NULL,
      0.308131,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.659517,
      NULL,
      1.178386,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.749040,
      NULL,
      1,
      NULL,
      0.766404,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047566,
      1.146030,
      0.110060,
      1,
      0.312421,
      1,
      1.718438,
      7.715173,
      NULL,
      2.111936,
      0,
      1,
      NULL,
      NULL,
      0.207916,
      1.706380,
      1,
      '02031',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      '3230',
      '4140',
      '');
commit;
end;
/


