set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      1.573257,
      NULL,
      NULL,
      3,
      '1300',
      1.778356,
      0.495644,
      NULL,
      NULL,
      ' 8-14-1991',
      9.112546,
      NULL,
      2.660786,
      2.939342,
      2.340186,
      '11-25-2003',
      2.707867,
      2,
      38.386752,
      117.426746,
      3.317682,
      ' 5- 9-1980',
      NULL,
      ' 1- 1-2003',
      NULL,
      0.090624,
      0.050047,
      NULL,
      1.758998,
      0.386934,
      NULL,
      NULL,
      0.270448,
      NULL,
      0,
      8,
      4.191433,
      9,
      16,
      4.612268,
      NULL,
      NULL,
      2.099392,
      7,
      0.984029,
      NULL,
      1.633729,
      0.573229,
      NULL,
      0.464725,
      0.644308,
      2.735475,
      0.094835,
      0.666064,
      1.271718,
      NULL,
      4,
      2.506449,
      2.508120,
      NULL,
      1.376597,
      1.274440,
      NULL,
      1.118593,
      NULL,
      1.784015,
      NULL,
      NULL,
      0,
      8,
      8,
      5.164704,
      1.678153,
      2.902996,
      NULL,
      0.916793,
      1.465093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.832177,
      1.601034,
      0,
      1,
      1.766405,
      1,
      3,
      3.475265,
      NULL,
      0,
      NULL,
      0,
      2.658588,
      0,
      NULL,
      3.693145,
      1.543594,
      3,
      7,
      2.648299,
      7,
      11.424063,
      1,
      1.601176,
      0.765497,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      3,
      NULL,
      2,
      0,
      0.756486,
      NULL,
      1.754310,
      4.297070,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      4,
      3,
      3,
      6.112262,
      NULL,
      6.520725,
      0.129232,
      1.655931,
      6,
      4,
      NULL,
      NULL,
      2.275782,
      8.935078,
      NULL,
      7.964733,
      8.165583,
      1,
      2,
      NULL,
      6.969706,
      4.647005,
      1,
      7,
      1,
      NULL,
      2.872541,
      ' 9-27-2000',
      364.718160,
      ' 3-13-1982',
      49,
      1.202764,
      0.661268,
      1,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411667,
      NULL,
      0,
      0.414197,
      1.975878,
      NULL,
      0.906524,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3,
      NULL,
      1,
      0.601493,
      3.896828,
      0.892965,
      0.001707,
      6,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      7.945189,
      1,
      9,
      5.381064,
      6.194858,
      1.152359,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2.158849,
      1.917647,
      1,
      0,
      2.566762,
      35.661733,
      0.195743,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001690,
      1,
      NULL,
      NULL,
      3,
      1,
      2,
      3,
      3,
      1.461214,
      3,
      2,
      2.545533,
      3.398890,
      1,
      0,
      2.794819,
      0,
      0.929756,
      0.335883,
      0,
      1.601737,
      0.882206,
      NULL,
      1.851523,
      0,
      NULL,
      1,
      1.529754,
      NULL,
      2.812724,
      0,
      11.368545,
      11.897952,
      7,
      9.273214,
      2.559456,
      NULL,
      1.585521,
      NULL,
      4,
      1,
      3,
      2,
      23,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '23411',
      '',
      '',
      1.213668,
      '',
      '',
      '',
      0.950229,
      '',
      '',
      '',
      2,
      14.992464,
      35.009955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.882125,
      NULL,
      NULL,
      NULL,
      3,
      0.842808,
      NULL,
      1.250180,
      1,
      0.189567,
      3.306120,
      3,
      3.867723,
      2.104141,
      3,
      3,
      7.713135,
      NULL,
      3.592900,
      0.020007,
      1.116429,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2,
      1.335057,
      3,
      3.817811,
      1,
      NULL,
      NULL,
      2,
      3.587184,
      1.494243,
      1.610360,
      1.205297,
      3.331849,
      3.495850,
      1,
      1.267553,
      1.718450,
      0.732852,
      0.937333,
      1,
      3.812304,
      NULL,
      0,
      3,
      0.563709,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.627888,
      2,
      0.048830,
      4.980384,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.124924,
      3,
      0.963681,
      3.854162,
      0.240660,
      NULL,
      NULL,
      0.077804,
      NULL,
      NULL,
      1.271840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.444706,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840714,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.779522,
      NULL,
      NULL,
      0,
      1.911766,
      1.157426,
      0.624448,
      NULL,
      NULL,
      3.244341,
      NULL,
      1.676632,
      1,
      NULL,
      2.211873,
      1.931319,
      NULL,
      NULL,
      0.474111,
      3,
      NULL,
      0.145048,
      3.854702,
      1,
      1.900264,
      2.520084,
      2.840988,
      2.965567,
      5,
      7.046637,
      NULL,
      2.179883,
      1,
      1,
      0.115530,
      1,
      NULL,
      1,
      NULL,
      2.988734,
      NULL,
      3.464223,
      NULL,
      NULL,
      1,
      2,
      2.357953,
      NULL,
      1,
      3,
      4,
      NULL,
      1,
      0.585812,
      0.910644,
      1.726042,
      2.992182,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262069,
      NULL,
      NULL,
      1.826049,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732431,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.798476,
      1.789892,
      0,
      0,
      NULL,
      3.123457,
      0.519504,
      NULL,
      2,
      4.189199,
      NULL,
      NULL,
      130.805318,
      8,
      NULL,
      NULL,
      3.817894,
      0,
      NULL,
      NULL,
      0,
      1.574210,
      NULL,
      NULL,
      NULL,
      1.638294,
      NULL,
      NULL,
      3.124010,
      NULL,
      NULL,
      NULL,
      1.308748,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.505438,
      1.549675,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.211968,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.847099,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696573,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3,
      2.232660,
      NULL,
      NULL,
      3.825925,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      13.494090,
      14.155623,
      NULL,
      NULL,
      3,
      1.935483,
      NULL,
      NULL,
      NULL,
      3.857831,
      NULL,
      5.065564,
      1.249318,
      1,
      0.972231,
      0,
      NULL,
      NULL,
      3.423425,
      7.535688,
      0,
      NULL,
      NULL,
      NULL,
      1.215524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.691830,
      1.405620,
      NULL,
      1,
      1,
      0.700797,
      0,
      1.151871,
      0.131274,
      NULL,
      1,
      NULL,
      0.755048,
      1.375275,
      NULL,
      0.114684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905843,
      0.333188,
      3,
      3.247321,
      3,
      NULL,
      NULL,
      2.321130,
      1.424067,
      1.215831,
      0,
      NULL,
      0.592144,
      0.373295,
      NULL,
      1.309264,
      2.969244,
      NULL,
      1.770673,
      2.420372,
      NULL,
      1.092324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777386,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.285472,
      3.842403,
      NULL,
      0,
      0.375425,
      NULL,
      NULL,
      1.325180,
      NULL,
      0,
      2,
      NULL,
      0.358095,
      1.533386,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      6,
      0,
      0.036788,
      1,
      NULL,
      NULL,
      45.673714,
      96,
      2.688825,
      1,
      3.205452,
      '12030',
      '',
      NULL,
      0.394225,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


