set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '2032321',
      1.482192,
      0,
      4,
      3,
      '2044',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      3.355179,
      0,
      3.241413,
      NULL,
      30,
      3.074824,
      NULL,
      59.170943,
      NULL,
      ' 7-11-1984',
      ' 6- 8-1980',
      NULL,
      3,
      3.399199,
      0.115103,
      3.364951,
      1.177552,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      11.890784,
      1,
      26,
      16,
      1,
      1,
      0,
      0,
      5.518195,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.724640,
      1,
      1.230002,
      2,
      0,
      3,
      4,
      1.731740,
      4,
      1.422790,
      1,
      1,
      0,
      1,
      NULL,
      3,
      1.953517,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      3.281490,
      0,
      3.344410,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.907136,
      3.311165,
      0,
      0,
      1.946966,
      2.493294,
      NULL,
      1.245339,
      NULL,
      NULL,
      1,
      3.704481,
      5,
      NULL,
      1,
      0.180456,
      1.573815,
      NULL,
      7.779181,
      1,
      1.648308,
      2.853771,
      0.289523,
      2,
      2.408528,
      0,
      0,
      0.939382,
      NULL,
      0,
      1.696124,
      1,
      NULL,
      NULL,
      1,
      3.431309,
      1,
      1,
      2.622331,
      7.900687,
      5,
      0.479600,
      0,
      1.888592,
      1,
      1,
      NULL,
      0.991539,
      NULL,
      9.564198,
      2,
      0,
      NULL,
      8.533242,
      4,
      9,
      4,
      5,
      0,
      0.788033,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.837802,
      1,
      4,
      0.365566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.248625,
      1.410049,
      0,
      0.132500,
      0.253342,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.079159,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779355,
      NULL,
      0.863957,
      3,
      NULL,
      1,
      1,
      3.651319,
      6,
      3,
      NULL,
      6,
      0.626730,
      NULL,
      NULL,
      1.150799,
      13,
      3,
      0,
      3.505789,
      NULL,
      NULL,
      ' 5-20-1980',
      9,
      NULL,
      4,
      1.658695,
      0,
      1.624588,
      0,
      1,
      NULL,
      0.703327,
      0,
      1,
      1,
      2,
      31,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092700,
      0.277964,
      1,
      NULL,
      3,
      6.157385,
      0.683823,
      1.584819,
      1.676555,
      1,
      NULL,
      3,
      2.298587,
      1,
      0.597532,
      0,
      NULL,
      1.634351,
      1,
      0.352700,
      NULL,
      1,
      1.913571,
      0.817196,
      0.503457,
      1.226982,
      1,
      1.691996,
      1.814072,
      1.795990,
      0,
      0,
      6,
      11.900009,
      1.403503,
      1,
      11.573570,
      1,
      NULL,
      3,
      6,
      3,
      NULL,
      2,
      47.669845,
      1.442822,
      0.055928,
      NULL,
      44.815263,
      18.908729,
      27,
      1,
      1,
      3,
      '42012',
      '',
      '',
      1.760785,
      '',
      '',
      NULL,
      1.137424,
      '',
      '',
      '',
      2,
      37,
      NULL,
      20,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.911005,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.873167,
      0.865424,
      NULL,
      NULL,
      0.620487,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.000472,
      NULL,
      NULL,
      7.712213,
      NULL,
      3.972974,
      1.625620,
      0.951675,
      NULL,
      NULL,
      NULL,
      0.521821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.113259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150058,
      NULL,
      NULL,
      1.612162,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.573678,
      0,
      0,
      NULL,
      NULL,
      2,
      0,
      2.665758,
      1,
      NULL,
      NULL,
      0.829874,
      NULL,
      NULL,
      1.511611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.108135,
      0,
      NULL,
      9.625983,
      6,
      4.663774,
      7.014290,
      6.671242,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.454176,
      3,
      0.095199,
      1,
      NULL,
      NULL,
      1,
      6.353039,
      0,
      1.520065,
      NULL,
      NULL,
      2,
      NULL,
      1.751291,
      0.108368,
      0,
      0,
      0,
      NULL,
      NULL,
      5.868958,
      3.744033,
      NULL,
      1.667277,
      9,
      4,
      2.275169,
      5.136394,
      4,
      1,
      NULL,
      1,
      0.528141,
      NULL,
      0.441628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505579,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.998817,
      NULL,
      NULL,
      0.247789,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.368795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611785,
      NULL,
      NULL,
      1.209076,
      NULL,
      0.002234,
      0.949596,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      534.705501,
      NULL,
      NULL,
      1.174414,
      2.123338,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.170896,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.380780,
      NULL,
      NULL,
      NULL,
      0.267226,
      NULL,
      NULL,
      NULL,
      1.576553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.409672,
      NULL,
      NULL,
      3.050319,
      2.689407,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.198726,
      0.780533,
      NULL,
      NULL,
      2.774617,
      3,
      NULL,
      NULL,
      NULL,
      1.497680,
      NULL,
      NULL,
      8,
      7.727179,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      159,
      NULL,
      0,
      NULL,
      NULL,
      0.813383,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.348254,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.440820,
      NULL,
      1.912504,
      0,
      NULL,
      1.912771,
      0.733049,
      0.585288,
      0,
      1,
      0,
      1,
      0.657210,
      NULL,
      1.191835,
      NULL,
      1,
      NULL,
      0,
      1,
      0.909459,
      1.093174,
      1.491822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984047,
      0.250809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.067607,
      NULL,
      NULL,
      NULL,
      1.894396,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.667565,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531924,
      1,
      NULL,
      1.115314,
      NULL,
      0.781279,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.188018,
      NULL,
      1.096312,
      NULL,
      0.973434,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.631283,
      NULL,
      0.872993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.404874,
      1.425735,
      0,
      0.528787,
      1.129883,
      NULL,
      0.001393,
      4,
      0,
      0.254797,
      NULL,
      NULL,
      1.836739,
      1.084660,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.844969,
      0,
      1,
      0,
      1.264522,
      0.677066,
      1.006303,
      1.522100,
      0,
      1,
      NULL,
      1.331468,
      1,
      0.460941,
      3.603689,
      NULL,
      0.277457,
      NULL,
      0.956467,
      3.430131,
      0.933829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772387,
      2.509760,
      NULL,
      1.581559,
      NULL,
      1,
      NULL,
      1.768266,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.807518,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.603017,
      NULL,
      0.550225,
      NULL,
      1,
      34.462377,
      2,
      NULL,
      0,
      0.601744,
      1.210825,
      1,
      NULL,
      0,
      1.482813,
      0,
      4,
      NULL,
      NULL,
      NULL,
      32.844194,
      110.963769,
      NULL,
      1.358372,
      3.065076,
      '12011',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      0,
      '',
      NULL,
      '');
commit;
end;
/


