set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7909684';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      '40',
      0,
      NULL,
      '0441321',
      NULL,
      0,
      4,
      0,
      '0210',
      1,
      0,
      NULL,
      NULL,
      ' 9-21-1976',
      20.766617,
      41,
      NULL,
      3,
      NULL,
      ' 3-13-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 1-17-1986',
      ' 5-22-1975',
      ' 9-28-1998',
      0.996549,
      0.695519,
      1.016196,
      1,
      NULL,
      1.465556,
      1.232989,
      2.771023,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.939623,
      NULL,
      NULL,
      0.779254,
      0.247356,
      0,
      0,
      0,
      1,
      1,
      2.602712,
      1,
      0.543842,
      1,
      2,
      4,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.865252,
      NULL,
      1.479010,
      4.567169,
      NULL,
      NULL,
      0.510632,
      NULL,
      1.757688,
      3.681719,
      NULL,
      NULL,
      1.929405,
      1,
      1.282459,
      NULL,
      NULL,
      0.231648,
      NULL,
      NULL,
      11.708336,
      0.538389,
      NULL,
      NULL,
      0,
      0,
      0,
      1.766249,
      0,
      NULL,
      3.407933,
      1,
      1,
      NULL,
      NULL,
      1.527491,
      NULL,
      0.251345,
      0.355654,
      NULL,
      NULL,
      0.571647,
      3.891576,
      NULL,
      0,
      3.600005,
      0,
      NULL,
      NULL,
      1.312214,
      NULL,
      NULL,
      4,
      5,
      NULL,
      0.685155,
      5.294252,
      1.734744,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.521510,
      0,
      0,
      1.258884,
      0,
      1,
      NULL,
      1.878382,
      3,
      NULL,
      1.357428,
      0.777505,
      0,
      2.707170,
      NULL,
      0,
      1.376098,
      4.293248,
      1,
      1,
      3,
      0.743803,
      1,
      5,
      NULL,
      7,
      3.322560,
      1.987816,
      1.098449,
      2,
      4,
      1.669302,
      0.674475,
      NULL,
      0,
      '11-10-1986',
      13.752554,
      NULL,
      11.518339,
      NULL,
      NULL,
      0,
      2.236631,
      3.812129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.247692,
      1,
      3,
      1,
      NULL,
      0,
      8.342136,
      3.018617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.483175,
      NULL,
      2.213796,
      NULL,
      1,
      1.918406,
      NULL,
      0,
      0,
      0,
      1.229322,
      1.043049,
      NULL,
      3,
      1.027948,
      NULL,
      NULL,
      5,
      0.068985,
      0.443974,
      1.152625,
      1,
      0.423634,
      2,
      2,
      2.413267,
      1.707751,
      0,
      7,
      0.921428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.819191,
      NULL,
      1.324380,
      NULL,
      0,
      0,
      3,
      34.756887,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.278401,
      1.695272,
      NULL,
      1,
      2,
      NULL,
      2.855855,
      0,
      3,
      0.513689,
      1.203886,
      1.780001,
      2.629023,
      2.201037,
      1,
      2,
      3.996723,
      1.169907,
      0,
      3,
      NULL,
      0,
      0,
      1.213001,
      0,
      1,
      NULL,
      0,
      1,
      1.084622,
      0.033741,
      1.035286,
      3,
      2,
      2.044035,
      8.924595,
      NULL,
      5.117514,
      3,
      2,
      6.640856,
      1,
      3,
      1.537884,
      3.904636,
      2.613896,
      3,
      25.217316,
      NULL,
      27,
      79,
      0.061730,
      NULL,
      1.137893,
      '44223',
      '2333',
      '',
      1.036133,
      '',
      NULL,
      '',
      0.576083,
      '',
      '',
      '',
      0,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      112,
      NULL,
      NULL,
      NULL,
      0.112790,
      NULL,
      NULL,
      1.944583,
      NULL,
      NULL,
      1.424102,
      NULL,
      NULL,
      0.634461,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3379.443893,
      1,
      NULL,
      1.296213,
      1,
      0.508946,
      NULL,
      0.222062,
      0.427590,
      0.236527,
      0.161657,
      0.020845,
      0,
      0,
      1,
      1,
      0.669728,
      0.037429,
      1.680031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752421,
      0.132198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715562,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710881,
      NULL,
      1.917286,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2.922897,
      3.445946,
      2,
      NULL,
      4,
      2.093502,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      1.460156,
      NULL,
      0.167787,
      1.235786,
      NULL,
      0.212538,
      NULL,
      NULL,
      0,
      0.596274,
      NULL,
      1.845719,
      0.517001,
      NULL,
      0.125452,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.841557,
      1.112521,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496258,
      NULL,
      0.394603,
      NULL,
      NULL,
      2.036301,
      3.015281,
      1,
      NULL,
      NULL,
      NULL,
      56.410125,
      0.472396,
      4,
      3,
      '00340',
      '4132',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


