set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9666881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      '23',
      NULL,
      0.335414,
      '3033410',
      2.278507,
      NULL,
      3,
      NULL,
      '2224',
      5,
      0.643421,
      NULL,
      NULL,
      ' 5-15-1982',
      45.540308,
      26,
      NULL,
      NULL,
      1.159035,
      ' 5-24-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1999',
      NULL,
      ' 0-26-2001',
      1.363555,
      3.410296,
      3,
      0,
      0,
      0,
      8,
      0.581725,
      0.855602,
      1.950272,
      9,
      0,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      2.523701,
      1.031486,
      NULL,
      0.911137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.387797,
      2,
      NULL,
      3.873874,
      1,
      0.646262,
      1.859023,
      1,
      NULL,
      0,
      1.486157,
      0,
      1,
      1.763202,
      NULL,
      5.510364,
      1,
      3,
      0.632055,
      0,
      0.376198,
      NULL,
      NULL,
      1.704172,
      NULL,
      NULL,
      2,
      1,
      1,
      1.406745,
      0,
      0.895994,
      0.362413,
      1.142670,
      0,
      2,
      2,
      1,
      0.108903,
      2.389404,
      NULL,
      0.314035,
      2.143315,
      3,
      0.375744,
      1.318950,
      1,
      0.564039,
      NULL,
      1,
      0,
      1.050937,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806076,
      0.513042,
      5.013513,
      1.685850,
      5.925116,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1.467644,
      1,
      NULL,
      NULL,
      1.089073,
      NULL,
      NULL,
      1.161271,
      NULL,
      NULL,
      0.684630,
      1.222028,
      NULL,
      3,
      5.080448,
      3,
      0,
      2,
      0,
      2,
      0.282326,
      1.470635,
      0,
      1,
      0,
      5,
      3,
      5,
      NULL,
      6.944625,
      0.774275,
      9,
      1.547402,
      10.562347,
      1,
      2,
      ' 6-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.198100,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254483,
      NULL,
      1.259548,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.764303,
      NULL,
      2.665098,
      2.592301,
      1.699287,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.529807,
      3,
      5,
      0.331467,
      0,
      1,
      5.644845,
      0.119718,
      NULL,
      NULL,
      1,
      1,
      1.105435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747422,
      3,
      0.667156,
      0.667043,
      0.246323,
      0.344572,
      1,
      3.577239,
      12.413415,
      1,
      2.118329,
      109,
      128,
      2.996223,
      3.183678,
      1,
      3.087152,
      2.599098,
      3,
      NULL,
      1.545789,
      0.035826,
      1.791549,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      15.765501,
      84,
      0,
      NULL,
      1,
      '02401',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      2,
      '1422',
      NULL,
      '',
      2,
      NULL,
      221,
      88,
      2.628597,
      NULL,
      3,
      4.626334,
      0.222818,
      0,
      NULL,
      0.311999,
      1.868674,
      NULL,
      NULL,
      1.256379,
      NULL,
      NULL,
      0.661790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.508009,
      3,
      1.853241,
      1.078037,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0.869098,
      0,
      0,
      NULL,
      3.103641,
      5.971328,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.778742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.633721,
      1,
      0,
      1,
      2.540665,
      0,
      3,
      3.834742,
      1.666664,
      0,
      3,
      3.767073,
      3.542599,
      1,
      NULL,
      NULL,
      1.591677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450925,
      1,
      0,
      NULL,
      NULL,
      1.249920,
      0.114998,
      2.925925,
      0.631333,
      NULL,
      NULL,
      1.452952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604984,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.987436,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.969316,
      NULL,
      0.656505,
      1.028514,
      NULL,
      NULL,
      0,
      1,
      3.090098,
      1,
      NULL,
      NULL,
      NULL,
      4,
      3.064513,
      1,
      4.705819,
      4,
      0.139766,
      NULL,
      NULL,
      3.346590,
      1,
      0,
      0,
      NULL,
      1.085088,
      3,
      1,
      3,
      0.603677,
      2,
      2.471294,
      1,
      1,
      3,
      3,
      NULL,
      1.571124,
      NULL,
      0.130750,
      0,
      3,
      0,
      2.446567,
      6.372795,
      1.244691,
      4.799821,
      5.010167,
      0.564006,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0.739728,
      0,
      1,
      0,
      NULL,
      NULL,
      1.651321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970457,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.246416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738751,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.060308,
      3,
      0.913653,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98.402758,
      NULL,
      NULL,
      NULL,
      2.772454,
      NULL,
      NULL,
      NULL,
      1.594404,
      NULL,
      NULL,
      NULL,
      3.081646,
      NULL,
      NULL,
      NULL,
      0.376892,
      NULL,
      NULL,
      NULL,
      1.095621,
      NULL,
      NULL,
      NULL,
      2.769656,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.662089,
      NULL,
      NULL,
      NULL,
      1.306221,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.451004,
      NULL,
      NULL,
      NULL,
      2.223661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      5.299612,
      NULL,
      6,
      NULL,
      85.307878,
      26,
      3.420443,
      150.607956,
      3,
      0,
      NULL,
      NULL,
      0.444757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225252,
      NULL,
      NULL,
      0,
      NULL,
      1.810626,
      NULL,
      NULL,
      0.916847,
      1.953351,
      1.599896,
      1.644607,
      1.621799,
      0.334288,
      0,
      0,
      0.412097,
      1.732945,
      1.650357,
      1.108902,
      0.516780,
      0.457538,
      0,
      0,
      1,
      2.653672,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.881210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454097,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493187,
      NULL,
      0,
      NULL,
      1.336066,
      NULL,
      5.134769,
      NULL,
      6.732164,
      2,
      0.849378,
      0,
      20.216059,
      6.987624,
      5,
      NULL,
      1.456899,
      '01140',
      '',
      NULL,
      0.081768,
      '',
      '',
      NULL,
      2,
      '2011',
      '',
      '');
commit;
end;
/


